/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.service.entity.diskann;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.common.DiskANNCoreState;
import io.dingodb.sdk.service.entity.common.ResponseInfo;
import io.dingodb.sdk.service.entity.error.Error;
import io.dingodb.sdk.service.entity.index.VectorWithDistanceResult;
import java.util.List;

public class VectorSearchResponse
implements Message,
Message.Response {
    private Error error;
    private ResponseInfo responseInfo;
    private Error lastError;
    private List<VectorWithDistanceResult> batchResults;
    private DiskANNCoreState state;
    private long ts;
    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write((Integer)1, (Message)this.responseInfo, out);
        Writer.write((Integer)2, (Message)this.error, out);
        Writer.write((Integer)3, this.batchResults, (n, v) -> Writer.write(n, (Message)v, out));
        Writer.write((Integer)4, this.ts, out);
        Writer.write((Integer)5, (Message)this.lastError, out);
        Writer.write((Integer)6, this.state, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        block8: while ((number = Reader.readNumber(input)) != 0) {
            switch (number) {
                case 1: {
                    this.responseInfo = Reader.readMessage(new ResponseInfo(), input);
                    hasValue = hasValue ? hasValue : this.responseInfo != null;
                    continue block8;
                }
                case 2: {
                    this.error = Reader.readMessage(new Error(), input);
                    hasValue = hasValue ? hasValue : this.error != null;
                    continue block8;
                }
                case 3: {
                    this.batchResults = Reader.readList(this.batchResults, input, in -> Reader.readMessage(new VectorWithDistanceResult(), in));
                    hasValue = true;
                    continue block8;
                }
                case 4: {
                    this.ts = Reader.readLong(input);
                    hasValue = true;
                    continue block8;
                }
                case 5: {
                    this.lastError = Reader.readMessage(new Error(), input);
                    hasValue = hasValue ? hasValue : this.lastError != null;
                    continue block8;
                }
                case 6: {
                    this.state = DiskANNCoreState.forNumber(Reader.readInt(input));
                    hasValue = true;
                    continue block8;
                }
            }
            Reader.skip(input);
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf((Integer)1, (Message)this.responseInfo).intValue();
        size += SizeUtils.sizeOf((Integer)2, (Message)this.error).intValue();
        size += SizeUtils.sizeOf(3, this.batchResults, SizeUtils::sizeOf);
        size += SizeUtils.sizeOf((Integer)4, this.ts).intValue();
        size += SizeUtils.sizeOf((Integer)5, (Message)this.lastError).intValue();
        return size += SizeUtils.sizeOf((Integer)6, this.state).intValue();
    }

    protected VectorSearchResponse(VectorSearchResponseBuilder<?, ?> b) {
        this.error = b.error;
        this.responseInfo = b.responseInfo;
        this.lastError = b.lastError;
        this.batchResults = b.batchResults;
        this.state = b.state;
        this.ts = b.ts;
        this.ext$ = b.ext$;
    }

    public static VectorSearchResponseBuilder<?, ?> builder() {
        return new VectorSearchResponseBuilderImpl();
    }

    @Override
    public Error getError() {
        return this.error;
    }

    @Override
    public ResponseInfo getResponseInfo() {
        return this.responseInfo;
    }

    public Error getLastError() {
        return this.lastError;
    }

    public List<VectorWithDistanceResult> getBatchResults() {
        return this.batchResults;
    }

    public DiskANNCoreState getState() {
        return this.state;
    }

    public long getTs() {
        return this.ts;
    }

    @Override
    public Object getExt$() {
        return this.ext$;
    }

    public void setError(Error error) {
        this.error = error;
    }

    @Override
    public void setResponseInfo(ResponseInfo responseInfo) {
        this.responseInfo = responseInfo;
    }

    public void setLastError(Error lastError) {
        this.lastError = lastError;
    }

    public void setBatchResults(List<VectorWithDistanceResult> batchResults) {
        this.batchResults = batchResults;
    }

    public void setState(DiskANNCoreState state) {
        this.state = state;
    }

    public void setTs(long ts) {
        this.ts = ts;
    }

    @Override
    public void setExt$(Object ext$) {
        this.ext$ = ext$;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VectorSearchResponse)) {
            return false;
        }
        VectorSearchResponse other = (VectorSearchResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTs() != other.getTs()) {
            return false;
        }
        Error this$error = this.getError();
        Error other$error = other.getError();
        if (this$error == null ? other$error != null : !((Object)this$error).equals(other$error)) {
            return false;
        }
        ResponseInfo this$responseInfo = this.getResponseInfo();
        ResponseInfo other$responseInfo = other.getResponseInfo();
        if (this$responseInfo == null ? other$responseInfo != null : !((Object)this$responseInfo).equals(other$responseInfo)) {
            return false;
        }
        Error this$lastError = this.getLastError();
        Error other$lastError = other.getLastError();
        if (this$lastError == null ? other$lastError != null : !((Object)this$lastError).equals(other$lastError)) {
            return false;
        }
        List<VectorWithDistanceResult> this$batchResults = this.getBatchResults();
        List<VectorWithDistanceResult> other$batchResults = other.getBatchResults();
        if (this$batchResults == null ? other$batchResults != null : !((Object)this$batchResults).equals(other$batchResults)) {
            return false;
        }
        DiskANNCoreState this$state = this.getState();
        DiskANNCoreState other$state = other.getState();
        if (this$state == null ? other$state != null : !this$state.equals(other$state)) {
            return false;
        }
        Object this$ext$ = this.getExt$();
        Object other$ext$ = other.getExt$();
        return !(this$ext$ == null ? other$ext$ != null : !this$ext$.equals(other$ext$));
    }

    protected boolean canEqual(Object other) {
        return other instanceof VectorSearchResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $ts = this.getTs();
        result = result * 59 + (int)($ts >>> 32 ^ $ts);
        Error $error = this.getError();
        result = result * 59 + ($error == null ? 43 : ((Object)$error).hashCode());
        ResponseInfo $responseInfo = this.getResponseInfo();
        result = result * 59 + ($responseInfo == null ? 43 : ((Object)$responseInfo).hashCode());
        Error $lastError = this.getLastError();
        result = result * 59 + ($lastError == null ? 43 : ((Object)$lastError).hashCode());
        List<VectorWithDistanceResult> $batchResults = this.getBatchResults();
        result = result * 59 + ($batchResults == null ? 43 : ((Object)$batchResults).hashCode());
        DiskANNCoreState $state = this.getState();
        result = result * 59 + ($state == null ? 43 : $state.hashCode());
        Object $ext$ = this.getExt$();
        result = result * 59 + ($ext$ == null ? 43 : $ext$.hashCode());
        return result;
    }

    public String toString() {
        return "VectorSearchResponse(error=" + String.valueOf(this.getError()) + ", responseInfo=" + String.valueOf(this.getResponseInfo()) + ", lastError=" + String.valueOf(this.getLastError()) + ", batchResults=" + String.valueOf(this.getBatchResults()) + ", state=" + String.valueOf(this.getState()) + ", ts=" + this.getTs() + ", ext$=" + String.valueOf(this.getExt$()) + ")";
    }

    public VectorSearchResponse() {
    }

    public static abstract class VectorSearchResponseBuilder<C extends VectorSearchResponse, B extends VectorSearchResponseBuilder<C, B>> {
        private Error error;
        private ResponseInfo responseInfo;
        private Error lastError;
        private List<VectorWithDistanceResult> batchResults;
        private DiskANNCoreState state;
        private long ts;
        private Object ext$;

        protected abstract B self();

        public abstract C build();

        public B error(Error error) {
            this.error = error;
            return this.self();
        }

        public B responseInfo(ResponseInfo responseInfo) {
            this.responseInfo = responseInfo;
            return this.self();
        }

        public B lastError(Error lastError) {
            this.lastError = lastError;
            return this.self();
        }

        public B batchResults(List<VectorWithDistanceResult> batchResults) {
            this.batchResults = batchResults;
            return this.self();
        }

        public B state(DiskANNCoreState state) {
            this.state = state;
            return this.self();
        }

        public B ts(long ts) {
            this.ts = ts;
            return this.self();
        }

        public B ext$(Object ext$) {
            this.ext$ = ext$;
            return this.self();
        }

        public String toString() {
            return "VectorSearchResponse.VectorSearchResponseBuilder(error=" + String.valueOf(this.error) + ", responseInfo=" + String.valueOf(this.responseInfo) + ", lastError=" + String.valueOf(this.lastError) + ", batchResults=" + String.valueOf(this.batchResults) + ", state=" + String.valueOf(this.state) + ", ts=" + this.ts + ", ext$=" + String.valueOf(this.ext$) + ")";
        }
    }

    private static final class VectorSearchResponseBuilderImpl
    extends VectorSearchResponseBuilder<VectorSearchResponse, VectorSearchResponseBuilderImpl> {
        private VectorSearchResponseBuilderImpl() {
        }

        @Override
        protected VectorSearchResponseBuilderImpl self() {
            return this;
        }

        @Override
        public VectorSearchResponse build() {
            return new VectorSearchResponse(this);
        }
    }

    public static final class Fields {
        public static final String error = "error";
        public static final String responseInfo = "responseInfo";
        public static final String lastError = "lastError";
        public static final String batchResults = "batchResults";
        public static final String state = "state";
        public static final String ts = "ts";
        public static final String ext$ = "ext$";
    }
}

