/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.service.entity.diskann;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.common.RequestInfo;
import io.dingodb.sdk.service.entity.common.SearchDiskAnnParam;
import io.dingodb.sdk.service.entity.common.Vector;
import java.util.List;

public class VectorSearchRequest
implements Message,
Message.Request {
    private SearchDiskAnnParam searchParam;
    private RequestInfo requestInfo;
    private List<Vector> vectors;
    private int topN;
    private long vectorIndexId;
    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write((Integer)1, (Message)this.requestInfo, out);
        Writer.write((Integer)2, this.vectorIndexId, out);
        Writer.write((Integer)3, this.topN, out);
        Writer.write((Integer)4, (Message)this.searchParam, out);
        Writer.write((Integer)5, this.vectors, (n, v) -> Writer.write(n, (Message)v, out));
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        block7: while ((number = Reader.readNumber(input)) != 0) {
            switch (number) {
                case 1: {
                    this.requestInfo = Reader.readMessage(new RequestInfo(), input);
                    hasValue = hasValue ? hasValue : this.requestInfo != null;
                    continue block7;
                }
                case 2: {
                    this.vectorIndexId = Reader.readLong(input);
                    hasValue = true;
                    continue block7;
                }
                case 3: {
                    this.topN = Reader.readInt(input);
                    hasValue = true;
                    continue block7;
                }
                case 4: {
                    this.searchParam = Reader.readMessage(new SearchDiskAnnParam(), input);
                    hasValue = hasValue ? hasValue : this.searchParam != null;
                    continue block7;
                }
                case 5: {
                    this.vectors = Reader.readList(this.vectors, input, in -> Reader.readMessage(new Vector(), in));
                    hasValue = true;
                    continue block7;
                }
            }
            Reader.skip(input);
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf((Integer)1, (Message)this.requestInfo).intValue();
        size += SizeUtils.sizeOf((Integer)2, this.vectorIndexId).intValue();
        size += SizeUtils.sizeOf((Integer)3, this.topN).intValue();
        size += SizeUtils.sizeOf((Integer)4, (Message)this.searchParam).intValue();
        return size += SizeUtils.sizeOf(5, this.vectors, SizeUtils::sizeOf);
    }

    protected VectorSearchRequest(VectorSearchRequestBuilder<?, ?> b) {
        this.searchParam = b.searchParam;
        this.requestInfo = b.requestInfo;
        this.vectors = b.vectors;
        this.topN = b.topN;
        this.vectorIndexId = b.vectorIndexId;
        this.ext$ = b.ext$;
    }

    public static VectorSearchRequestBuilder<?, ?> builder() {
        return new VectorSearchRequestBuilderImpl();
    }

    public SearchDiskAnnParam getSearchParam() {
        return this.searchParam;
    }

    @Override
    public RequestInfo getRequestInfo() {
        return this.requestInfo;
    }

    public List<Vector> getVectors() {
        return this.vectors;
    }

    public int getTopN() {
        return this.topN;
    }

    public long getVectorIndexId() {
        return this.vectorIndexId;
    }

    @Override
    public Object getExt$() {
        return this.ext$;
    }

    public void setSearchParam(SearchDiskAnnParam searchParam) {
        this.searchParam = searchParam;
    }

    @Override
    public void setRequestInfo(RequestInfo requestInfo) {
        this.requestInfo = requestInfo;
    }

    public void setVectors(List<Vector> vectors) {
        this.vectors = vectors;
    }

    public void setTopN(int topN) {
        this.topN = topN;
    }

    public void setVectorIndexId(long vectorIndexId) {
        this.vectorIndexId = vectorIndexId;
    }

    @Override
    public void setExt$(Object ext$) {
        this.ext$ = ext$;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VectorSearchRequest)) {
            return false;
        }
        VectorSearchRequest other = (VectorSearchRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTopN() != other.getTopN()) {
            return false;
        }
        if (this.getVectorIndexId() != other.getVectorIndexId()) {
            return false;
        }
        SearchDiskAnnParam this$searchParam = this.getSearchParam();
        SearchDiskAnnParam other$searchParam = other.getSearchParam();
        if (this$searchParam == null ? other$searchParam != null : !((Object)this$searchParam).equals(other$searchParam)) {
            return false;
        }
        RequestInfo this$requestInfo = this.getRequestInfo();
        RequestInfo other$requestInfo = other.getRequestInfo();
        if (this$requestInfo == null ? other$requestInfo != null : !((Object)this$requestInfo).equals(other$requestInfo)) {
            return false;
        }
        List<Vector> this$vectors = this.getVectors();
        List<Vector> other$vectors = other.getVectors();
        if (this$vectors == null ? other$vectors != null : !((Object)this$vectors).equals(other$vectors)) {
            return false;
        }
        Object this$ext$ = this.getExt$();
        Object other$ext$ = other.getExt$();
        return !(this$ext$ == null ? other$ext$ != null : !this$ext$.equals(other$ext$));
    }

    protected boolean canEqual(Object other) {
        return other instanceof VectorSearchRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getTopN();
        long $vectorIndexId = this.getVectorIndexId();
        result = result * 59 + (int)($vectorIndexId >>> 32 ^ $vectorIndexId);
        SearchDiskAnnParam $searchParam = this.getSearchParam();
        result = result * 59 + ($searchParam == null ? 43 : ((Object)$searchParam).hashCode());
        RequestInfo $requestInfo = this.getRequestInfo();
        result = result * 59 + ($requestInfo == null ? 43 : ((Object)$requestInfo).hashCode());
        List<Vector> $vectors = this.getVectors();
        result = result * 59 + ($vectors == null ? 43 : ((Object)$vectors).hashCode());
        Object $ext$ = this.getExt$();
        result = result * 59 + ($ext$ == null ? 43 : $ext$.hashCode());
        return result;
    }

    public String toString() {
        return "VectorSearchRequest(searchParam=" + String.valueOf(this.getSearchParam()) + ", requestInfo=" + String.valueOf(this.getRequestInfo()) + ", vectors=" + String.valueOf(this.getVectors()) + ", topN=" + this.getTopN() + ", vectorIndexId=" + this.getVectorIndexId() + ", ext$=" + String.valueOf(this.getExt$()) + ")";
    }

    public VectorSearchRequest() {
    }

    public static abstract class VectorSearchRequestBuilder<C extends VectorSearchRequest, B extends VectorSearchRequestBuilder<C, B>> {
        private SearchDiskAnnParam searchParam;
        private RequestInfo requestInfo;
        private List<Vector> vectors;
        private int topN;
        private long vectorIndexId;
        private Object ext$;

        protected abstract B self();

        public abstract C build();

        public B searchParam(SearchDiskAnnParam searchParam) {
            this.searchParam = searchParam;
            return this.self();
        }

        public B requestInfo(RequestInfo requestInfo) {
            this.requestInfo = requestInfo;
            return this.self();
        }

        public B vectors(List<Vector> vectors) {
            this.vectors = vectors;
            return this.self();
        }

        public B topN(int topN) {
            this.topN = topN;
            return this.self();
        }

        public B vectorIndexId(long vectorIndexId) {
            this.vectorIndexId = vectorIndexId;
            return this.self();
        }

        public B ext$(Object ext$) {
            this.ext$ = ext$;
            return this.self();
        }

        public String toString() {
            return "VectorSearchRequest.VectorSearchRequestBuilder(searchParam=" + String.valueOf(this.searchParam) + ", requestInfo=" + String.valueOf(this.requestInfo) + ", vectors=" + String.valueOf(this.vectors) + ", topN=" + this.topN + ", vectorIndexId=" + this.vectorIndexId + ", ext$=" + String.valueOf(this.ext$) + ")";
        }
    }

    private static final class VectorSearchRequestBuilderImpl
    extends VectorSearchRequestBuilder<VectorSearchRequest, VectorSearchRequestBuilderImpl> {
        private VectorSearchRequestBuilderImpl() {
        }

        @Override
        protected VectorSearchRequestBuilderImpl self() {
            return this;
        }

        @Override
        public VectorSearchRequest build() {
            return new VectorSearchRequest(this);
        }
    }

    public static final class Fields {
        public static final String searchParam = "searchParam";
        public static final String requestInfo = "requestInfo";
        public static final String vectors = "vectors";
        public static final String topN = "topN";
        public static final String vectorIndexId = "vectorIndexId";
        public static final String ext$ = "ext$";
    }
}

