/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.service.entity.diskann;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.common.RequestInfo;
import io.dingodb.sdk.service.entity.common.Vector;
import io.dingodb.sdk.service.entity.error.Errno;
import java.util.List;

public class VectorPushDataRequest
implements Message,
Message.Request {
    private Errno error;
    private long alreadySendVectorCount;
    private boolean forceToLoadDataIfExist;
    private List<Long> vectorIds;
    private long tso;
    private long ts;
    private boolean hasMore;
    private RequestInfo requestInfo;
    private List<Vector> vectors;
    private long vectorIndexId;
    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write((Integer)1, (Message)this.requestInfo, out);
        Writer.write((Integer)2, this.vectorIndexId, out);
        Writer.write((Integer)3, this.vectors, (n, v) -> Writer.write(n, (Message)v, out));
        Writer.write(4, this.vectorIds, out, Writer::write, SizeUtils::sizeOf);
        Writer.write((Integer)5, this.hasMore, out);
        Writer.write((Integer)6, this.error, out);
        Writer.write((Integer)7, this.forceToLoadDataIfExist, out);
        Writer.write((Integer)8, this.alreadySendVectorCount, out);
        Writer.write((Integer)9, this.ts, out);
        Writer.write((Integer)10, this.tso, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        block12: while ((number = Reader.readNumber(input)) != 0) {
            switch (number) {
                case 1: {
                    this.requestInfo = Reader.readMessage(new RequestInfo(), input);
                    hasValue = hasValue ? hasValue : this.requestInfo != null;
                    continue block12;
                }
                case 2: {
                    this.vectorIndexId = Reader.readLong(input);
                    hasValue = true;
                    continue block12;
                }
                case 3: {
                    this.vectors = Reader.readList(this.vectors, input, in -> Reader.readMessage(new Vector(), in));
                    hasValue = true;
                    continue block12;
                }
                case 4: {
                    this.vectorIds = Reader.readPack(input, Reader::readLong);
                    hasValue = true;
                    continue block12;
                }
                case 5: {
                    this.hasMore = Reader.readBoolean(input);
                    hasValue = true;
                    continue block12;
                }
                case 6: {
                    this.error = Errno.forNumber(Reader.readInt(input));
                    hasValue = true;
                    continue block12;
                }
                case 7: {
                    this.forceToLoadDataIfExist = Reader.readBoolean(input);
                    hasValue = true;
                    continue block12;
                }
                case 8: {
                    this.alreadySendVectorCount = Reader.readLong(input);
                    hasValue = true;
                    continue block12;
                }
                case 9: {
                    this.ts = Reader.readLong(input);
                    hasValue = true;
                    continue block12;
                }
                case 10: {
                    this.tso = Reader.readLong(input);
                    hasValue = true;
                    continue block12;
                }
            }
            Reader.skip(input);
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf((Integer)1, (Message)this.requestInfo).intValue();
        size += SizeUtils.sizeOf((Integer)2, this.vectorIndexId).intValue();
        size += SizeUtils.sizeOf(3, this.vectors, SizeUtils::sizeOf);
        size += SizeUtils.sizeOfPack(4, this.vectorIds, SizeUtils::sizeOf);
        size += SizeUtils.sizeOf((Integer)5, this.hasMore).intValue();
        size += SizeUtils.sizeOf((Integer)6, this.error).intValue();
        size += SizeUtils.sizeOf((Integer)7, this.forceToLoadDataIfExist).intValue();
        size += SizeUtils.sizeOf((Integer)8, this.alreadySendVectorCount).intValue();
        size += SizeUtils.sizeOf((Integer)9, this.ts).intValue();
        return size += SizeUtils.sizeOf((Integer)10, this.tso).intValue();
    }

    protected VectorPushDataRequest(VectorPushDataRequestBuilder<?, ?> b) {
        this.error = b.error;
        this.alreadySendVectorCount = b.alreadySendVectorCount;
        this.forceToLoadDataIfExist = b.forceToLoadDataIfExist;
        this.vectorIds = b.vectorIds;
        this.tso = b.tso;
        this.ts = b.ts;
        this.hasMore = b.hasMore;
        this.requestInfo = b.requestInfo;
        this.vectors = b.vectors;
        this.vectorIndexId = b.vectorIndexId;
        this.ext$ = b.ext$;
    }

    public static VectorPushDataRequestBuilder<?, ?> builder() {
        return new VectorPushDataRequestBuilderImpl();
    }

    public Errno getError() {
        return this.error;
    }

    public long getAlreadySendVectorCount() {
        return this.alreadySendVectorCount;
    }

    public boolean isForceToLoadDataIfExist() {
        return this.forceToLoadDataIfExist;
    }

    public List<Long> getVectorIds() {
        return this.vectorIds;
    }

    public long getTso() {
        return this.tso;
    }

    public long getTs() {
        return this.ts;
    }

    public boolean isHasMore() {
        return this.hasMore;
    }

    @Override
    public RequestInfo getRequestInfo() {
        return this.requestInfo;
    }

    public List<Vector> getVectors() {
        return this.vectors;
    }

    public long getVectorIndexId() {
        return this.vectorIndexId;
    }

    @Override
    public Object getExt$() {
        return this.ext$;
    }

    public void setError(Errno error) {
        this.error = error;
    }

    public void setAlreadySendVectorCount(long alreadySendVectorCount) {
        this.alreadySendVectorCount = alreadySendVectorCount;
    }

    public void setForceToLoadDataIfExist(boolean forceToLoadDataIfExist) {
        this.forceToLoadDataIfExist = forceToLoadDataIfExist;
    }

    public void setVectorIds(List<Long> vectorIds) {
        this.vectorIds = vectorIds;
    }

    public void setTso(long tso) {
        this.tso = tso;
    }

    public void setTs(long ts) {
        this.ts = ts;
    }

    public void setHasMore(boolean hasMore) {
        this.hasMore = hasMore;
    }

    @Override
    public void setRequestInfo(RequestInfo requestInfo) {
        this.requestInfo = requestInfo;
    }

    public void setVectors(List<Vector> vectors) {
        this.vectors = vectors;
    }

    public void setVectorIndexId(long vectorIndexId) {
        this.vectorIndexId = vectorIndexId;
    }

    @Override
    public void setExt$(Object ext$) {
        this.ext$ = ext$;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VectorPushDataRequest)) {
            return false;
        }
        VectorPushDataRequest other = (VectorPushDataRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getAlreadySendVectorCount() != other.getAlreadySendVectorCount()) {
            return false;
        }
        if (this.isForceToLoadDataIfExist() != other.isForceToLoadDataIfExist()) {
            return false;
        }
        if (this.getTso() != other.getTso()) {
            return false;
        }
        if (this.getTs() != other.getTs()) {
            return false;
        }
        if (this.isHasMore() != other.isHasMore()) {
            return false;
        }
        if (this.getVectorIndexId() != other.getVectorIndexId()) {
            return false;
        }
        Errno this$error = this.getError();
        Errno other$error = other.getError();
        if (this$error == null ? other$error != null : !this$error.equals(other$error)) {
            return false;
        }
        List<Long> this$vectorIds = this.getVectorIds();
        List<Long> other$vectorIds = other.getVectorIds();
        if (this$vectorIds == null ? other$vectorIds != null : !((Object)this$vectorIds).equals(other$vectorIds)) {
            return false;
        }
        RequestInfo this$requestInfo = this.getRequestInfo();
        RequestInfo other$requestInfo = other.getRequestInfo();
        if (this$requestInfo == null ? other$requestInfo != null : !((Object)this$requestInfo).equals(other$requestInfo)) {
            return false;
        }
        List<Vector> this$vectors = this.getVectors();
        List<Vector> other$vectors = other.getVectors();
        if (this$vectors == null ? other$vectors != null : !((Object)this$vectors).equals(other$vectors)) {
            return false;
        }
        Object this$ext$ = this.getExt$();
        Object other$ext$ = other.getExt$();
        return !(this$ext$ == null ? other$ext$ != null : !this$ext$.equals(other$ext$));
    }

    protected boolean canEqual(Object other) {
        return other instanceof VectorPushDataRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $alreadySendVectorCount = this.getAlreadySendVectorCount();
        result = result * 59 + (int)($alreadySendVectorCount >>> 32 ^ $alreadySendVectorCount);
        result = result * 59 + (this.isForceToLoadDataIfExist() ? 79 : 97);
        long $tso = this.getTso();
        result = result * 59 + (int)($tso >>> 32 ^ $tso);
        long $ts = this.getTs();
        result = result * 59 + (int)($ts >>> 32 ^ $ts);
        result = result * 59 + (this.isHasMore() ? 79 : 97);
        long $vectorIndexId = this.getVectorIndexId();
        result = result * 59 + (int)($vectorIndexId >>> 32 ^ $vectorIndexId);
        Errno $error = this.getError();
        result = result * 59 + ($error == null ? 43 : $error.hashCode());
        List<Long> $vectorIds = this.getVectorIds();
        result = result * 59 + ($vectorIds == null ? 43 : ((Object)$vectorIds).hashCode());
        RequestInfo $requestInfo = this.getRequestInfo();
        result = result * 59 + ($requestInfo == null ? 43 : ((Object)$requestInfo).hashCode());
        List<Vector> $vectors = this.getVectors();
        result = result * 59 + ($vectors == null ? 43 : ((Object)$vectors).hashCode());
        Object $ext$ = this.getExt$();
        result = result * 59 + ($ext$ == null ? 43 : $ext$.hashCode());
        return result;
    }

    public String toString() {
        return "VectorPushDataRequest(error=" + String.valueOf(this.getError()) + ", alreadySendVectorCount=" + this.getAlreadySendVectorCount() + ", forceToLoadDataIfExist=" + this.isForceToLoadDataIfExist() + ", vectorIds=" + String.valueOf(this.getVectorIds()) + ", tso=" + this.getTso() + ", ts=" + this.getTs() + ", hasMore=" + this.isHasMore() + ", requestInfo=" + String.valueOf(this.getRequestInfo()) + ", vectors=" + String.valueOf(this.getVectors()) + ", vectorIndexId=" + this.getVectorIndexId() + ", ext$=" + String.valueOf(this.getExt$()) + ")";
    }

    public VectorPushDataRequest() {
    }

    public static abstract class VectorPushDataRequestBuilder<C extends VectorPushDataRequest, B extends VectorPushDataRequestBuilder<C, B>> {
        private Errno error;
        private long alreadySendVectorCount;
        private boolean forceToLoadDataIfExist;
        private List<Long> vectorIds;
        private long tso;
        private long ts;
        private boolean hasMore;
        private RequestInfo requestInfo;
        private List<Vector> vectors;
        private long vectorIndexId;
        private Object ext$;

        protected abstract B self();

        public abstract C build();

        public B error(Errno error) {
            this.error = error;
            return this.self();
        }

        public B alreadySendVectorCount(long alreadySendVectorCount) {
            this.alreadySendVectorCount = alreadySendVectorCount;
            return this.self();
        }

        public B forceToLoadDataIfExist(boolean forceToLoadDataIfExist) {
            this.forceToLoadDataIfExist = forceToLoadDataIfExist;
            return this.self();
        }

        public B vectorIds(List<Long> vectorIds) {
            this.vectorIds = vectorIds;
            return this.self();
        }

        public B tso(long tso) {
            this.tso = tso;
            return this.self();
        }

        public B ts(long ts) {
            this.ts = ts;
            return this.self();
        }

        public B hasMore(boolean hasMore) {
            this.hasMore = hasMore;
            return this.self();
        }

        public B requestInfo(RequestInfo requestInfo) {
            this.requestInfo = requestInfo;
            return this.self();
        }

        public B vectors(List<Vector> vectors) {
            this.vectors = vectors;
            return this.self();
        }

        public B vectorIndexId(long vectorIndexId) {
            this.vectorIndexId = vectorIndexId;
            return this.self();
        }

        public B ext$(Object ext$) {
            this.ext$ = ext$;
            return this.self();
        }

        public String toString() {
            return "VectorPushDataRequest.VectorPushDataRequestBuilder(error=" + String.valueOf(this.error) + ", alreadySendVectorCount=" + this.alreadySendVectorCount + ", forceToLoadDataIfExist=" + this.forceToLoadDataIfExist + ", vectorIds=" + String.valueOf(this.vectorIds) + ", tso=" + this.tso + ", ts=" + this.ts + ", hasMore=" + this.hasMore + ", requestInfo=" + String.valueOf(this.requestInfo) + ", vectors=" + String.valueOf(this.vectors) + ", vectorIndexId=" + this.vectorIndexId + ", ext$=" + String.valueOf(this.ext$) + ")";
        }
    }

    private static final class VectorPushDataRequestBuilderImpl
    extends VectorPushDataRequestBuilder<VectorPushDataRequest, VectorPushDataRequestBuilderImpl> {
        private VectorPushDataRequestBuilderImpl() {
        }

        @Override
        protected VectorPushDataRequestBuilderImpl self() {
            return this;
        }

        @Override
        public VectorPushDataRequest build() {
            return new VectorPushDataRequest(this);
        }
    }

    public static final class Fields {
        public static final String error = "error";
        public static final String alreadySendVectorCount = "alreadySendVectorCount";
        public static final String forceToLoadDataIfExist = "forceToLoadDataIfExist";
        public static final String vectorIds = "vectorIds";
        public static final String tso = "tso";
        public static final String ts = "ts";
        public static final String hasMore = "hasMore";
        public static final String requestInfo = "requestInfo";
        public static final String vectors = "vectors";
        public static final String vectorIndexId = "vectorIndexId";
        public static final String ext$ = "ext$";
    }
}

