/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.service.entity.coordinator;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.common.Location;
import io.dingodb.sdk.service.entity.common.Range;
import io.dingodb.sdk.service.entity.common.RegionEpoch;
import io.dingodb.sdk.service.entity.coordinator.RegionStatus;
import java.util.List;

public class ScanRegionInfo
implements Message {
    private List<Location> voters;
    private RegionEpoch regionEpoch;
    private RegionStatus status;
    private List<Location> learners;
    private Range range;
    private Location leader;
    private long regionId;
    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write((Integer)1, this.regionId, out);
        Writer.write((Integer)2, (Message)this.range, out);
        Writer.write((Integer)3, (Message)this.leader, out);
        Writer.write((Integer)4, this.voters, (n, v) -> Writer.write(n, (Message)v, out));
        Writer.write((Integer)5, this.learners, (n, v) -> Writer.write(n, (Message)v, out));
        Writer.write((Integer)6, (Message)this.regionEpoch, out);
        Writer.write((Integer)7, (Message)this.status, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        block9: while ((number = Reader.readNumber(input)) != 0) {
            switch (number) {
                case 1: {
                    this.regionId = Reader.readLong(input);
                    hasValue = true;
                    continue block9;
                }
                case 2: {
                    this.range = Reader.readMessage(new Range(), input);
                    hasValue = hasValue ? hasValue : this.range != null;
                    continue block9;
                }
                case 3: {
                    this.leader = Reader.readMessage(new Location(), input);
                    hasValue = hasValue ? hasValue : this.leader != null;
                    continue block9;
                }
                case 4: {
                    this.voters = Reader.readList(this.voters, input, in -> Reader.readMessage(new Location(), in));
                    hasValue = true;
                    continue block9;
                }
                case 5: {
                    this.learners = Reader.readList(this.learners, input, in -> Reader.readMessage(new Location(), in));
                    hasValue = true;
                    continue block9;
                }
                case 6: {
                    this.regionEpoch = Reader.readMessage(new RegionEpoch(), input);
                    hasValue = hasValue ? hasValue : this.regionEpoch != null;
                    continue block9;
                }
                case 7: {
                    this.status = Reader.readMessage(new RegionStatus(), input);
                    hasValue = hasValue ? hasValue : this.status != null;
                    continue block9;
                }
            }
            Reader.skip(input);
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf((Integer)1, this.regionId).intValue();
        size += SizeUtils.sizeOf((Integer)2, (Message)this.range).intValue();
        size += SizeUtils.sizeOf((Integer)3, (Message)this.leader).intValue();
        size += SizeUtils.sizeOf(4, this.voters, SizeUtils::sizeOf);
        size += SizeUtils.sizeOf(5, this.learners, SizeUtils::sizeOf);
        size += SizeUtils.sizeOf((Integer)6, (Message)this.regionEpoch).intValue();
        return size += SizeUtils.sizeOf((Integer)7, (Message)this.status).intValue();
    }

    protected ScanRegionInfo(ScanRegionInfoBuilder<?, ?> b) {
        this.voters = b.voters;
        this.regionEpoch = b.regionEpoch;
        this.status = b.status;
        this.learners = b.learners;
        this.range = b.range;
        this.leader = b.leader;
        this.regionId = b.regionId;
        this.ext$ = b.ext$;
    }

    public static ScanRegionInfoBuilder<?, ?> builder() {
        return new ScanRegionInfoBuilderImpl();
    }

    public List<Location> getVoters() {
        return this.voters;
    }

    public RegionEpoch getRegionEpoch() {
        return this.regionEpoch;
    }

    public RegionStatus getStatus() {
        return this.status;
    }

    public List<Location> getLearners() {
        return this.learners;
    }

    public Range getRange() {
        return this.range;
    }

    public Location getLeader() {
        return this.leader;
    }

    public long getRegionId() {
        return this.regionId;
    }

    @Override
    public Object getExt$() {
        return this.ext$;
    }

    public void setVoters(List<Location> voters) {
        this.voters = voters;
    }

    public void setRegionEpoch(RegionEpoch regionEpoch) {
        this.regionEpoch = regionEpoch;
    }

    public void setStatus(RegionStatus status) {
        this.status = status;
    }

    public void setLearners(List<Location> learners) {
        this.learners = learners;
    }

    public void setRange(Range range) {
        this.range = range;
    }

    public void setLeader(Location leader) {
        this.leader = leader;
    }

    public void setRegionId(long regionId) {
        this.regionId = regionId;
    }

    @Override
    public void setExt$(Object ext$) {
        this.ext$ = ext$;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ScanRegionInfo)) {
            return false;
        }
        ScanRegionInfo other = (ScanRegionInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getRegionId() != other.getRegionId()) {
            return false;
        }
        List<Location> this$voters = this.getVoters();
        List<Location> other$voters = other.getVoters();
        if (this$voters == null ? other$voters != null : !((Object)this$voters).equals(other$voters)) {
            return false;
        }
        RegionEpoch this$regionEpoch = this.getRegionEpoch();
        RegionEpoch other$regionEpoch = other.getRegionEpoch();
        if (this$regionEpoch == null ? other$regionEpoch != null : !((Object)this$regionEpoch).equals(other$regionEpoch)) {
            return false;
        }
        RegionStatus this$status = this.getStatus();
        RegionStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
            return false;
        }
        List<Location> this$learners = this.getLearners();
        List<Location> other$learners = other.getLearners();
        if (this$learners == null ? other$learners != null : !((Object)this$learners).equals(other$learners)) {
            return false;
        }
        Range this$range = this.getRange();
        Range other$range = other.getRange();
        if (this$range == null ? other$range != null : !((Object)this$range).equals(other$range)) {
            return false;
        }
        Location this$leader = this.getLeader();
        Location other$leader = other.getLeader();
        if (this$leader == null ? other$leader != null : !((Object)this$leader).equals(other$leader)) {
            return false;
        }
        Object this$ext$ = this.getExt$();
        Object other$ext$ = other.getExt$();
        return !(this$ext$ == null ? other$ext$ != null : !this$ext$.equals(other$ext$));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ScanRegionInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $regionId = this.getRegionId();
        result = result * 59 + (int)($regionId >>> 32 ^ $regionId);
        List<Location> $voters = this.getVoters();
        result = result * 59 + ($voters == null ? 43 : ((Object)$voters).hashCode());
        RegionEpoch $regionEpoch = this.getRegionEpoch();
        result = result * 59 + ($regionEpoch == null ? 43 : ((Object)$regionEpoch).hashCode());
        RegionStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        List<Location> $learners = this.getLearners();
        result = result * 59 + ($learners == null ? 43 : ((Object)$learners).hashCode());
        Range $range = this.getRange();
        result = result * 59 + ($range == null ? 43 : ((Object)$range).hashCode());
        Location $leader = this.getLeader();
        result = result * 59 + ($leader == null ? 43 : ((Object)$leader).hashCode());
        Object $ext$ = this.getExt$();
        result = result * 59 + ($ext$ == null ? 43 : $ext$.hashCode());
        return result;
    }

    public String toString() {
        return "ScanRegionInfo(voters=" + String.valueOf(this.getVoters()) + ", regionEpoch=" + String.valueOf(this.getRegionEpoch()) + ", status=" + String.valueOf(this.getStatus()) + ", learners=" + String.valueOf(this.getLearners()) + ", range=" + String.valueOf(this.getRange()) + ", leader=" + String.valueOf(this.getLeader()) + ", regionId=" + this.getRegionId() + ", ext$=" + String.valueOf(this.getExt$()) + ")";
    }

    public ScanRegionInfo() {
    }

    public static abstract class ScanRegionInfoBuilder<C extends ScanRegionInfo, B extends ScanRegionInfoBuilder<C, B>> {
        private List<Location> voters;
        private RegionEpoch regionEpoch;
        private RegionStatus status;
        private List<Location> learners;
        private Range range;
        private Location leader;
        private long regionId;
        private Object ext$;

        protected abstract B self();

        public abstract C build();

        public B voters(List<Location> voters) {
            this.voters = voters;
            return this.self();
        }

        public B regionEpoch(RegionEpoch regionEpoch) {
            this.regionEpoch = regionEpoch;
            return this.self();
        }

        public B status(RegionStatus status) {
            this.status = status;
            return this.self();
        }

        public B learners(List<Location> learners) {
            this.learners = learners;
            return this.self();
        }

        public B range(Range range) {
            this.range = range;
            return this.self();
        }

        public B leader(Location leader) {
            this.leader = leader;
            return this.self();
        }

        public B regionId(long regionId) {
            this.regionId = regionId;
            return this.self();
        }

        public B ext$(Object ext$) {
            this.ext$ = ext$;
            return this.self();
        }

        public String toString() {
            return "ScanRegionInfo.ScanRegionInfoBuilder(voters=" + String.valueOf(this.voters) + ", regionEpoch=" + String.valueOf(this.regionEpoch) + ", status=" + String.valueOf(this.status) + ", learners=" + String.valueOf(this.learners) + ", range=" + String.valueOf(this.range) + ", leader=" + String.valueOf(this.leader) + ", regionId=" + this.regionId + ", ext$=" + String.valueOf(this.ext$) + ")";
        }
    }

    private static final class ScanRegionInfoBuilderImpl
    extends ScanRegionInfoBuilder<ScanRegionInfo, ScanRegionInfoBuilderImpl> {
        private ScanRegionInfoBuilderImpl() {
        }

        @Override
        protected ScanRegionInfoBuilderImpl self() {
            return this;
        }

        @Override
        public ScanRegionInfo build() {
            return new ScanRegionInfo(this);
        }
    }

    public static final class Fields {
        public static final String voters = "voters";
        public static final String regionEpoch = "regionEpoch";
        public static final String status = "status";
        public static final String learners = "learners";
        public static final String range = "range";
        public static final String leader = "leader";
        public static final String regionId = "regionId";
        public static final String ext$ = "ext$";
    }
}

