/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.service.entity.coordinator;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.common.Peer;
import io.dingodb.sdk.service.entity.common.Range;
import io.dingodb.sdk.service.entity.common.RegionRaftStatus;
import io.dingodb.sdk.service.entity.common.RegionState;
import io.dingodb.sdk.service.entity.common.ReplicaStatus;
import java.util.List;

public class RegionCheck
implements Message {
    private RegionState state;
    private RegionRaftStatus raftStatus;
    private long vectorSnapshotLogId;
    private Range range;
    private ReplicaStatus replicaStatus;
    private List<Peer> peers;
    private long regionId;
    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write((Integer)1, this.regionId, out);
        Writer.write((Integer)2, (Message)this.range, out);
        Writer.write((Integer)3, this.state, out);
        Writer.write((Integer)4, this.raftStatus, out);
        Writer.write((Integer)5, this.replicaStatus, out);
        Writer.write((Integer)6, this.peers, (n, v) -> Writer.write(n, (Message)v, out));
        Writer.write((Integer)12, this.vectorSnapshotLogId, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        block9: while ((number = Reader.readNumber(input)) != 0) {
            switch (number) {
                case 1: {
                    this.regionId = Reader.readLong(input);
                    hasValue = true;
                    continue block9;
                }
                case 2: {
                    this.range = Reader.readMessage(new Range(), input);
                    hasValue = hasValue ? hasValue : this.range != null;
                    continue block9;
                }
                case 3: {
                    this.state = RegionState.forNumber(Reader.readInt(input));
                    hasValue = true;
                    continue block9;
                }
                case 4: {
                    this.raftStatus = RegionRaftStatus.forNumber(Reader.readInt(input));
                    hasValue = true;
                    continue block9;
                }
                case 5: {
                    this.replicaStatus = ReplicaStatus.forNumber(Reader.readInt(input));
                    hasValue = true;
                    continue block9;
                }
                case 6: {
                    this.peers = Reader.readList(this.peers, input, in -> Reader.readMessage(new Peer(), in));
                    hasValue = true;
                    continue block9;
                }
                case 12: {
                    this.vectorSnapshotLogId = Reader.readLong(input);
                    hasValue = true;
                    continue block9;
                }
            }
            Reader.skip(input);
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf((Integer)1, this.regionId).intValue();
        size += SizeUtils.sizeOf((Integer)2, (Message)this.range).intValue();
        size += SizeUtils.sizeOf((Integer)3, this.state).intValue();
        size += SizeUtils.sizeOf((Integer)4, this.raftStatus).intValue();
        size += SizeUtils.sizeOf((Integer)5, this.replicaStatus).intValue();
        size += SizeUtils.sizeOf(6, this.peers, SizeUtils::sizeOf);
        return size += SizeUtils.sizeOf((Integer)12, this.vectorSnapshotLogId).intValue();
    }

    protected RegionCheck(RegionCheckBuilder<?, ?> b) {
        this.state = b.state;
        this.raftStatus = b.raftStatus;
        this.vectorSnapshotLogId = b.vectorSnapshotLogId;
        this.range = b.range;
        this.replicaStatus = b.replicaStatus;
        this.peers = b.peers;
        this.regionId = b.regionId;
        this.ext$ = b.ext$;
    }

    public static RegionCheckBuilder<?, ?> builder() {
        return new RegionCheckBuilderImpl();
    }

    public RegionState getState() {
        return this.state;
    }

    public RegionRaftStatus getRaftStatus() {
        return this.raftStatus;
    }

    public long getVectorSnapshotLogId() {
        return this.vectorSnapshotLogId;
    }

    public Range getRange() {
        return this.range;
    }

    public ReplicaStatus getReplicaStatus() {
        return this.replicaStatus;
    }

    public List<Peer> getPeers() {
        return this.peers;
    }

    public long getRegionId() {
        return this.regionId;
    }

    @Override
    public Object getExt$() {
        return this.ext$;
    }

    public void setState(RegionState state) {
        this.state = state;
    }

    public void setRaftStatus(RegionRaftStatus raftStatus) {
        this.raftStatus = raftStatus;
    }

    public void setVectorSnapshotLogId(long vectorSnapshotLogId) {
        this.vectorSnapshotLogId = vectorSnapshotLogId;
    }

    public void setRange(Range range) {
        this.range = range;
    }

    public void setReplicaStatus(ReplicaStatus replicaStatus) {
        this.replicaStatus = replicaStatus;
    }

    public void setPeers(List<Peer> peers) {
        this.peers = peers;
    }

    public void setRegionId(long regionId) {
        this.regionId = regionId;
    }

    @Override
    public void setExt$(Object ext$) {
        this.ext$ = ext$;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RegionCheck)) {
            return false;
        }
        RegionCheck other = (RegionCheck)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getVectorSnapshotLogId() != other.getVectorSnapshotLogId()) {
            return false;
        }
        if (this.getRegionId() != other.getRegionId()) {
            return false;
        }
        RegionState this$state = this.getState();
        RegionState other$state = other.getState();
        if (this$state == null ? other$state != null : !this$state.equals(other$state)) {
            return false;
        }
        RegionRaftStatus this$raftStatus = this.getRaftStatus();
        RegionRaftStatus other$raftStatus = other.getRaftStatus();
        if (this$raftStatus == null ? other$raftStatus != null : !this$raftStatus.equals(other$raftStatus)) {
            return false;
        }
        Range this$range = this.getRange();
        Range other$range = other.getRange();
        if (this$range == null ? other$range != null : !((Object)this$range).equals(other$range)) {
            return false;
        }
        ReplicaStatus this$replicaStatus = this.getReplicaStatus();
        ReplicaStatus other$replicaStatus = other.getReplicaStatus();
        if (this$replicaStatus == null ? other$replicaStatus != null : !this$replicaStatus.equals(other$replicaStatus)) {
            return false;
        }
        List<Peer> this$peers = this.getPeers();
        List<Peer> other$peers = other.getPeers();
        if (this$peers == null ? other$peers != null : !((Object)this$peers).equals(other$peers)) {
            return false;
        }
        Object this$ext$ = this.getExt$();
        Object other$ext$ = other.getExt$();
        return !(this$ext$ == null ? other$ext$ != null : !this$ext$.equals(other$ext$));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RegionCheck;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $vectorSnapshotLogId = this.getVectorSnapshotLogId();
        result = result * 59 + (int)($vectorSnapshotLogId >>> 32 ^ $vectorSnapshotLogId);
        long $regionId = this.getRegionId();
        result = result * 59 + (int)($regionId >>> 32 ^ $regionId);
        RegionState $state = this.getState();
        result = result * 59 + ($state == null ? 43 : $state.hashCode());
        RegionRaftStatus $raftStatus = this.getRaftStatus();
        result = result * 59 + ($raftStatus == null ? 43 : $raftStatus.hashCode());
        Range $range = this.getRange();
        result = result * 59 + ($range == null ? 43 : ((Object)$range).hashCode());
        ReplicaStatus $replicaStatus = this.getReplicaStatus();
        result = result * 59 + ($replicaStatus == null ? 43 : $replicaStatus.hashCode());
        List<Peer> $peers = this.getPeers();
        result = result * 59 + ($peers == null ? 43 : ((Object)$peers).hashCode());
        Object $ext$ = this.getExt$();
        result = result * 59 + ($ext$ == null ? 43 : $ext$.hashCode());
        return result;
    }

    public String toString() {
        return "RegionCheck(state=" + String.valueOf(this.getState()) + ", raftStatus=" + String.valueOf(this.getRaftStatus()) + ", vectorSnapshotLogId=" + this.getVectorSnapshotLogId() + ", range=" + String.valueOf(this.getRange()) + ", replicaStatus=" + String.valueOf(this.getReplicaStatus()) + ", peers=" + String.valueOf(this.getPeers()) + ", regionId=" + this.getRegionId() + ", ext$=" + String.valueOf(this.getExt$()) + ")";
    }

    public RegionCheck() {
    }

    public static abstract class RegionCheckBuilder<C extends RegionCheck, B extends RegionCheckBuilder<C, B>> {
        private RegionState state;
        private RegionRaftStatus raftStatus;
        private long vectorSnapshotLogId;
        private Range range;
        private ReplicaStatus replicaStatus;
        private List<Peer> peers;
        private long regionId;
        private Object ext$;

        protected abstract B self();

        public abstract C build();

        public B state(RegionState state) {
            this.state = state;
            return this.self();
        }

        public B raftStatus(RegionRaftStatus raftStatus) {
            this.raftStatus = raftStatus;
            return this.self();
        }

        public B vectorSnapshotLogId(long vectorSnapshotLogId) {
            this.vectorSnapshotLogId = vectorSnapshotLogId;
            return this.self();
        }

        public B range(Range range) {
            this.range = range;
            return this.self();
        }

        public B replicaStatus(ReplicaStatus replicaStatus) {
            this.replicaStatus = replicaStatus;
            return this.self();
        }

        public B peers(List<Peer> peers) {
            this.peers = peers;
            return this.self();
        }

        public B regionId(long regionId) {
            this.regionId = regionId;
            return this.self();
        }

        public B ext$(Object ext$) {
            this.ext$ = ext$;
            return this.self();
        }

        public String toString() {
            return "RegionCheck.RegionCheckBuilder(state=" + String.valueOf(this.state) + ", raftStatus=" + String.valueOf(this.raftStatus) + ", vectorSnapshotLogId=" + this.vectorSnapshotLogId + ", range=" + String.valueOf(this.range) + ", replicaStatus=" + String.valueOf(this.replicaStatus) + ", peers=" + String.valueOf(this.peers) + ", regionId=" + this.regionId + ", ext$=" + String.valueOf(this.ext$) + ")";
        }
    }

    private static final class RegionCheckBuilderImpl
    extends RegionCheckBuilder<RegionCheck, RegionCheckBuilderImpl> {
        private RegionCheckBuilderImpl() {
        }

        @Override
        protected RegionCheckBuilderImpl self() {
            return this;
        }

        @Override
        public RegionCheck build() {
            return new RegionCheck(this);
        }
    }

    public static final class Fields {
        public static final String state = "state";
        public static final String raftStatus = "raftStatus";
        public static final String vectorSnapshotLogId = "vectorSnapshotLogId";
        public static final String range = "range";
        public static final String replicaStatus = "replicaStatus";
        public static final String peers = "peers";
        public static final String regionId = "regionId";
        public static final String ext$ = "ext$";
    }
}

