/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.service.entity.coordinator;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.common.IndexParameter;
import io.dingodb.sdk.service.entity.common.Range;
import io.dingodb.sdk.service.entity.common.RawEngine;
import io.dingodb.sdk.service.entity.common.RegionType;
import io.dingodb.sdk.service.entity.common.RequestInfo;
import io.dingodb.sdk.service.entity.common.StorageEngine;
import java.util.List;

public class CreateRegionRequest
implements Message,
Message.Request {
    private StorageEngine storeEngine;
    private long tenantId;
    private long partId;
    private String regionName;
    private String resourceTag;
    private long tableId;
    private RequestInfo requestInfo;
    private long regionId;
    private long splitFromRegionId;
    private boolean useRegionNameDirect;
    private long schemaId;
    private IndexParameter indexParameter;
    private long indexId;
    private RegionType regionType;
    private Range range;
    private long replicaNum;
    private RawEngine rawEngine;
    private List<Long> storeIds;
    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write((Integer)1, (Message)this.requestInfo, out);
        Writer.write((Integer)2, this.regionName, out);
        Writer.write((Integer)3, this.resourceTag, out);
        Writer.write((Integer)4, this.replicaNum, out);
        Writer.write((Integer)5, (Message)this.range, out);
        Writer.write((Integer)6, this.rawEngine, out);
        Writer.write((Integer)7, this.storeEngine, out);
        Writer.write((Integer)8, this.regionId, out);
        Writer.write((Integer)9, this.useRegionNameDirect, out);
        Writer.write((Integer)11, this.schemaId, out);
        Writer.write((Integer)12, this.tableId, out);
        Writer.write((Integer)13, this.indexId, out);
        Writer.write((Integer)14, this.partId, out);
        Writer.write((Integer)15, this.tenantId, out);
        Writer.write(20, this.storeIds, out, Writer::write, SizeUtils::sizeOf);
        Writer.write((Integer)25, this.splitFromRegionId, out);
        Writer.write((Integer)30, this.regionType, out);
        Writer.write((Integer)40, (Message)this.indexParameter, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        block20: while ((number = Reader.readNumber(input)) != 0) {
            switch (number) {
                case 1: {
                    this.requestInfo = Reader.readMessage(new RequestInfo(), input);
                    hasValue = hasValue ? hasValue : this.requestInfo != null;
                    continue block20;
                }
                case 2: {
                    this.regionName = Reader.readString(input);
                    hasValue = true;
                    continue block20;
                }
                case 3: {
                    this.resourceTag = Reader.readString(input);
                    hasValue = true;
                    continue block20;
                }
                case 4: {
                    this.replicaNum = Reader.readLong(input);
                    hasValue = true;
                    continue block20;
                }
                case 5: {
                    this.range = Reader.readMessage(new Range(), input);
                    hasValue = hasValue ? hasValue : this.range != null;
                    continue block20;
                }
                case 6: {
                    this.rawEngine = RawEngine.forNumber(Reader.readInt(input));
                    hasValue = true;
                    continue block20;
                }
                case 7: {
                    this.storeEngine = StorageEngine.forNumber(Reader.readInt(input));
                    hasValue = true;
                    continue block20;
                }
                case 8: {
                    this.regionId = Reader.readLong(input);
                    hasValue = true;
                    continue block20;
                }
                case 9: {
                    this.useRegionNameDirect = Reader.readBoolean(input);
                    hasValue = true;
                    continue block20;
                }
                case 11: {
                    this.schemaId = Reader.readLong(input);
                    hasValue = true;
                    continue block20;
                }
                case 12: {
                    this.tableId = Reader.readLong(input);
                    hasValue = true;
                    continue block20;
                }
                case 13: {
                    this.indexId = Reader.readLong(input);
                    hasValue = true;
                    continue block20;
                }
                case 14: {
                    this.partId = Reader.readLong(input);
                    hasValue = true;
                    continue block20;
                }
                case 15: {
                    this.tenantId = Reader.readLong(input);
                    hasValue = true;
                    continue block20;
                }
                case 20: {
                    this.storeIds = Reader.readPack(input, Reader::readLong);
                    hasValue = true;
                    continue block20;
                }
                case 25: {
                    this.splitFromRegionId = Reader.readLong(input);
                    hasValue = true;
                    continue block20;
                }
                case 30: {
                    this.regionType = RegionType.forNumber(Reader.readInt(input));
                    hasValue = true;
                    continue block20;
                }
                case 40: {
                    this.indexParameter = Reader.readMessage(new IndexParameter(), input);
                    hasValue = hasValue ? hasValue : this.indexParameter != null;
                    continue block20;
                }
            }
            Reader.skip(input);
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf((Integer)1, (Message)this.requestInfo).intValue();
        size += SizeUtils.sizeOf((Integer)2, this.regionName).intValue();
        size += SizeUtils.sizeOf((Integer)3, this.resourceTag).intValue();
        size += SizeUtils.sizeOf((Integer)4, this.replicaNum).intValue();
        size += SizeUtils.sizeOf((Integer)5, (Message)this.range).intValue();
        size += SizeUtils.sizeOf((Integer)6, this.rawEngine).intValue();
        size += SizeUtils.sizeOf((Integer)7, this.storeEngine).intValue();
        size += SizeUtils.sizeOf((Integer)8, this.regionId).intValue();
        size += SizeUtils.sizeOf((Integer)9, this.useRegionNameDirect).intValue();
        size += SizeUtils.sizeOf((Integer)11, this.schemaId).intValue();
        size += SizeUtils.sizeOf((Integer)12, this.tableId).intValue();
        size += SizeUtils.sizeOf((Integer)13, this.indexId).intValue();
        size += SizeUtils.sizeOf((Integer)14, this.partId).intValue();
        size += SizeUtils.sizeOf((Integer)15, this.tenantId).intValue();
        size += SizeUtils.sizeOfPack(20, this.storeIds, SizeUtils::sizeOf);
        size += SizeUtils.sizeOf((Integer)25, this.splitFromRegionId).intValue();
        size += SizeUtils.sizeOf((Integer)30, this.regionType).intValue();
        return size += SizeUtils.sizeOf((Integer)40, (Message)this.indexParameter).intValue();
    }

    protected CreateRegionRequest(CreateRegionRequestBuilder<?, ?> b) {
        this.storeEngine = b.storeEngine;
        this.tenantId = b.tenantId;
        this.partId = b.partId;
        this.regionName = b.regionName;
        this.resourceTag = b.resourceTag;
        this.tableId = b.tableId;
        this.requestInfo = b.requestInfo;
        this.regionId = b.regionId;
        this.splitFromRegionId = b.splitFromRegionId;
        this.useRegionNameDirect = b.useRegionNameDirect;
        this.schemaId = b.schemaId;
        this.indexParameter = b.indexParameter;
        this.indexId = b.indexId;
        this.regionType = b.regionType;
        this.range = b.range;
        this.replicaNum = b.replicaNum;
        this.rawEngine = b.rawEngine;
        this.storeIds = b.storeIds;
        this.ext$ = b.ext$;
    }

    public static CreateRegionRequestBuilder<?, ?> builder() {
        return new CreateRegionRequestBuilderImpl();
    }

    public StorageEngine getStoreEngine() {
        return this.storeEngine;
    }

    public long getTenantId() {
        return this.tenantId;
    }

    public long getPartId() {
        return this.partId;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public String getResourceTag() {
        return this.resourceTag;
    }

    public long getTableId() {
        return this.tableId;
    }

    @Override
    public RequestInfo getRequestInfo() {
        return this.requestInfo;
    }

    public long getRegionId() {
        return this.regionId;
    }

    public long getSplitFromRegionId() {
        return this.splitFromRegionId;
    }

    public boolean isUseRegionNameDirect() {
        return this.useRegionNameDirect;
    }

    public long getSchemaId() {
        return this.schemaId;
    }

    public IndexParameter getIndexParameter() {
        return this.indexParameter;
    }

    public long getIndexId() {
        return this.indexId;
    }

    public RegionType getRegionType() {
        return this.regionType;
    }

    public Range getRange() {
        return this.range;
    }

    public long getReplicaNum() {
        return this.replicaNum;
    }

    public RawEngine getRawEngine() {
        return this.rawEngine;
    }

    public List<Long> getStoreIds() {
        return this.storeIds;
    }

    @Override
    public Object getExt$() {
        return this.ext$;
    }

    public void setStoreEngine(StorageEngine storeEngine) {
        this.storeEngine = storeEngine;
    }

    public void setTenantId(long tenantId) {
        this.tenantId = tenantId;
    }

    public void setPartId(long partId) {
        this.partId = partId;
    }

    public void setRegionName(String regionName) {
        this.regionName = regionName;
    }

    public void setResourceTag(String resourceTag) {
        this.resourceTag = resourceTag;
    }

    public void setTableId(long tableId) {
        this.tableId = tableId;
    }

    @Override
    public void setRequestInfo(RequestInfo requestInfo) {
        this.requestInfo = requestInfo;
    }

    public void setRegionId(long regionId) {
        this.regionId = regionId;
    }

    public void setSplitFromRegionId(long splitFromRegionId) {
        this.splitFromRegionId = splitFromRegionId;
    }

    public void setUseRegionNameDirect(boolean useRegionNameDirect) {
        this.useRegionNameDirect = useRegionNameDirect;
    }

    public void setSchemaId(long schemaId) {
        this.schemaId = schemaId;
    }

    public void setIndexParameter(IndexParameter indexParameter) {
        this.indexParameter = indexParameter;
    }

    public void setIndexId(long indexId) {
        this.indexId = indexId;
    }

    public void setRegionType(RegionType regionType) {
        this.regionType = regionType;
    }

    public void setRange(Range range) {
        this.range = range;
    }

    public void setReplicaNum(long replicaNum) {
        this.replicaNum = replicaNum;
    }

    public void setRawEngine(RawEngine rawEngine) {
        this.rawEngine = rawEngine;
    }

    public void setStoreIds(List<Long> storeIds) {
        this.storeIds = storeIds;
    }

    @Override
    public void setExt$(Object ext$) {
        this.ext$ = ext$;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreateRegionRequest)) {
            return false;
        }
        CreateRegionRequest other = (CreateRegionRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTenantId() != other.getTenantId()) {
            return false;
        }
        if (this.getPartId() != other.getPartId()) {
            return false;
        }
        if (this.getTableId() != other.getTableId()) {
            return false;
        }
        if (this.getRegionId() != other.getRegionId()) {
            return false;
        }
        if (this.getSplitFromRegionId() != other.getSplitFromRegionId()) {
            return false;
        }
        if (this.isUseRegionNameDirect() != other.isUseRegionNameDirect()) {
            return false;
        }
        if (this.getSchemaId() != other.getSchemaId()) {
            return false;
        }
        if (this.getIndexId() != other.getIndexId()) {
            return false;
        }
        if (this.getReplicaNum() != other.getReplicaNum()) {
            return false;
        }
        StorageEngine this$storeEngine = this.getStoreEngine();
        StorageEngine other$storeEngine = other.getStoreEngine();
        if (this$storeEngine == null ? other$storeEngine != null : !this$storeEngine.equals(other$storeEngine)) {
            return false;
        }
        String this$regionName = this.getRegionName();
        String other$regionName = other.getRegionName();
        if (this$regionName == null ? other$regionName != null : !this$regionName.equals(other$regionName)) {
            return false;
        }
        String this$resourceTag = this.getResourceTag();
        String other$resourceTag = other.getResourceTag();
        if (this$resourceTag == null ? other$resourceTag != null : !this$resourceTag.equals(other$resourceTag)) {
            return false;
        }
        RequestInfo this$requestInfo = this.getRequestInfo();
        RequestInfo other$requestInfo = other.getRequestInfo();
        if (this$requestInfo == null ? other$requestInfo != null : !((Object)this$requestInfo).equals(other$requestInfo)) {
            return false;
        }
        IndexParameter this$indexParameter = this.getIndexParameter();
        IndexParameter other$indexParameter = other.getIndexParameter();
        if (this$indexParameter == null ? other$indexParameter != null : !((Object)this$indexParameter).equals(other$indexParameter)) {
            return false;
        }
        RegionType this$regionType = this.getRegionType();
        RegionType other$regionType = other.getRegionType();
        if (this$regionType == null ? other$regionType != null : !this$regionType.equals(other$regionType)) {
            return false;
        }
        Range this$range = this.getRange();
        Range other$range = other.getRange();
        if (this$range == null ? other$range != null : !((Object)this$range).equals(other$range)) {
            return false;
        }
        RawEngine this$rawEngine = this.getRawEngine();
        RawEngine other$rawEngine = other.getRawEngine();
        if (this$rawEngine == null ? other$rawEngine != null : !this$rawEngine.equals(other$rawEngine)) {
            return false;
        }
        List<Long> this$storeIds = this.getStoreIds();
        List<Long> other$storeIds = other.getStoreIds();
        if (this$storeIds == null ? other$storeIds != null : !((Object)this$storeIds).equals(other$storeIds)) {
            return false;
        }
        Object this$ext$ = this.getExt$();
        Object other$ext$ = other.getExt$();
        return !(this$ext$ == null ? other$ext$ != null : !this$ext$.equals(other$ext$));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CreateRegionRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $tenantId = this.getTenantId();
        result = result * 59 + (int)($tenantId >>> 32 ^ $tenantId);
        long $partId = this.getPartId();
        result = result * 59 + (int)($partId >>> 32 ^ $partId);
        long $tableId = this.getTableId();
        result = result * 59 + (int)($tableId >>> 32 ^ $tableId);
        long $regionId = this.getRegionId();
        result = result * 59 + (int)($regionId >>> 32 ^ $regionId);
        long $splitFromRegionId = this.getSplitFromRegionId();
        result = result * 59 + (int)($splitFromRegionId >>> 32 ^ $splitFromRegionId);
        result = result * 59 + (this.isUseRegionNameDirect() ? 79 : 97);
        long $schemaId = this.getSchemaId();
        result = result * 59 + (int)($schemaId >>> 32 ^ $schemaId);
        long $indexId = this.getIndexId();
        result = result * 59 + (int)($indexId >>> 32 ^ $indexId);
        long $replicaNum = this.getReplicaNum();
        result = result * 59 + (int)($replicaNum >>> 32 ^ $replicaNum);
        StorageEngine $storeEngine = this.getStoreEngine();
        result = result * 59 + ($storeEngine == null ? 43 : $storeEngine.hashCode());
        String $regionName = this.getRegionName();
        result = result * 59 + ($regionName == null ? 43 : $regionName.hashCode());
        String $resourceTag = this.getResourceTag();
        result = result * 59 + ($resourceTag == null ? 43 : $resourceTag.hashCode());
        RequestInfo $requestInfo = this.getRequestInfo();
        result = result * 59 + ($requestInfo == null ? 43 : ((Object)$requestInfo).hashCode());
        IndexParameter $indexParameter = this.getIndexParameter();
        result = result * 59 + ($indexParameter == null ? 43 : ((Object)$indexParameter).hashCode());
        RegionType $regionType = this.getRegionType();
        result = result * 59 + ($regionType == null ? 43 : $regionType.hashCode());
        Range $range = this.getRange();
        result = result * 59 + ($range == null ? 43 : ((Object)$range).hashCode());
        RawEngine $rawEngine = this.getRawEngine();
        result = result * 59 + ($rawEngine == null ? 43 : $rawEngine.hashCode());
        List<Long> $storeIds = this.getStoreIds();
        result = result * 59 + ($storeIds == null ? 43 : ((Object)$storeIds).hashCode());
        Object $ext$ = this.getExt$();
        result = result * 59 + ($ext$ == null ? 43 : $ext$.hashCode());
        return result;
    }

    public String toString() {
        return "CreateRegionRequest(storeEngine=" + String.valueOf(this.getStoreEngine()) + ", tenantId=" + this.getTenantId() + ", partId=" + this.getPartId() + ", regionName=" + this.getRegionName() + ", resourceTag=" + this.getResourceTag() + ", tableId=" + this.getTableId() + ", requestInfo=" + String.valueOf(this.getRequestInfo()) + ", regionId=" + this.getRegionId() + ", splitFromRegionId=" + this.getSplitFromRegionId() + ", useRegionNameDirect=" + this.isUseRegionNameDirect() + ", schemaId=" + this.getSchemaId() + ", indexParameter=" + String.valueOf(this.getIndexParameter()) + ", indexId=" + this.getIndexId() + ", regionType=" + String.valueOf(this.getRegionType()) + ", range=" + String.valueOf(this.getRange()) + ", replicaNum=" + this.getReplicaNum() + ", rawEngine=" + String.valueOf(this.getRawEngine()) + ", storeIds=" + String.valueOf(this.getStoreIds()) + ", ext$=" + String.valueOf(this.getExt$()) + ")";
    }

    public CreateRegionRequest() {
    }

    public static abstract class CreateRegionRequestBuilder<C extends CreateRegionRequest, B extends CreateRegionRequestBuilder<C, B>> {
        private StorageEngine storeEngine;
        private long tenantId;
        private long partId;
        private String regionName;
        private String resourceTag;
        private long tableId;
        private RequestInfo requestInfo;
        private long regionId;
        private long splitFromRegionId;
        private boolean useRegionNameDirect;
        private long schemaId;
        private IndexParameter indexParameter;
        private long indexId;
        private RegionType regionType;
        private Range range;
        private long replicaNum;
        private RawEngine rawEngine;
        private List<Long> storeIds;
        private Object ext$;

        protected abstract B self();

        public abstract C build();

        public B storeEngine(StorageEngine storeEngine) {
            this.storeEngine = storeEngine;
            return this.self();
        }

        public B tenantId(long tenantId) {
            this.tenantId = tenantId;
            return this.self();
        }

        public B partId(long partId) {
            this.partId = partId;
            return this.self();
        }

        public B regionName(String regionName) {
            this.regionName = regionName;
            return this.self();
        }

        public B resourceTag(String resourceTag) {
            this.resourceTag = resourceTag;
            return this.self();
        }

        public B tableId(long tableId) {
            this.tableId = tableId;
            return this.self();
        }

        public B requestInfo(RequestInfo requestInfo) {
            this.requestInfo = requestInfo;
            return this.self();
        }

        public B regionId(long regionId) {
            this.regionId = regionId;
            return this.self();
        }

        public B splitFromRegionId(long splitFromRegionId) {
            this.splitFromRegionId = splitFromRegionId;
            return this.self();
        }

        public B useRegionNameDirect(boolean useRegionNameDirect) {
            this.useRegionNameDirect = useRegionNameDirect;
            return this.self();
        }

        public B schemaId(long schemaId) {
            this.schemaId = schemaId;
            return this.self();
        }

        public B indexParameter(IndexParameter indexParameter) {
            this.indexParameter = indexParameter;
            return this.self();
        }

        public B indexId(long indexId) {
            this.indexId = indexId;
            return this.self();
        }

        public B regionType(RegionType regionType) {
            this.regionType = regionType;
            return this.self();
        }

        public B range(Range range) {
            this.range = range;
            return this.self();
        }

        public B replicaNum(long replicaNum) {
            this.replicaNum = replicaNum;
            return this.self();
        }

        public B rawEngine(RawEngine rawEngine) {
            this.rawEngine = rawEngine;
            return this.self();
        }

        public B storeIds(List<Long> storeIds) {
            this.storeIds = storeIds;
            return this.self();
        }

        public B ext$(Object ext$) {
            this.ext$ = ext$;
            return this.self();
        }

        public String toString() {
            return "CreateRegionRequest.CreateRegionRequestBuilder(storeEngine=" + String.valueOf(this.storeEngine) + ", tenantId=" + this.tenantId + ", partId=" + this.partId + ", regionName=" + this.regionName + ", resourceTag=" + this.resourceTag + ", tableId=" + this.tableId + ", requestInfo=" + String.valueOf(this.requestInfo) + ", regionId=" + this.regionId + ", splitFromRegionId=" + this.splitFromRegionId + ", useRegionNameDirect=" + this.useRegionNameDirect + ", schemaId=" + this.schemaId + ", indexParameter=" + String.valueOf(this.indexParameter) + ", indexId=" + this.indexId + ", regionType=" + String.valueOf(this.regionType) + ", range=" + String.valueOf(this.range) + ", replicaNum=" + this.replicaNum + ", rawEngine=" + String.valueOf(this.rawEngine) + ", storeIds=" + String.valueOf(this.storeIds) + ", ext$=" + String.valueOf(this.ext$) + ")";
        }
    }

    private static final class CreateRegionRequestBuilderImpl
    extends CreateRegionRequestBuilder<CreateRegionRequest, CreateRegionRequestBuilderImpl> {
        private CreateRegionRequestBuilderImpl() {
        }

        @Override
        protected CreateRegionRequestBuilderImpl self() {
            return this;
        }

        @Override
        public CreateRegionRequest build() {
            return new CreateRegionRequest(this);
        }
    }

    public static final class Fields {
        public static final String storeEngine = "storeEngine";
        public static final String tenantId = "tenantId";
        public static final String partId = "partId";
        public static final String regionName = "regionName";
        public static final String resourceTag = "resourceTag";
        public static final String tableId = "tableId";
        public static final String requestInfo = "requestInfo";
        public static final String regionId = "regionId";
        public static final String splitFromRegionId = "splitFromRegionId";
        public static final String useRegionNameDirect = "useRegionNameDirect";
        public static final String schemaId = "schemaId";
        public static final String indexParameter = "indexParameter";
        public static final String indexId = "indexId";
        public static final String regionType = "regionType";
        public static final String range = "range";
        public static final String replicaNum = "replicaNum";
        public static final String rawEngine = "rawEngine";
        public static final String storeIds = "storeIds";
        public static final String ext$ = "ext$";
    }
}

