/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.service.entity.common;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.Numeric;
import io.dingodb.sdk.service.entity.common.CoprocessorV2;
import io.dingodb.sdk.service.entity.common.SearchBinaryFlatParam;
import io.dingodb.sdk.service.entity.common.SearchBinaryIvfFlatParam;
import io.dingodb.sdk.service.entity.common.SearchDiskAnnParam;
import io.dingodb.sdk.service.entity.common.SearchFlatParam;
import io.dingodb.sdk.service.entity.common.SearchHNSWParam;
import io.dingodb.sdk.service.entity.common.SearchIvfFlatParam;
import io.dingodb.sdk.service.entity.common.SearchIvfPqParam;
import io.dingodb.sdk.service.entity.common.VectorFilter;
import io.dingodb.sdk.service.entity.common.VectorFilterType;
import java.util.List;

public class VectorSearchParameter
implements Message {
    private boolean useBruteForce;
    private CoprocessorV2 vectorCoprocessor;
    private boolean withoutTableData;
    private VectorFilter vectorFilter;
    private boolean withoutVectorData;
    private VectorFilterType vectorFilterType;
    private int topN;
    private boolean isSorted;
    private List<Long> vectorIds;
    private List<String> selectedKeys;
    private boolean isNegation;
    private float radius;
    private boolean enableRangeSearch;
    private SearchNest search;
    private boolean withoutScalarData;
    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write((Integer)1, this.topN, out);
        Writer.write((Integer)2, this.withoutVectorData, out);
        Writer.write((Integer)3, this.withoutScalarData, out);
        Writer.write((Integer)4, this.selectedKeys, (n, v) -> Writer.write(n, v, out));
        Writer.write((Integer)5, this.withoutTableData, out);
        Writer.write((Integer)6, this.enableRangeSearch, out);
        Writer.write((Integer)7, Float.valueOf(this.radius), out);
        Writer.write(this.search, (Message)this.search, out);
        Writer.write((Integer)21, this.vectorFilter, out);
        Writer.write((Integer)22, this.vectorFilterType, out);
        Writer.write((Integer)23, (Message)this.vectorCoprocessor, out);
        Writer.write(24, this.vectorIds, out, Writer::write, SizeUtils::sizeOf);
        Writer.write((Integer)25, this.useBruteForce, out);
        Writer.write((Integer)26, this.isNegation, out);
        Writer.write((Integer)27, this.isSorted, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        block23: while ((number = Reader.readNumber(input)) != 0) {
            switch (number) {
                case 1: {
                    this.topN = Reader.readInt(input);
                    hasValue = true;
                    continue block23;
                }
                case 2: {
                    this.withoutVectorData = Reader.readBoolean(input);
                    hasValue = true;
                    continue block23;
                }
                case 3: {
                    this.withoutScalarData = Reader.readBoolean(input);
                    hasValue = true;
                    continue block23;
                }
                case 4: {
                    this.selectedKeys = Reader.readList(this.selectedKeys, input, Reader::readString);
                    hasValue = true;
                    continue block23;
                }
                case 5: {
                    this.withoutTableData = Reader.readBoolean(input);
                    hasValue = true;
                    continue block23;
                }
                case 6: {
                    this.enableRangeSearch = Reader.readBoolean(input);
                    hasValue = true;
                    continue block23;
                }
                case 7: {
                    this.radius = Reader.readFloat(input);
                    hasValue = true;
                    continue block23;
                }
                case 11: {
                    this.search = Reader.readMessage(new SearchNest.Flat(), input);
                    hasValue = hasValue ? hasValue : this.search != null;
                    continue block23;
                }
                case 12: {
                    this.search = Reader.readMessage(new SearchNest.IvfFlat(), input);
                    hasValue = hasValue ? hasValue : this.search != null;
                    continue block23;
                }
                case 13: {
                    this.search = Reader.readMessage(new SearchNest.IvfPq(), input);
                    hasValue = hasValue ? hasValue : this.search != null;
                    continue block23;
                }
                case 14: {
                    this.search = Reader.readMessage(new SearchNest.Hnsw(), input);
                    hasValue = hasValue ? hasValue : this.search != null;
                    continue block23;
                }
                case 15: {
                    this.search = Reader.readMessage(new SearchNest.Diskann(), input);
                    hasValue = hasValue ? hasValue : this.search != null;
                    continue block23;
                }
                case 21: {
                    this.vectorFilter = VectorFilter.forNumber(Reader.readInt(input));
                    hasValue = true;
                    continue block23;
                }
                case 22: {
                    this.vectorFilterType = VectorFilterType.forNumber(Reader.readInt(input));
                    hasValue = true;
                    continue block23;
                }
                case 23: {
                    this.vectorCoprocessor = Reader.readMessage(new CoprocessorV2(), input);
                    hasValue = hasValue ? hasValue : this.vectorCoprocessor != null;
                    continue block23;
                }
                case 24: {
                    this.vectorIds = Reader.readPack(input, Reader::readLong);
                    hasValue = true;
                    continue block23;
                }
                case 25: {
                    this.useBruteForce = Reader.readBoolean(input);
                    hasValue = true;
                    continue block23;
                }
                case 26: {
                    this.isNegation = Reader.readBoolean(input);
                    hasValue = true;
                    continue block23;
                }
                case 27: {
                    this.isSorted = Reader.readBoolean(input);
                    hasValue = true;
                    continue block23;
                }
                case 30: {
                    this.search = Reader.readMessage(new SearchNest.BinaryFlat(), input);
                    hasValue = hasValue ? hasValue : this.search != null;
                    continue block23;
                }
                case 31: {
                    this.search = Reader.readMessage(new SearchNest.BinaryIvfFlat(), input);
                    hasValue = hasValue ? hasValue : this.search != null;
                    continue block23;
                }
            }
            Reader.skip(input);
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf((Integer)1, this.topN).intValue();
        size += SizeUtils.sizeOf((Integer)2, this.withoutVectorData).intValue();
        size += SizeUtils.sizeOf((Integer)3, this.withoutScalarData).intValue();
        size += SizeUtils.sizeOf(4, this.selectedKeys, SizeUtils::sizeOf);
        size += SizeUtils.sizeOf((Integer)5, this.withoutTableData).intValue();
        size += SizeUtils.sizeOf((Integer)6, this.enableRangeSearch).intValue();
        size += SizeUtils.sizeOf((Integer)7, Float.valueOf(this.radius)).intValue();
        size += SizeUtils.sizeOf(this.search, (Message)this.search).intValue();
        size += SizeUtils.sizeOf((Integer)21, this.vectorFilter).intValue();
        size += SizeUtils.sizeOf((Integer)22, this.vectorFilterType).intValue();
        size += SizeUtils.sizeOf((Integer)23, (Message)this.vectorCoprocessor).intValue();
        size += SizeUtils.sizeOfPack(24, this.vectorIds, SizeUtils::sizeOf);
        size += SizeUtils.sizeOf((Integer)25, this.useBruteForce).intValue();
        size += SizeUtils.sizeOf((Integer)26, this.isNegation).intValue();
        return size += SizeUtils.sizeOf((Integer)27, this.isSorted).intValue();
    }

    protected VectorSearchParameter(VectorSearchParameterBuilder<?, ?> b) {
        this.useBruteForce = b.useBruteForce;
        this.vectorCoprocessor = b.vectorCoprocessor;
        this.withoutTableData = b.withoutTableData;
        this.vectorFilter = b.vectorFilter;
        this.withoutVectorData = b.withoutVectorData;
        this.vectorFilterType = b.vectorFilterType;
        this.topN = b.topN;
        this.isSorted = b.isSorted;
        this.vectorIds = b.vectorIds;
        this.selectedKeys = b.selectedKeys;
        this.isNegation = b.isNegation;
        this.radius = b.radius;
        this.enableRangeSearch = b.enableRangeSearch;
        this.search = b.search;
        this.withoutScalarData = b.withoutScalarData;
        this.ext$ = b.ext$;
    }

    public static VectorSearchParameterBuilder<?, ?> builder() {
        return new VectorSearchParameterBuilderImpl();
    }

    public boolean isUseBruteForce() {
        return this.useBruteForce;
    }

    public CoprocessorV2 getVectorCoprocessor() {
        return this.vectorCoprocessor;
    }

    public boolean isWithoutTableData() {
        return this.withoutTableData;
    }

    public VectorFilter getVectorFilter() {
        return this.vectorFilter;
    }

    public boolean isWithoutVectorData() {
        return this.withoutVectorData;
    }

    public VectorFilterType getVectorFilterType() {
        return this.vectorFilterType;
    }

    public int getTopN() {
        return this.topN;
    }

    public boolean isSorted() {
        return this.isSorted;
    }

    public List<Long> getVectorIds() {
        return this.vectorIds;
    }

    public List<String> getSelectedKeys() {
        return this.selectedKeys;
    }

    public boolean isNegation() {
        return this.isNegation;
    }

    public float getRadius() {
        return this.radius;
    }

    public boolean isEnableRangeSearch() {
        return this.enableRangeSearch;
    }

    public SearchNest getSearch() {
        return this.search;
    }

    public boolean isWithoutScalarData() {
        return this.withoutScalarData;
    }

    @Override
    public Object getExt$() {
        return this.ext$;
    }

    public void setUseBruteForce(boolean useBruteForce) {
        this.useBruteForce = useBruteForce;
    }

    public void setVectorCoprocessor(CoprocessorV2 vectorCoprocessor) {
        this.vectorCoprocessor = vectorCoprocessor;
    }

    public void setWithoutTableData(boolean withoutTableData) {
        this.withoutTableData = withoutTableData;
    }

    public void setVectorFilter(VectorFilter vectorFilter) {
        this.vectorFilter = vectorFilter;
    }

    public void setWithoutVectorData(boolean withoutVectorData) {
        this.withoutVectorData = withoutVectorData;
    }

    public void setVectorFilterType(VectorFilterType vectorFilterType) {
        this.vectorFilterType = vectorFilterType;
    }

    public void setTopN(int topN) {
        this.topN = topN;
    }

    public void setSorted(boolean isSorted) {
        this.isSorted = isSorted;
    }

    public void setVectorIds(List<Long> vectorIds) {
        this.vectorIds = vectorIds;
    }

    public void setSelectedKeys(List<String> selectedKeys) {
        this.selectedKeys = selectedKeys;
    }

    public void setNegation(boolean isNegation) {
        this.isNegation = isNegation;
    }

    public void setRadius(float radius) {
        this.radius = radius;
    }

    public void setEnableRangeSearch(boolean enableRangeSearch) {
        this.enableRangeSearch = enableRangeSearch;
    }

    public void setSearch(SearchNest search) {
        this.search = search;
    }

    public void setWithoutScalarData(boolean withoutScalarData) {
        this.withoutScalarData = withoutScalarData;
    }

    @Override
    public void setExt$(Object ext$) {
        this.ext$ = ext$;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VectorSearchParameter)) {
            return false;
        }
        VectorSearchParameter other = (VectorSearchParameter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isUseBruteForce() != other.isUseBruteForce()) {
            return false;
        }
        if (this.isWithoutTableData() != other.isWithoutTableData()) {
            return false;
        }
        if (this.isWithoutVectorData() != other.isWithoutVectorData()) {
            return false;
        }
        if (this.getTopN() != other.getTopN()) {
            return false;
        }
        if (this.isSorted() != other.isSorted()) {
            return false;
        }
        if (this.isNegation() != other.isNegation()) {
            return false;
        }
        if (Float.compare(this.getRadius(), other.getRadius()) != 0) {
            return false;
        }
        if (this.isEnableRangeSearch() != other.isEnableRangeSearch()) {
            return false;
        }
        if (this.isWithoutScalarData() != other.isWithoutScalarData()) {
            return false;
        }
        CoprocessorV2 this$vectorCoprocessor = this.getVectorCoprocessor();
        CoprocessorV2 other$vectorCoprocessor = other.getVectorCoprocessor();
        if (this$vectorCoprocessor == null ? other$vectorCoprocessor != null : !((Object)this$vectorCoprocessor).equals(other$vectorCoprocessor)) {
            return false;
        }
        VectorFilter this$vectorFilter = this.getVectorFilter();
        VectorFilter other$vectorFilter = other.getVectorFilter();
        if (this$vectorFilter == null ? other$vectorFilter != null : !this$vectorFilter.equals(other$vectorFilter)) {
            return false;
        }
        VectorFilterType this$vectorFilterType = this.getVectorFilterType();
        VectorFilterType other$vectorFilterType = other.getVectorFilterType();
        if (this$vectorFilterType == null ? other$vectorFilterType != null : !this$vectorFilterType.equals(other$vectorFilterType)) {
            return false;
        }
        List<Long> this$vectorIds = this.getVectorIds();
        List<Long> other$vectorIds = other.getVectorIds();
        if (this$vectorIds == null ? other$vectorIds != null : !((Object)this$vectorIds).equals(other$vectorIds)) {
            return false;
        }
        List<String> this$selectedKeys = this.getSelectedKeys();
        List<String> other$selectedKeys = other.getSelectedKeys();
        if (this$selectedKeys == null ? other$selectedKeys != null : !((Object)this$selectedKeys).equals(other$selectedKeys)) {
            return false;
        }
        SearchNest this$search = this.getSearch();
        SearchNest other$search = other.getSearch();
        if (this$search == null ? other$search != null : !this$search.equals(other$search)) {
            return false;
        }
        Object this$ext$ = this.getExt$();
        Object other$ext$ = other.getExt$();
        return !(this$ext$ == null ? other$ext$ != null : !this$ext$.equals(other$ext$));
    }

    protected boolean canEqual(Object other) {
        return other instanceof VectorSearchParameter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isUseBruteForce() ? 79 : 97);
        result = result * 59 + (this.isWithoutTableData() ? 79 : 97);
        result = result * 59 + (this.isWithoutVectorData() ? 79 : 97);
        result = result * 59 + this.getTopN();
        result = result * 59 + (this.isSorted() ? 79 : 97);
        result = result * 59 + (this.isNegation() ? 79 : 97);
        result = result * 59 + Float.floatToIntBits(this.getRadius());
        result = result * 59 + (this.isEnableRangeSearch() ? 79 : 97);
        result = result * 59 + (this.isWithoutScalarData() ? 79 : 97);
        CoprocessorV2 $vectorCoprocessor = this.getVectorCoprocessor();
        result = result * 59 + ($vectorCoprocessor == null ? 43 : ((Object)$vectorCoprocessor).hashCode());
        VectorFilter $vectorFilter = this.getVectorFilter();
        result = result * 59 + ($vectorFilter == null ? 43 : $vectorFilter.hashCode());
        VectorFilterType $vectorFilterType = this.getVectorFilterType();
        result = result * 59 + ($vectorFilterType == null ? 43 : $vectorFilterType.hashCode());
        List<Long> $vectorIds = this.getVectorIds();
        result = result * 59 + ($vectorIds == null ? 43 : ((Object)$vectorIds).hashCode());
        List<String> $selectedKeys = this.getSelectedKeys();
        result = result * 59 + ($selectedKeys == null ? 43 : ((Object)$selectedKeys).hashCode());
        SearchNest $search = this.getSearch();
        result = result * 59 + ($search == null ? 43 : $search.hashCode());
        Object $ext$ = this.getExt$();
        result = result * 59 + ($ext$ == null ? 43 : $ext$.hashCode());
        return result;
    }

    public String toString() {
        return "VectorSearchParameter(useBruteForce=" + this.isUseBruteForce() + ", vectorCoprocessor=" + String.valueOf(this.getVectorCoprocessor()) + ", withoutTableData=" + this.isWithoutTableData() + ", vectorFilter=" + String.valueOf(this.getVectorFilter()) + ", withoutVectorData=" + this.isWithoutVectorData() + ", vectorFilterType=" + String.valueOf(this.getVectorFilterType()) + ", topN=" + this.getTopN() + ", isSorted=" + this.isSorted() + ", vectorIds=" + String.valueOf(this.getVectorIds()) + ", selectedKeys=" + String.valueOf(this.getSelectedKeys()) + ", isNegation=" + this.isNegation() + ", radius=" + this.getRadius() + ", enableRangeSearch=" + this.isEnableRangeSearch() + ", search=" + String.valueOf(this.getSearch()) + ", withoutScalarData=" + this.isWithoutScalarData() + ", ext$=" + String.valueOf(this.getExt$()) + ")";
    }

    public VectorSearchParameter() {
    }

    public static interface SearchNest
    extends Message,
    Numeric {
        @Override
        public int number();

        public Nest nest();

        public static enum Nest implements Numeric
        {
            FLAT(11),
            IVF_FLAT(12),
            IVF_PQ(13),
            HNSW(14),
            DISKANN(15),
            BINARY_FLAT(30),
            BINARY_IVF_FLAT(31);

            public final Integer number;

            private Nest(Integer number) {
                this.number = number;
            }

            @Override
            public int number() {
                return this.number;
            }
        }

        public static class BinaryIvfFlat
        extends SearchBinaryIvfFlatParam
        implements SearchNest {
            public static final int number = 31;

            @Override
            public int number() {
                return 31;
            }

            @Override
            public Nest nest() {
                return Nest.BINARY_IVF_FLAT;
            }

            protected BinaryIvfFlat(BinaryIvfFlatBuilder<?, ?> b) {
                super(b);
            }

            public static BinaryIvfFlatBuilder<?, ?> builder() {
                return new BinaryIvfFlatBuilderImpl();
            }

            public BinaryIvfFlat() {
            }

            private static final class BinaryIvfFlatBuilderImpl
            extends BinaryIvfFlatBuilder<BinaryIvfFlat, BinaryIvfFlatBuilderImpl> {
                private BinaryIvfFlatBuilderImpl() {
                }

                @Override
                protected BinaryIvfFlatBuilderImpl self() {
                    return this;
                }

                @Override
                public BinaryIvfFlat build() {
                    return new BinaryIvfFlat(this);
                }
            }

            public static abstract class BinaryIvfFlatBuilder<C extends BinaryIvfFlat, B extends BinaryIvfFlatBuilder<C, B>>
            extends SearchBinaryIvfFlatParam.SearchBinaryIvfFlatParamBuilder<C, B> {
                @Override
                protected abstract B self();

                @Override
                public abstract C build();

                @Override
                public String toString() {
                    return "VectorSearchParameter.SearchNest.BinaryIvfFlat.BinaryIvfFlatBuilder(super=" + super.toString() + ")";
                }
            }
        }

        public static class BinaryFlat
        extends SearchBinaryFlatParam
        implements SearchNest {
            public static final int number = 30;

            @Override
            public int number() {
                return 30;
            }

            @Override
            public Nest nest() {
                return Nest.BINARY_FLAT;
            }

            protected BinaryFlat(BinaryFlatBuilder<?, ?> b) {
                super(b);
            }

            public static BinaryFlatBuilder<?, ?> builder() {
                return new BinaryFlatBuilderImpl();
            }

            public BinaryFlat() {
            }

            private static final class BinaryFlatBuilderImpl
            extends BinaryFlatBuilder<BinaryFlat, BinaryFlatBuilderImpl> {
                private BinaryFlatBuilderImpl() {
                }

                @Override
                protected BinaryFlatBuilderImpl self() {
                    return this;
                }

                @Override
                public BinaryFlat build() {
                    return new BinaryFlat(this);
                }
            }

            public static abstract class BinaryFlatBuilder<C extends BinaryFlat, B extends BinaryFlatBuilder<C, B>>
            extends SearchBinaryFlatParam.SearchBinaryFlatParamBuilder<C, B> {
                @Override
                protected abstract B self();

                @Override
                public abstract C build();

                @Override
                public String toString() {
                    return "VectorSearchParameter.SearchNest.BinaryFlat.BinaryFlatBuilder(super=" + super.toString() + ")";
                }
            }
        }

        public static class Diskann
        extends SearchDiskAnnParam
        implements SearchNest {
            public static final int number = 15;

            @Override
            public int number() {
                return 15;
            }

            @Override
            public Nest nest() {
                return Nest.DISKANN;
            }

            protected Diskann(DiskannBuilder<?, ?> b) {
                super(b);
            }

            public static DiskannBuilder<?, ?> builder() {
                return new DiskannBuilderImpl();
            }

            public Diskann() {
            }

            private static final class DiskannBuilderImpl
            extends DiskannBuilder<Diskann, DiskannBuilderImpl> {
                private DiskannBuilderImpl() {
                }

                @Override
                protected DiskannBuilderImpl self() {
                    return this;
                }

                @Override
                public Diskann build() {
                    return new Diskann(this);
                }
            }

            public static abstract class DiskannBuilder<C extends Diskann, B extends DiskannBuilder<C, B>>
            extends SearchDiskAnnParam.SearchDiskAnnParamBuilder<C, B> {
                @Override
                protected abstract B self();

                @Override
                public abstract C build();

                @Override
                public String toString() {
                    return "VectorSearchParameter.SearchNest.Diskann.DiskannBuilder(super=" + super.toString() + ")";
                }
            }
        }

        public static class Hnsw
        extends SearchHNSWParam
        implements SearchNest {
            public static final int number = 14;

            @Override
            public int number() {
                return 14;
            }

            @Override
            public Nest nest() {
                return Nest.HNSW;
            }

            protected Hnsw(HnswBuilder<?, ?> b) {
                super(b);
            }

            public static HnswBuilder<?, ?> builder() {
                return new HnswBuilderImpl();
            }

            public Hnsw() {
            }

            private static final class HnswBuilderImpl
            extends HnswBuilder<Hnsw, HnswBuilderImpl> {
                private HnswBuilderImpl() {
                }

                @Override
                protected HnswBuilderImpl self() {
                    return this;
                }

                @Override
                public Hnsw build() {
                    return new Hnsw(this);
                }
            }

            public static abstract class HnswBuilder<C extends Hnsw, B extends HnswBuilder<C, B>>
            extends SearchHNSWParam.SearchHNSWParamBuilder<C, B> {
                @Override
                protected abstract B self();

                @Override
                public abstract C build();

                @Override
                public String toString() {
                    return "VectorSearchParameter.SearchNest.Hnsw.HnswBuilder(super=" + super.toString() + ")";
                }
            }
        }

        public static class IvfPq
        extends SearchIvfPqParam
        implements SearchNest {
            public static final int number = 13;

            @Override
            public int number() {
                return 13;
            }

            @Override
            public Nest nest() {
                return Nest.IVF_PQ;
            }

            protected IvfPq(IvfPqBuilder<?, ?> b) {
                super(b);
            }

            public static IvfPqBuilder<?, ?> builder() {
                return new IvfPqBuilderImpl();
            }

            public IvfPq() {
            }

            private static final class IvfPqBuilderImpl
            extends IvfPqBuilder<IvfPq, IvfPqBuilderImpl> {
                private IvfPqBuilderImpl() {
                }

                @Override
                protected IvfPqBuilderImpl self() {
                    return this;
                }

                @Override
                public IvfPq build() {
                    return new IvfPq(this);
                }
            }

            public static abstract class IvfPqBuilder<C extends IvfPq, B extends IvfPqBuilder<C, B>>
            extends SearchIvfPqParam.SearchIvfPqParamBuilder<C, B> {
                @Override
                protected abstract B self();

                @Override
                public abstract C build();

                @Override
                public String toString() {
                    return "VectorSearchParameter.SearchNest.IvfPq.IvfPqBuilder(super=" + super.toString() + ")";
                }
            }
        }

        public static class IvfFlat
        extends SearchIvfFlatParam
        implements SearchNest {
            public static final int number = 12;

            @Override
            public int number() {
                return 12;
            }

            @Override
            public Nest nest() {
                return Nest.IVF_FLAT;
            }

            protected IvfFlat(IvfFlatBuilder<?, ?> b) {
                super(b);
            }

            public static IvfFlatBuilder<?, ?> builder() {
                return new IvfFlatBuilderImpl();
            }

            public IvfFlat() {
            }

            private static final class IvfFlatBuilderImpl
            extends IvfFlatBuilder<IvfFlat, IvfFlatBuilderImpl> {
                private IvfFlatBuilderImpl() {
                }

                @Override
                protected IvfFlatBuilderImpl self() {
                    return this;
                }

                @Override
                public IvfFlat build() {
                    return new IvfFlat(this);
                }
            }

            public static abstract class IvfFlatBuilder<C extends IvfFlat, B extends IvfFlatBuilder<C, B>>
            extends SearchIvfFlatParam.SearchIvfFlatParamBuilder<C, B> {
                @Override
                protected abstract B self();

                @Override
                public abstract C build();

                @Override
                public String toString() {
                    return "VectorSearchParameter.SearchNest.IvfFlat.IvfFlatBuilder(super=" + super.toString() + ")";
                }
            }
        }

        public static class Flat
        extends SearchFlatParam
        implements SearchNest {
            public static final int number = 11;

            @Override
            public int number() {
                return 11;
            }

            @Override
            public Nest nest() {
                return Nest.FLAT;
            }

            protected Flat(FlatBuilder<?, ?> b) {
                super(b);
            }

            public static FlatBuilder<?, ?> builder() {
                return new FlatBuilderImpl();
            }

            public Flat() {
            }

            private static final class FlatBuilderImpl
            extends FlatBuilder<Flat, FlatBuilderImpl> {
                private FlatBuilderImpl() {
                }

                @Override
                protected FlatBuilderImpl self() {
                    return this;
                }

                @Override
                public Flat build() {
                    return new Flat(this);
                }
            }

            public static abstract class FlatBuilder<C extends Flat, B extends FlatBuilder<C, B>>
            extends SearchFlatParam.SearchFlatParamBuilder<C, B> {
                @Override
                protected abstract B self();

                @Override
                public abstract C build();

                @Override
                public String toString() {
                    return "VectorSearchParameter.SearchNest.Flat.FlatBuilder(super=" + super.toString() + ")";
                }
            }
        }
    }

    public static abstract class VectorSearchParameterBuilder<C extends VectorSearchParameter, B extends VectorSearchParameterBuilder<C, B>> {
        private boolean useBruteForce;
        private CoprocessorV2 vectorCoprocessor;
        private boolean withoutTableData;
        private VectorFilter vectorFilter;
        private boolean withoutVectorData;
        private VectorFilterType vectorFilterType;
        private int topN;
        private boolean isSorted;
        private List<Long> vectorIds;
        private List<String> selectedKeys;
        private boolean isNegation;
        private float radius;
        private boolean enableRangeSearch;
        private SearchNest search;
        private boolean withoutScalarData;
        private Object ext$;

        protected abstract B self();

        public abstract C build();

        public B useBruteForce(boolean useBruteForce) {
            this.useBruteForce = useBruteForce;
            return this.self();
        }

        public B vectorCoprocessor(CoprocessorV2 vectorCoprocessor) {
            this.vectorCoprocessor = vectorCoprocessor;
            return this.self();
        }

        public B withoutTableData(boolean withoutTableData) {
            this.withoutTableData = withoutTableData;
            return this.self();
        }

        public B vectorFilter(VectorFilter vectorFilter) {
            this.vectorFilter = vectorFilter;
            return this.self();
        }

        public B withoutVectorData(boolean withoutVectorData) {
            this.withoutVectorData = withoutVectorData;
            return this.self();
        }

        public B vectorFilterType(VectorFilterType vectorFilterType) {
            this.vectorFilterType = vectorFilterType;
            return this.self();
        }

        public B topN(int topN) {
            this.topN = topN;
            return this.self();
        }

        public B isSorted(boolean isSorted) {
            this.isSorted = isSorted;
            return this.self();
        }

        public B vectorIds(List<Long> vectorIds) {
            this.vectorIds = vectorIds;
            return this.self();
        }

        public B selectedKeys(List<String> selectedKeys) {
            this.selectedKeys = selectedKeys;
            return this.self();
        }

        public B isNegation(boolean isNegation) {
            this.isNegation = isNegation;
            return this.self();
        }

        public B radius(float radius) {
            this.radius = radius;
            return this.self();
        }

        public B enableRangeSearch(boolean enableRangeSearch) {
            this.enableRangeSearch = enableRangeSearch;
            return this.self();
        }

        public B search(SearchNest search) {
            this.search = search;
            return this.self();
        }

        public B withoutScalarData(boolean withoutScalarData) {
            this.withoutScalarData = withoutScalarData;
            return this.self();
        }

        public B ext$(Object ext$) {
            this.ext$ = ext$;
            return this.self();
        }

        public String toString() {
            return "VectorSearchParameter.VectorSearchParameterBuilder(useBruteForce=" + this.useBruteForce + ", vectorCoprocessor=" + String.valueOf(this.vectorCoprocessor) + ", withoutTableData=" + this.withoutTableData + ", vectorFilter=" + String.valueOf(this.vectorFilter) + ", withoutVectorData=" + this.withoutVectorData + ", vectorFilterType=" + String.valueOf(this.vectorFilterType) + ", topN=" + this.topN + ", isSorted=" + this.isSorted + ", vectorIds=" + String.valueOf(this.vectorIds) + ", selectedKeys=" + String.valueOf(this.selectedKeys) + ", isNegation=" + this.isNegation + ", radius=" + this.radius + ", enableRangeSearch=" + this.enableRangeSearch + ", search=" + String.valueOf(this.search) + ", withoutScalarData=" + this.withoutScalarData + ", ext$=" + String.valueOf(this.ext$) + ")";
        }
    }

    private static final class VectorSearchParameterBuilderImpl
    extends VectorSearchParameterBuilder<VectorSearchParameter, VectorSearchParameterBuilderImpl> {
        private VectorSearchParameterBuilderImpl() {
        }

        @Override
        protected VectorSearchParameterBuilderImpl self() {
            return this;
        }

        @Override
        public VectorSearchParameter build() {
            return new VectorSearchParameter(this);
        }
    }

    public static final class Fields {
        public static final String useBruteForce = "useBruteForce";
        public static final String vectorCoprocessor = "vectorCoprocessor";
        public static final String withoutTableData = "withoutTableData";
        public static final String vectorFilter = "vectorFilter";
        public static final String withoutVectorData = "withoutVectorData";
        public static final String vectorFilterType = "vectorFilterType";
        public static final String topN = "topN";
        public static final String isSorted = "isSorted";
        public static final String vectorIds = "vectorIds";
        public static final String selectedKeys = "selectedKeys";
        public static final String isNegation = "isNegation";
        public static final String radius = "radius";
        public static final String enableRangeSearch = "enableRangeSearch";
        public static final String search = "search";
        public static final String withoutScalarData = "withoutScalarData";
        public static final String ext$ = "ext$";
    }
}

