/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.service.entity.common;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.Numeric;
import io.dingodb.sdk.service.entity.common.LoadDiskAnnParam;
import io.dingodb.sdk.service.entity.common.LoadFlatParam;
import io.dingodb.sdk.service.entity.common.LoadHNSWParam;
import io.dingodb.sdk.service.entity.common.LoadIvfFlatParam;
import io.dingodb.sdk.service.entity.common.LoadIvfPqParam;

public class VectorLoadParameter
implements Message {
    private LoadNest load;
    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(this.load, (Message)this.load, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        block7: while ((number = Reader.readNumber(input)) != 0) {
            switch (number) {
                case 1: {
                    this.load = Reader.readMessage(new LoadNest.Flat(), input);
                    hasValue = hasValue ? hasValue : this.load != null;
                    continue block7;
                }
                case 2: {
                    this.load = Reader.readMessage(new LoadNest.IvfFlat(), input);
                    hasValue = hasValue ? hasValue : this.load != null;
                    continue block7;
                }
                case 3: {
                    this.load = Reader.readMessage(new LoadNest.IvfPq(), input);
                    hasValue = hasValue ? hasValue : this.load != null;
                    continue block7;
                }
                case 4: {
                    this.load = Reader.readMessage(new LoadNest.Hnsw(), input);
                    hasValue = hasValue ? hasValue : this.load != null;
                    continue block7;
                }
                case 5: {
                    this.load = Reader.readMessage(new LoadNest.Diskann(), input);
                    hasValue = hasValue ? hasValue : this.load != null;
                    continue block7;
                }
            }
            Reader.skip(input);
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        return size += SizeUtils.sizeOf(this.load, (Message)this.load).intValue();
    }

    protected VectorLoadParameter(VectorLoadParameterBuilder<?, ?> b) {
        this.load = b.load;
        this.ext$ = b.ext$;
    }

    public static VectorLoadParameterBuilder<?, ?> builder() {
        return new VectorLoadParameterBuilderImpl();
    }

    public LoadNest getLoad() {
        return this.load;
    }

    @Override
    public Object getExt$() {
        return this.ext$;
    }

    public void setLoad(LoadNest load) {
        this.load = load;
    }

    @Override
    public void setExt$(Object ext$) {
        this.ext$ = ext$;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VectorLoadParameter)) {
            return false;
        }
        VectorLoadParameter other = (VectorLoadParameter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        LoadNest this$load = this.getLoad();
        LoadNest other$load = other.getLoad();
        if (this$load == null ? other$load != null : !this$load.equals(other$load)) {
            return false;
        }
        Object this$ext$ = this.getExt$();
        Object other$ext$ = other.getExt$();
        return !(this$ext$ == null ? other$ext$ != null : !this$ext$.equals(other$ext$));
    }

    protected boolean canEqual(Object other) {
        return other instanceof VectorLoadParameter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        LoadNest $load = this.getLoad();
        result = result * 59 + ($load == null ? 43 : $load.hashCode());
        Object $ext$ = this.getExt$();
        result = result * 59 + ($ext$ == null ? 43 : $ext$.hashCode());
        return result;
    }

    public String toString() {
        return "VectorLoadParameter(load=" + String.valueOf(this.getLoad()) + ", ext$=" + String.valueOf(this.getExt$()) + ")";
    }

    public VectorLoadParameter() {
    }

    public static interface LoadNest
    extends Message,
    Numeric {
        @Override
        public int number();

        public Nest nest();

        public static enum Nest implements Numeric
        {
            FLAT(1),
            IVF_FLAT(2),
            IVF_PQ(3),
            HNSW(4),
            DISKANN(5);

            public final Integer number;

            private Nest(Integer number) {
                this.number = number;
            }

            @Override
            public int number() {
                return this.number;
            }
        }

        public static class Diskann
        extends LoadDiskAnnParam
        implements LoadNest {
            public static final int number = 5;

            @Override
            public int number() {
                return 5;
            }

            @Override
            public Nest nest() {
                return Nest.DISKANN;
            }

            protected Diskann(DiskannBuilder<?, ?> b) {
                super(b);
            }

            public static DiskannBuilder<?, ?> builder() {
                return new DiskannBuilderImpl();
            }

            public Diskann() {
            }

            private static final class DiskannBuilderImpl
            extends DiskannBuilder<Diskann, DiskannBuilderImpl> {
                private DiskannBuilderImpl() {
                }

                @Override
                protected DiskannBuilderImpl self() {
                    return this;
                }

                @Override
                public Diskann build() {
                    return new Diskann(this);
                }
            }

            public static abstract class DiskannBuilder<C extends Diskann, B extends DiskannBuilder<C, B>>
            extends LoadDiskAnnParam.LoadDiskAnnParamBuilder<C, B> {
                @Override
                protected abstract B self();

                @Override
                public abstract C build();

                @Override
                public String toString() {
                    return "VectorLoadParameter.LoadNest.Diskann.DiskannBuilder(super=" + super.toString() + ")";
                }
            }
        }

        public static class Hnsw
        extends LoadHNSWParam
        implements LoadNest {
            public static final int number = 4;

            @Override
            public int number() {
                return 4;
            }

            @Override
            public Nest nest() {
                return Nest.HNSW;
            }

            protected Hnsw(HnswBuilder<?, ?> b) {
                super(b);
            }

            public static HnswBuilder<?, ?> builder() {
                return new HnswBuilderImpl();
            }

            public Hnsw() {
            }

            private static final class HnswBuilderImpl
            extends HnswBuilder<Hnsw, HnswBuilderImpl> {
                private HnswBuilderImpl() {
                }

                @Override
                protected HnswBuilderImpl self() {
                    return this;
                }

                @Override
                public Hnsw build() {
                    return new Hnsw(this);
                }
            }

            public static abstract class HnswBuilder<C extends Hnsw, B extends HnswBuilder<C, B>>
            extends LoadHNSWParam.LoadHNSWParamBuilder<C, B> {
                @Override
                protected abstract B self();

                @Override
                public abstract C build();

                @Override
                public String toString() {
                    return "VectorLoadParameter.LoadNest.Hnsw.HnswBuilder(super=" + super.toString() + ")";
                }
            }
        }

        public static class IvfPq
        extends LoadIvfPqParam
        implements LoadNest {
            public static final int number = 3;

            @Override
            public int number() {
                return 3;
            }

            @Override
            public Nest nest() {
                return Nest.IVF_PQ;
            }

            protected IvfPq(IvfPqBuilder<?, ?> b) {
                super(b);
            }

            public static IvfPqBuilder<?, ?> builder() {
                return new IvfPqBuilderImpl();
            }

            public IvfPq() {
            }

            private static final class IvfPqBuilderImpl
            extends IvfPqBuilder<IvfPq, IvfPqBuilderImpl> {
                private IvfPqBuilderImpl() {
                }

                @Override
                protected IvfPqBuilderImpl self() {
                    return this;
                }

                @Override
                public IvfPq build() {
                    return new IvfPq(this);
                }
            }

            public static abstract class IvfPqBuilder<C extends IvfPq, B extends IvfPqBuilder<C, B>>
            extends LoadIvfPqParam.LoadIvfPqParamBuilder<C, B> {
                @Override
                protected abstract B self();

                @Override
                public abstract C build();

                @Override
                public String toString() {
                    return "VectorLoadParameter.LoadNest.IvfPq.IvfPqBuilder(super=" + super.toString() + ")";
                }
            }
        }

        public static class IvfFlat
        extends LoadIvfFlatParam
        implements LoadNest {
            public static final int number = 2;

            @Override
            public int number() {
                return 2;
            }

            @Override
            public Nest nest() {
                return Nest.IVF_FLAT;
            }

            protected IvfFlat(IvfFlatBuilder<?, ?> b) {
                super(b);
            }

            public static IvfFlatBuilder<?, ?> builder() {
                return new IvfFlatBuilderImpl();
            }

            public IvfFlat() {
            }

            private static final class IvfFlatBuilderImpl
            extends IvfFlatBuilder<IvfFlat, IvfFlatBuilderImpl> {
                private IvfFlatBuilderImpl() {
                }

                @Override
                protected IvfFlatBuilderImpl self() {
                    return this;
                }

                @Override
                public IvfFlat build() {
                    return new IvfFlat(this);
                }
            }

            public static abstract class IvfFlatBuilder<C extends IvfFlat, B extends IvfFlatBuilder<C, B>>
            extends LoadIvfFlatParam.LoadIvfFlatParamBuilder<C, B> {
                @Override
                protected abstract B self();

                @Override
                public abstract C build();

                @Override
                public String toString() {
                    return "VectorLoadParameter.LoadNest.IvfFlat.IvfFlatBuilder(super=" + super.toString() + ")";
                }
            }
        }

        public static class Flat
        extends LoadFlatParam
        implements LoadNest {
            public static final int number = 1;

            @Override
            public int number() {
                return 1;
            }

            @Override
            public Nest nest() {
                return Nest.FLAT;
            }

            protected Flat(FlatBuilder<?, ?> b) {
                super(b);
            }

            public static FlatBuilder<?, ?> builder() {
                return new FlatBuilderImpl();
            }

            public Flat() {
            }

            private static final class FlatBuilderImpl
            extends FlatBuilder<Flat, FlatBuilderImpl> {
                private FlatBuilderImpl() {
                }

                @Override
                protected FlatBuilderImpl self() {
                    return this;
                }

                @Override
                public Flat build() {
                    return new Flat(this);
                }
            }

            public static abstract class FlatBuilder<C extends Flat, B extends FlatBuilder<C, B>>
            extends LoadFlatParam.LoadFlatParamBuilder<C, B> {
                @Override
                protected abstract B self();

                @Override
                public abstract C build();

                @Override
                public String toString() {
                    return "VectorLoadParameter.LoadNest.Flat.FlatBuilder(super=" + super.toString() + ")";
                }
            }
        }
    }

    public static abstract class VectorLoadParameterBuilder<C extends VectorLoadParameter, B extends VectorLoadParameterBuilder<C, B>> {
        private LoadNest load;
        private Object ext$;

        protected abstract B self();

        public abstract C build();

        public B load(LoadNest load) {
            this.load = load;
            return this.self();
        }

        public B ext$(Object ext$) {
            this.ext$ = ext$;
            return this.self();
        }

        public String toString() {
            return "VectorLoadParameter.VectorLoadParameterBuilder(load=" + String.valueOf(this.load) + ", ext$=" + String.valueOf(this.ext$) + ")";
        }
    }

    private static final class VectorLoadParameterBuilderImpl
    extends VectorLoadParameterBuilder<VectorLoadParameter, VectorLoadParameterBuilderImpl> {
        private VectorLoadParameterBuilderImpl() {
        }

        @Override
        protected VectorLoadParameterBuilderImpl self() {
            return this;
        }

        @Override
        public VectorLoadParameter build() {
            return new VectorLoadParameter(this);
        }
    }

    public static final class Fields {
        public static final String load = "load";
        public static final String ext$ = "ext$";
    }
}

