/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.service.entity.common;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.common.ValueType;
import java.util.List;

public class Vector
implements Message {
    private int dimension;
    private List<Float> floatValues;
    private List<byte[]> binaryValues;
    private ValueType valueType;
    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write((Integer)1, this.dimension, out);
        Writer.write((Integer)2, this.valueType, out);
        Writer.write(3, this.floatValues, out, Writer::write, SizeUtils::sizeOf);
        Writer.write((Integer)4, this.binaryValues, (n, v) -> Writer.write(n, v, out));
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        block6: while ((number = Reader.readNumber(input)) != 0) {
            switch (number) {
                case 1: {
                    this.dimension = Reader.readInt(input);
                    hasValue = true;
                    continue block6;
                }
                case 2: {
                    this.valueType = ValueType.forNumber(Reader.readInt(input));
                    hasValue = true;
                    continue block6;
                }
                case 3: {
                    this.floatValues = Reader.readPack(input, Reader::readFloat);
                    hasValue = true;
                    continue block6;
                }
                case 4: {
                    this.binaryValues = Reader.readList(this.binaryValues, input, Reader::readBytes);
                    hasValue = true;
                    continue block6;
                }
            }
            Reader.skip(input);
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf((Integer)1, this.dimension).intValue();
        size += SizeUtils.sizeOf((Integer)2, this.valueType).intValue();
        size += SizeUtils.sizeOfPack(3, this.floatValues, SizeUtils::sizeOf);
        return size += SizeUtils.sizeOf(4, this.binaryValues, SizeUtils::sizeOf);
    }

    protected Vector(VectorBuilder<?, ?> b) {
        this.dimension = b.dimension;
        this.floatValues = b.floatValues;
        this.binaryValues = b.binaryValues;
        this.valueType = b.valueType;
        this.ext$ = b.ext$;
    }

    public static VectorBuilder<?, ?> builder() {
        return new VectorBuilderImpl();
    }

    public int getDimension() {
        return this.dimension;
    }

    public List<Float> getFloatValues() {
        return this.floatValues;
    }

    public List<byte[]> getBinaryValues() {
        return this.binaryValues;
    }

    public ValueType getValueType() {
        return this.valueType;
    }

    @Override
    public Object getExt$() {
        return this.ext$;
    }

    public void setDimension(int dimension) {
        this.dimension = dimension;
    }

    public void setFloatValues(List<Float> floatValues) {
        this.floatValues = floatValues;
    }

    public void setBinaryValues(List<byte[]> binaryValues) {
        this.binaryValues = binaryValues;
    }

    public void setValueType(ValueType valueType) {
        this.valueType = valueType;
    }

    @Override
    public void setExt$(Object ext$) {
        this.ext$ = ext$;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Vector)) {
            return false;
        }
        Vector other = (Vector)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getDimension() != other.getDimension()) {
            return false;
        }
        List<Float> this$floatValues = this.getFloatValues();
        List<Float> other$floatValues = other.getFloatValues();
        if (this$floatValues == null ? other$floatValues != null : !((Object)this$floatValues).equals(other$floatValues)) {
            return false;
        }
        List<byte[]> this$binaryValues = this.getBinaryValues();
        List<byte[]> other$binaryValues = other.getBinaryValues();
        if (this$binaryValues == null ? other$binaryValues != null : !((Object)this$binaryValues).equals(other$binaryValues)) {
            return false;
        }
        ValueType this$valueType = this.getValueType();
        ValueType other$valueType = other.getValueType();
        if (this$valueType == null ? other$valueType != null : !this$valueType.equals(other$valueType)) {
            return false;
        }
        Object this$ext$ = this.getExt$();
        Object other$ext$ = other.getExt$();
        return !(this$ext$ == null ? other$ext$ != null : !this$ext$.equals(other$ext$));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Vector;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getDimension();
        List<Float> $floatValues = this.getFloatValues();
        result = result * 59 + ($floatValues == null ? 43 : ((Object)$floatValues).hashCode());
        List<byte[]> $binaryValues = this.getBinaryValues();
        result = result * 59 + ($binaryValues == null ? 43 : ((Object)$binaryValues).hashCode());
        ValueType $valueType = this.getValueType();
        result = result * 59 + ($valueType == null ? 43 : $valueType.hashCode());
        Object $ext$ = this.getExt$();
        result = result * 59 + ($ext$ == null ? 43 : $ext$.hashCode());
        return result;
    }

    public String toString() {
        return "Vector(dimension=" + this.getDimension() + ", floatValues=" + String.valueOf(this.getFloatValues()) + ", binaryValues=" + String.valueOf(this.getBinaryValues()) + ", valueType=" + String.valueOf(this.getValueType()) + ", ext$=" + String.valueOf(this.getExt$()) + ")";
    }

    public Vector() {
    }

    public static abstract class VectorBuilder<C extends Vector, B extends VectorBuilder<C, B>> {
        private int dimension;
        private List<Float> floatValues;
        private List<byte[]> binaryValues;
        private ValueType valueType;
        private Object ext$;

        protected abstract B self();

        public abstract C build();

        public B dimension(int dimension) {
            this.dimension = dimension;
            return this.self();
        }

        public B floatValues(List<Float> floatValues) {
            this.floatValues = floatValues;
            return this.self();
        }

        public B binaryValues(List<byte[]> binaryValues) {
            this.binaryValues = binaryValues;
            return this.self();
        }

        public B valueType(ValueType valueType) {
            this.valueType = valueType;
            return this.self();
        }

        public B ext$(Object ext$) {
            this.ext$ = ext$;
            return this.self();
        }

        public String toString() {
            return "Vector.VectorBuilder(dimension=" + this.dimension + ", floatValues=" + String.valueOf(this.floatValues) + ", binaryValues=" + String.valueOf(this.binaryValues) + ", valueType=" + String.valueOf(this.valueType) + ", ext$=" + String.valueOf(this.ext$) + ")";
        }
    }

    private static final class VectorBuilderImpl
    extends VectorBuilder<Vector, VectorBuilderImpl> {
        private VectorBuilderImpl() {
        }

        @Override
        protected VectorBuilderImpl self() {
            return this;
        }

        @Override
        public Vector build() {
            return new Vector(this);
        }
    }

    public static final class Fields {
        public static final String dimension = "dimension";
        public static final String floatValues = "floatValues";
        public static final String binaryValues = "binaryValues";
        public static final String valueType = "valueType";
        public static final String ext$ = "ext$";
    }
}

