/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.service.entity.common;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.common.IndexParameter;
import io.dingodb.sdk.service.entity.common.Peer;
import io.dingodb.sdk.service.entity.common.Range;
import io.dingodb.sdk.service.entity.common.RawEngine;
import io.dingodb.sdk.service.entity.common.RegionEpoch;
import io.dingodb.sdk.service.entity.common.StorageEngine;
import java.util.List;

public class RegionDefinition
implements Message {
    private StorageEngine storeEngine;
    private long tenantId;
    private long partId;
    private String name;
    private RegionEpoch epoch;
    private long tableId;
    private long schemaId;
    private long id;
    private IndexParameter indexParameter;
    private long indexId;
    private long revision;
    private Range range;
    private List<Peer> peers;
    private RawEngine rawEngine;
    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write((Integer)1, this.id, out);
        Writer.write((Integer)2, (Message)this.epoch, out);
        Writer.write((Integer)3, this.name, out);
        Writer.write((Integer)4, this.peers, (n, v) -> Writer.write(n, (Message)v, out));
        Writer.write((Integer)5, (Message)this.range, out);
        Writer.write((Integer)6, this.rawEngine, out);
        Writer.write((Integer)7, this.storeEngine, out);
        Writer.write((Integer)11, this.schemaId, out);
        Writer.write((Integer)12, this.tableId, out);
        Writer.write((Integer)13, this.indexId, out);
        Writer.write((Integer)14, this.partId, out);
        Writer.write((Integer)15, this.tenantId, out);
        Writer.write((Integer)20, (Message)this.indexParameter, out);
        Writer.write((Integer)50, this.revision, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        block16: while ((number = Reader.readNumber(input)) != 0) {
            switch (number) {
                case 1: {
                    this.id = Reader.readLong(input);
                    hasValue = true;
                    continue block16;
                }
                case 2: {
                    this.epoch = Reader.readMessage(new RegionEpoch(), input);
                    hasValue = hasValue ? hasValue : this.epoch != null;
                    continue block16;
                }
                case 3: {
                    this.name = Reader.readString(input);
                    hasValue = true;
                    continue block16;
                }
                case 4: {
                    this.peers = Reader.readList(this.peers, input, in -> Reader.readMessage(new Peer(), in));
                    hasValue = true;
                    continue block16;
                }
                case 5: {
                    this.range = Reader.readMessage(new Range(), input);
                    hasValue = hasValue ? hasValue : this.range != null;
                    continue block16;
                }
                case 6: {
                    this.rawEngine = RawEngine.forNumber(Reader.readInt(input));
                    hasValue = true;
                    continue block16;
                }
                case 7: {
                    this.storeEngine = StorageEngine.forNumber(Reader.readInt(input));
                    hasValue = true;
                    continue block16;
                }
                case 11: {
                    this.schemaId = Reader.readLong(input);
                    hasValue = true;
                    continue block16;
                }
                case 12: {
                    this.tableId = Reader.readLong(input);
                    hasValue = true;
                    continue block16;
                }
                case 13: {
                    this.indexId = Reader.readLong(input);
                    hasValue = true;
                    continue block16;
                }
                case 14: {
                    this.partId = Reader.readLong(input);
                    hasValue = true;
                    continue block16;
                }
                case 15: {
                    this.tenantId = Reader.readLong(input);
                    hasValue = true;
                    continue block16;
                }
                case 20: {
                    this.indexParameter = Reader.readMessage(new IndexParameter(), input);
                    hasValue = hasValue ? hasValue : this.indexParameter != null;
                    continue block16;
                }
                case 50: {
                    this.revision = Reader.readLong(input);
                    hasValue = true;
                    continue block16;
                }
            }
            Reader.skip(input);
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf((Integer)1, this.id).intValue();
        size += SizeUtils.sizeOf((Integer)2, (Message)this.epoch).intValue();
        size += SizeUtils.sizeOf((Integer)3, this.name).intValue();
        size += SizeUtils.sizeOf(4, this.peers, SizeUtils::sizeOf);
        size += SizeUtils.sizeOf((Integer)5, (Message)this.range).intValue();
        size += SizeUtils.sizeOf((Integer)6, this.rawEngine).intValue();
        size += SizeUtils.sizeOf((Integer)7, this.storeEngine).intValue();
        size += SizeUtils.sizeOf((Integer)11, this.schemaId).intValue();
        size += SizeUtils.sizeOf((Integer)12, this.tableId).intValue();
        size += SizeUtils.sizeOf((Integer)13, this.indexId).intValue();
        size += SizeUtils.sizeOf((Integer)14, this.partId).intValue();
        size += SizeUtils.sizeOf((Integer)15, this.tenantId).intValue();
        size += SizeUtils.sizeOf((Integer)20, (Message)this.indexParameter).intValue();
        return size += SizeUtils.sizeOf((Integer)50, this.revision).intValue();
    }

    protected RegionDefinition(RegionDefinitionBuilder<?, ?> b) {
        this.storeEngine = b.storeEngine;
        this.tenantId = b.tenantId;
        this.partId = b.partId;
        this.name = b.name;
        this.epoch = b.epoch;
        this.tableId = b.tableId;
        this.schemaId = b.schemaId;
        this.id = b.id;
        this.indexParameter = b.indexParameter;
        this.indexId = b.indexId;
        this.revision = b.revision;
        this.range = b.range;
        this.peers = b.peers;
        this.rawEngine = b.rawEngine;
        this.ext$ = b.ext$;
    }

    public static RegionDefinitionBuilder<?, ?> builder() {
        return new RegionDefinitionBuilderImpl();
    }

    public StorageEngine getStoreEngine() {
        return this.storeEngine;
    }

    public long getTenantId() {
        return this.tenantId;
    }

    public long getPartId() {
        return this.partId;
    }

    public String getName() {
        return this.name;
    }

    public RegionEpoch getEpoch() {
        return this.epoch;
    }

    public long getTableId() {
        return this.tableId;
    }

    public long getSchemaId() {
        return this.schemaId;
    }

    public long getId() {
        return this.id;
    }

    public IndexParameter getIndexParameter() {
        return this.indexParameter;
    }

    public long getIndexId() {
        return this.indexId;
    }

    public long getRevision() {
        return this.revision;
    }

    public Range getRange() {
        return this.range;
    }

    public List<Peer> getPeers() {
        return this.peers;
    }

    public RawEngine getRawEngine() {
        return this.rawEngine;
    }

    @Override
    public Object getExt$() {
        return this.ext$;
    }

    public void setStoreEngine(StorageEngine storeEngine) {
        this.storeEngine = storeEngine;
    }

    public void setTenantId(long tenantId) {
        this.tenantId = tenantId;
    }

    public void setPartId(long partId) {
        this.partId = partId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setEpoch(RegionEpoch epoch) {
        this.epoch = epoch;
    }

    public void setTableId(long tableId) {
        this.tableId = tableId;
    }

    public void setSchemaId(long schemaId) {
        this.schemaId = schemaId;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setIndexParameter(IndexParameter indexParameter) {
        this.indexParameter = indexParameter;
    }

    public void setIndexId(long indexId) {
        this.indexId = indexId;
    }

    public void setRevision(long revision) {
        this.revision = revision;
    }

    public void setRange(Range range) {
        this.range = range;
    }

    public void setPeers(List<Peer> peers) {
        this.peers = peers;
    }

    public void setRawEngine(RawEngine rawEngine) {
        this.rawEngine = rawEngine;
    }

    @Override
    public void setExt$(Object ext$) {
        this.ext$ = ext$;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RegionDefinition)) {
            return false;
        }
        RegionDefinition other = (RegionDefinition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTenantId() != other.getTenantId()) {
            return false;
        }
        if (this.getPartId() != other.getPartId()) {
            return false;
        }
        if (this.getTableId() != other.getTableId()) {
            return false;
        }
        if (this.getSchemaId() != other.getSchemaId()) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        if (this.getIndexId() != other.getIndexId()) {
            return false;
        }
        if (this.getRevision() != other.getRevision()) {
            return false;
        }
        StorageEngine this$storeEngine = this.getStoreEngine();
        StorageEngine other$storeEngine = other.getStoreEngine();
        if (this$storeEngine == null ? other$storeEngine != null : !this$storeEngine.equals(other$storeEngine)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        RegionEpoch this$epoch = this.getEpoch();
        RegionEpoch other$epoch = other.getEpoch();
        if (this$epoch == null ? other$epoch != null : !((Object)this$epoch).equals(other$epoch)) {
            return false;
        }
        IndexParameter this$indexParameter = this.getIndexParameter();
        IndexParameter other$indexParameter = other.getIndexParameter();
        if (this$indexParameter == null ? other$indexParameter != null : !((Object)this$indexParameter).equals(other$indexParameter)) {
            return false;
        }
        Range this$range = this.getRange();
        Range other$range = other.getRange();
        if (this$range == null ? other$range != null : !((Object)this$range).equals(other$range)) {
            return false;
        }
        List<Peer> this$peers = this.getPeers();
        List<Peer> other$peers = other.getPeers();
        if (this$peers == null ? other$peers != null : !((Object)this$peers).equals(other$peers)) {
            return false;
        }
        RawEngine this$rawEngine = this.getRawEngine();
        RawEngine other$rawEngine = other.getRawEngine();
        if (this$rawEngine == null ? other$rawEngine != null : !this$rawEngine.equals(other$rawEngine)) {
            return false;
        }
        Object this$ext$ = this.getExt$();
        Object other$ext$ = other.getExt$();
        return !(this$ext$ == null ? other$ext$ != null : !this$ext$.equals(other$ext$));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RegionDefinition;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $tenantId = this.getTenantId();
        result = result * 59 + (int)($tenantId >>> 32 ^ $tenantId);
        long $partId = this.getPartId();
        result = result * 59 + (int)($partId >>> 32 ^ $partId);
        long $tableId = this.getTableId();
        result = result * 59 + (int)($tableId >>> 32 ^ $tableId);
        long $schemaId = this.getSchemaId();
        result = result * 59 + (int)($schemaId >>> 32 ^ $schemaId);
        long $id = this.getId();
        result = result * 59 + (int)($id >>> 32 ^ $id);
        long $indexId = this.getIndexId();
        result = result * 59 + (int)($indexId >>> 32 ^ $indexId);
        long $revision = this.getRevision();
        result = result * 59 + (int)($revision >>> 32 ^ $revision);
        StorageEngine $storeEngine = this.getStoreEngine();
        result = result * 59 + ($storeEngine == null ? 43 : $storeEngine.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        RegionEpoch $epoch = this.getEpoch();
        result = result * 59 + ($epoch == null ? 43 : ((Object)$epoch).hashCode());
        IndexParameter $indexParameter = this.getIndexParameter();
        result = result * 59 + ($indexParameter == null ? 43 : ((Object)$indexParameter).hashCode());
        Range $range = this.getRange();
        result = result * 59 + ($range == null ? 43 : ((Object)$range).hashCode());
        List<Peer> $peers = this.getPeers();
        result = result * 59 + ($peers == null ? 43 : ((Object)$peers).hashCode());
        RawEngine $rawEngine = this.getRawEngine();
        result = result * 59 + ($rawEngine == null ? 43 : $rawEngine.hashCode());
        Object $ext$ = this.getExt$();
        result = result * 59 + ($ext$ == null ? 43 : $ext$.hashCode());
        return result;
    }

    public String toString() {
        return "RegionDefinition(storeEngine=" + String.valueOf(this.getStoreEngine()) + ", tenantId=" + this.getTenantId() + ", partId=" + this.getPartId() + ", name=" + this.getName() + ", epoch=" + String.valueOf(this.getEpoch()) + ", tableId=" + this.getTableId() + ", schemaId=" + this.getSchemaId() + ", id=" + this.getId() + ", indexParameter=" + String.valueOf(this.getIndexParameter()) + ", indexId=" + this.getIndexId() + ", revision=" + this.getRevision() + ", range=" + String.valueOf(this.getRange()) + ", peers=" + String.valueOf(this.getPeers()) + ", rawEngine=" + String.valueOf(this.getRawEngine()) + ", ext$=" + String.valueOf(this.getExt$()) + ")";
    }

    public RegionDefinition() {
    }

    public static abstract class RegionDefinitionBuilder<C extends RegionDefinition, B extends RegionDefinitionBuilder<C, B>> {
        private StorageEngine storeEngine;
        private long tenantId;
        private long partId;
        private String name;
        private RegionEpoch epoch;
        private long tableId;
        private long schemaId;
        private long id;
        private IndexParameter indexParameter;
        private long indexId;
        private long revision;
        private Range range;
        private List<Peer> peers;
        private RawEngine rawEngine;
        private Object ext$;

        protected abstract B self();

        public abstract C build();

        public B storeEngine(StorageEngine storeEngine) {
            this.storeEngine = storeEngine;
            return this.self();
        }

        public B tenantId(long tenantId) {
            this.tenantId = tenantId;
            return this.self();
        }

        public B partId(long partId) {
            this.partId = partId;
            return this.self();
        }

        public B name(String name) {
            this.name = name;
            return this.self();
        }

        public B epoch(RegionEpoch epoch) {
            this.epoch = epoch;
            return this.self();
        }

        public B tableId(long tableId) {
            this.tableId = tableId;
            return this.self();
        }

        public B schemaId(long schemaId) {
            this.schemaId = schemaId;
            return this.self();
        }

        public B id(long id) {
            this.id = id;
            return this.self();
        }

        public B indexParameter(IndexParameter indexParameter) {
            this.indexParameter = indexParameter;
            return this.self();
        }

        public B indexId(long indexId) {
            this.indexId = indexId;
            return this.self();
        }

        public B revision(long revision) {
            this.revision = revision;
            return this.self();
        }

        public B range(Range range) {
            this.range = range;
            return this.self();
        }

        public B peers(List<Peer> peers) {
            this.peers = peers;
            return this.self();
        }

        public B rawEngine(RawEngine rawEngine) {
            this.rawEngine = rawEngine;
            return this.self();
        }

        public B ext$(Object ext$) {
            this.ext$ = ext$;
            return this.self();
        }

        public String toString() {
            return "RegionDefinition.RegionDefinitionBuilder(storeEngine=" + String.valueOf(this.storeEngine) + ", tenantId=" + this.tenantId + ", partId=" + this.partId + ", name=" + this.name + ", epoch=" + String.valueOf(this.epoch) + ", tableId=" + this.tableId + ", schemaId=" + this.schemaId + ", id=" + this.id + ", indexParameter=" + String.valueOf(this.indexParameter) + ", indexId=" + this.indexId + ", revision=" + this.revision + ", range=" + String.valueOf(this.range) + ", peers=" + String.valueOf(this.peers) + ", rawEngine=" + String.valueOf(this.rawEngine) + ", ext$=" + String.valueOf(this.ext$) + ")";
        }
    }

    private static final class RegionDefinitionBuilderImpl
    extends RegionDefinitionBuilder<RegionDefinition, RegionDefinitionBuilderImpl> {
        private RegionDefinitionBuilderImpl() {
        }

        @Override
        protected RegionDefinitionBuilderImpl self() {
            return this;
        }

        @Override
        public RegionDefinition build() {
            return new RegionDefinition(this);
        }
    }

    public static final class Fields {
        public static final String storeEngine = "storeEngine";
        public static final String tenantId = "tenantId";
        public static final String partId = "partId";
        public static final String name = "name";
        public static final String epoch = "epoch";
        public static final String tableId = "tableId";
        public static final String schemaId = "schemaId";
        public static final String id = "id";
        public static final String indexParameter = "indexParameter";
        public static final String indexId = "indexId";
        public static final String revision = "revision";
        public static final String range = "range";
        public static final String peers = "peers";
        public static final String rawEngine = "rawEngine";
        public static final String ext$ = "ext$";
    }
}

