/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.service.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.common.utils.Optional;
import io.dingodb.sdk.service.entity.common.RequestInfo;
import io.dingodb.sdk.service.entity.common.ResponseInfo;
import io.dingodb.sdk.service.entity.error.Errno;
import io.dingodb.sdk.service.entity.error.Error;
import io.dingodb.sdk.service.entity.store.Context;
import io.dingodb.sdk.service.entity.store.IsolationLevel;
import java.util.List;

public interface Message {
    public boolean read(CodedInputStream var1);

    public void write(CodedOutputStream var1);

    public int sizeOf();

    @JsonIgnore
    default public boolean isDirect() {
        return false;
    }

    @JsonIgnore
    default public Object getExt$() {
        throw new UnsupportedOperationException();
    }

    default public void setExt$(Object ext$) {
        throw new UnsupportedOperationException();
    }

    public static interface StoreRequest
    extends Request {
        default public void setIsolationLevel(IsolationLevel isolationLevel) {
            if (this.getContext() == null) {
                this.setContext((Context)((Context.ContextBuilder)Context.builder().isolationLevel(isolationLevel)).build());
            }
            this.getContext().setIsolationLevel(isolationLevel);
        }

        default public void setResolveLocks(List<Long> resolvedLocks) {
            if (this.getContext() == null) {
                this.setContext((Context)((Context.ContextBuilder)Context.builder().resolvedLocks(resolvedLocks)).build());
            }
            this.getContext().setResolvedLocks(resolvedLocks);
        }

        default public IsolationLevel getIsolationLevel() {
            return Optional.mapOrNull(this.getContext(), Context::getIsolationLevel);
        }

        default public Context getContext() {
            return null;
        }

        default public void setContext(Context context) {
        }
    }

    public static interface Response
    extends Message {
        default public boolean isOk$() {
            return this.getError() == null || this.getError().getErrcode() == null || this.getError().getErrcode() == Errno.OK;
        }

        default public ResponseInfo getResponseInfo() {
            throw new UnsupportedOperationException();
        }

        default public void setResponseInfo(ResponseInfo responseInfo) {
            throw new UnsupportedOperationException();
        }

        default public Error getError() {
            throw new UnsupportedOperationException();
        }
    }

    public static interface Request
    extends Message {
        default public RequestInfo getRequestInfo() {
            throw new UnsupportedOperationException();
        }

        default public void setRequestInfo(RequestInfo requestInfo) {
            throw new UnsupportedOperationException();
        }
    }
}

