/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.service.cluster;

import io.dingodb.common.Common;
import io.dingodb.coordinator.Coordinator;
import io.dingodb.coordinator.CoordinatorServiceGrpc;
import io.dingodb.sdk.common.Location;
import io.dingodb.sdk.common.cluster.Coordinator;
import io.dingodb.sdk.common.cluster.Executor;
import io.dingodb.sdk.common.cluster.InternalCoordinator;
import io.dingodb.sdk.common.cluster.Region;
import io.dingodb.sdk.common.cluster.Store;
import io.dingodb.sdk.common.utils.EntityConversion;
import io.dingodb.sdk.service.connector.ServiceConnector;
import java.util.List;
import java.util.stream.Collectors;

public class ClusterServiceClient {
    private ServiceConnector<CoordinatorServiceGrpc.CoordinatorServiceBlockingStub> connector;

    public ClusterServiceClient(ServiceConnector<CoordinatorServiceGrpc.CoordinatorServiceBlockingStub> connector) {
        this.connector = connector;
    }

    public void executorHeartbeat(long epoch, Executor executor) {
        Coordinator.ExecutorHeartbeatRequest req = Coordinator.ExecutorHeartbeatRequest.newBuilder().setSelfExecutormapEpoch(epoch).setExecutor(EntityConversion.mapping(executor)).build();
        Coordinator.ExecutorHeartbeatResponse response = this.connector.exec(stub -> stub.executorHeartbeat(req));
    }

    public List<Executor> getExecutorMap(long epoch) {
        Coordinator.GetExecutorMapRequest req = Coordinator.GetExecutorMapRequest.newBuilder().setEpoch(epoch).build();
        Coordinator.GetExecutorMapResponse response = this.connector.exec(stub -> stub.getExecutorMap(req));
        return response.getExecutormap().getExecutorsList().stream().filter(executor -> executor.getState() == Common.ExecutorState.EXECUTOR_NORMAL).map(EntityConversion::mapping).collect(Collectors.toList());
    }

    public List<Coordinator> getCoordinatorMap(long clusterId) {
        Coordinator.GetCoordinatorMapRequest req = Coordinator.GetCoordinatorMapRequest.newBuilder().setClusterId(clusterId).build();
        Coordinator.GetCoordinatorMapResponse response = this.connector.exec(stub -> stub.getCoordinatorMap(req));
        Location leaderLocation = EntityConversion.mapping(response.getLeaderLocation());
        return response.getCoordinatorMap().getCoordinatorsList().stream().map(coordinator -> {
            Location location = EntityConversion.mapping(coordinator.getLocation());
            boolean isLeader = location.equals(leaderLocation);
            int state = coordinator.getState().getNumber();
            return new InternalCoordinator(location, isLeader, state);
        }).collect(Collectors.toList());
    }

    public List<Store> getStoreMap(long epoch) {
        Coordinator.GetStoreMapRequest req = Coordinator.GetStoreMapRequest.newBuilder().setEpoch(epoch).build();
        Coordinator.GetStoreMapResponse response = this.connector.exec(stub -> stub.getStoreMap(req));
        return response.getStoremap().getStoresList().stream().map(EntityConversion::mapping).collect(Collectors.toList());
    }

    public List<Region> getRegionMap(long epoch) {
        Coordinator.GetRegionMapRequest req = Coordinator.GetRegionMapRequest.newBuilder().setEpoch(0L).build();
        Coordinator.GetRegionMapResponse response = this.connector.exec(stub -> stub.getRegionMap(req));
        return response.getRegionmap().getRegionsList().stream().map(EntityConversion::mapping).collect(Collectors.toList());
    }

    public Region queryRegion(long regionId) {
        Coordinator.QueryRegionRequest req = Coordinator.QueryRegionRequest.newBuilder().setRegionId(regionId).build();
        Coordinator.QueryRegionResponse response = this.connector.exec(stub -> stub.queryRegion(req));
        return EntityConversion.mapping(response.getRegion());
    }
}

