/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.service.caller;

import io.dingodb.sdk.common.DingoClientException;
import io.dingodb.sdk.common.utils.ErrorCodeUtils;
import io.dingodb.sdk.service.Caller;
import io.dingodb.sdk.service.ChannelProvider;
import io.dingodb.sdk.service.JsonMessageUtils;
import io.dingodb.sdk.service.Service;
import io.dingodb.sdk.service.ServiceCallCycles;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.error.Errno;
import io.dingodb.sdk.service.entity.error.Error;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.MethodDescriptor;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceCaller<S extends Service<S>>
implements Caller<S> {
    private static final Logger log = LoggerFactory.getLogger(ServiceCaller.class);
    private int retry;
    private CallOptions options;
    private final ChannelProvider channelProvider;
    private final S service;

    public ServiceCaller(ChannelProvider channelProvider, int retry, CallOptions options, Function<Caller<S>, S> serviceFactory) {
        this.channelProvider = channelProvider;
        this.retry = retry;
        this.options = options;
        this.service = (Service)serviceFactory.apply(this);
    }

    public int retry() {
        return this.retry;
    }

    public ServiceCaller<S> retry(int retry) {
        this.retry = retry;
        return this;
    }

    public CallOptions options() {
        return this.options;
    }

    public ServiceCaller<S> options(CallOptions options) {
        this.options = options;
        return this;
    }

    @Override
    public <REQ extends Message.Request, RES extends Message.Response> RES call(MethodDescriptor<REQ, RES> method, long requestId, REQ request, ServiceCallCycles<REQ, RES> handler) {
        handler.before(request, this.options, requestId);
        Channel channel = this.channelProvider.channel();
        int retry = this.retry;
        boolean connected = false;
        HashMap<String, Integer> errMsgs = new HashMap<String, Integer>();
        String methodName = method.getFullMethodName();
        Object lastRequest = null;
        boolean specialRetry = true;
        block8: while (retry-- > 0) {
            try {
                if (channel == null) {
                    channel = this.updateChannel(channel, requestId);
                    continue;
                }
                this.channelProvider.before(request);
                RES response = handler.call(method, request, this.options, channel, requestId, handler);
                if (response == null) {
                    channel = this.updateChannel(channel, requestId);
                    continue;
                }
                connected = true;
                this.channelProvider.after((Message.Response)response);
                if (!response.isOk$()) {
                    Error error = response.getError();
                    int errCode = error.getErrcode().number();
                    errMsgs.compute(channel.authority() + ">>" + error.getErrmsg(), (k, v) -> v == null ? 1 : v + 1);
                    switch (handler.onErrStrategy(ErrorCodeUtils.errorToStrategy(errCode), this.retry, retry, request, response, this.options, channel.authority(), requestId)) {
                        case RETRY: {
                            handler.onRetry(request, response, this.options, channel.authority(), requestId);
                            if (errCode == Errno.ERAFT_NOTLEADER.number) {
                                channel = this.updateChannel(channel, requestId);
                                continue block8;
                            }
                            if (errCode == Errno.EREQUEST_FULL.number && specialRetry) {
                                retry = 3600;
                                specialRetry = false;
                            }
                            this.waitRetry();
                            continue block8;
                        }
                        case FAILED: {
                            handler.onFailed(request, response, this.options, channel.authority(), requestId);
                            throw new DingoClientException.RequestErrorException(errCode, error.getErrmsg());
                        }
                        case REFRESH: {
                            handler.onRefresh(request, response, this.options, channel.authority(), requestId);
                            channel = this.updateChannel(channel, requestId);
                            throw new DingoClientException.InvalidRouteTableException(error.getErrmsg());
                        }
                        case IGNORE: {
                            handler.onIgnore(request, response, this.options, channel.authority(), requestId);
                            return null;
                        }
                    }
                    throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)ErrorCodeUtils.errorToStrategy(errCode)));
                }
                handler.after(request, response, this.options, channel.authority(), requestId);
                return response;
            }
            catch (Exception e) {
                if (e instanceof DingoClientException.RequestErrorException || e instanceof DingoClientException.InvalidRouteTableException) {
                    throw e;
                }
                handler.onException(lastRequest, e, this.options, channel == null ? null : channel.authority(), requestId);
                errMsgs.compute(e.getMessage(), (k, v) -> v == null ? 1 : v + 1);
                channel = this.updateChannel(channel, requestId);
            }
        }
        throw this.generateException(methodName, requestId, lastRequest, connected, (Map<String, Integer>)errMsgs, handler);
    }

    private void waitRetry() {
        LockSupport.parkNanos(TimeUnit.SECONDS.toNanos(1L));
    }

    private Channel updateChannel(Channel channel, long trace) {
        this.channelProvider.refresh(channel, trace);
        this.waitRetry();
        return this.channelProvider.channel();
    }

    private <REQ extends Message.Request> RuntimeException generateException(String name, long traceId, REQ request, boolean connected, Map<String, Integer> errMsgs, ServiceCallCycles handler) {
        if (connected) {
            StringBuilder errMsgBuilder = new StringBuilder();
            errMsgBuilder.append("task: ").append(name).append(", trace: ").append(traceId).append(" ==>> ");
            errMsgs.forEach((k, v) -> errMsgBuilder.append('[').append(v).append("] times [").append((String)k).append(']').append(", "));
            DingoClientException.ExhaustedRetryException exception = new DingoClientException.ExhaustedRetryException("Exec attempts exhausted, failed to exec " + name + ", " + String.valueOf(errMsgBuilder));
            handler.onThrow(request, exception, this.options, traceId);
            throw exception;
        }
        handler.onNonConnection(request, this.options, traceId);
        log.error(JsonMessageUtils.toJson(name, traceId, request, null, this.options));
        throw new DingoClientException.ExhaustedRetryException("Exec [" + traceId + "] [" + name + "] error, transform leader attempts exhausted.");
    }

    public S getService() {
        return this.service;
    }
}

