/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.service.caller;

import io.dingodb.sdk.common.DingoClientException;
import io.grpc.ClientCall;
import io.grpc.Metadata;
import io.grpc.Status;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class RpcFuture<T>
implements CompletionStage<T> {
    protected final CompletableFuture<T> future = new CompletableFuture();
    protected final Listener listener = new Listener();
    private Metadata headers;
    private T message;
    private Status status;
    private Metadata trailers;

    public Metadata headers() {
        return this.headers;
    }

    public Status status() {
        return this.status;
    }

    public Metadata trailers() {
        return this.trailers;
    }

    public void onHeaders(Metadata headers) {
        this.headers = headers;
    }

    public void onMessage(T message) {
        this.message = message;
    }

    public void onClose(Status status, Metadata trailers) {
        this.status = status;
        this.trailers = trailers;
        if (!status.isOk()) {
            if (status.getCause() != null) {
                this.completeExceptionally(status.getCause());
            } else {
                this.completeExceptionally(new DingoClientException(status.getCode().value(), status.getDescription()));
            }
        }
        this.complete(this.message);
    }

    public void onReady() {
    }

    public boolean isDone() {
        return this.future.isDone();
    }

    public T get() throws InterruptedException, ExecutionException {
        return this.future.get();
    }

    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.future.get(timeout, unit);
    }

    public T join() {
        return this.future.join();
    }

    public T getNow(T valueIfAbsent) {
        return this.future.getNow(valueIfAbsent);
    }

    public boolean complete(T value) {
        return this.future.complete(value);
    }

    public boolean completeExceptionally(Throwable ex) {
        return this.future.completeExceptionally(ex);
    }

    @Override
    public <U> CompletableFuture<U> thenApply(Function<? super T, ? extends U> fn) {
        return this.future.thenApply(fn);
    }

    @Override
    public <U> CompletableFuture<U> thenApplyAsync(Function<? super T, ? extends U> fn) {
        return this.future.thenApplyAsync(fn);
    }

    @Override
    public <U> CompletableFuture<U> thenApplyAsync(Function<? super T, ? extends U> fn, Executor executor) {
        return this.future.thenApplyAsync(fn, executor);
    }

    public CompletableFuture<Void> thenAccept(Consumer<? super T> action) {
        return this.future.thenAccept((Consumer)action);
    }

    public CompletableFuture<Void> thenAcceptAsync(Consumer<? super T> action) {
        return this.future.thenAcceptAsync((Consumer)action);
    }

    public CompletableFuture<Void> thenAcceptAsync(Consumer<? super T> action, Executor executor) {
        return this.future.thenAcceptAsync((Consumer)action, executor);
    }

    public CompletableFuture<Void> thenRun(Runnable action) {
        return this.future.thenRun(action);
    }

    public CompletableFuture<Void> thenRunAsync(Runnable action) {
        return this.future.thenRunAsync(action);
    }

    public CompletableFuture<Void> thenRunAsync(Runnable action, Executor executor) {
        return this.future.thenRunAsync(action, executor);
    }

    @Override
    public <U, V> CompletableFuture<V> thenCombine(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn) {
        return this.future.thenCombine(other, fn);
    }

    @Override
    public <U, V> CompletableFuture<V> thenCombineAsync(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn) {
        return this.future.thenCombineAsync(other, fn);
    }

    @Override
    public <U, V> CompletableFuture<V> thenCombineAsync(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn, Executor executor) {
        return this.future.thenCombineAsync(other, fn, executor);
    }

    public <U> CompletableFuture<Void> thenAcceptBoth(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action) {
        return this.future.thenAcceptBoth(other, (BiConsumer)action);
    }

    public <U> CompletableFuture<Void> thenAcceptBothAsync(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action) {
        return this.future.thenAcceptBothAsync(other, (BiConsumer)action);
    }

    public <U> CompletableFuture<Void> thenAcceptBothAsync(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action, Executor executor) {
        return this.future.thenAcceptBothAsync(other, (BiConsumer)action, executor);
    }

    public CompletableFuture<Void> runAfterBoth(CompletionStage<?> other, Runnable action) {
        return this.future.runAfterBoth((CompletionStage)other, action);
    }

    public CompletableFuture<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action) {
        return this.future.runAfterBothAsync((CompletionStage)other, action);
    }

    public CompletableFuture<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action, Executor executor) {
        return this.future.runAfterBothAsync((CompletionStage)other, action, executor);
    }

    @Override
    public <U> CompletableFuture<U> applyToEither(CompletionStage<? extends T> other, Function<? super T, U> fn) {
        return this.future.applyToEither((CompletionStage)other, fn);
    }

    @Override
    public <U> CompletableFuture<U> applyToEitherAsync(CompletionStage<? extends T> other, Function<? super T, U> fn) {
        return this.future.applyToEitherAsync((CompletionStage)other, fn);
    }

    @Override
    public <U> CompletableFuture<U> applyToEitherAsync(CompletionStage<? extends T> other, Function<? super T, U> fn, Executor executor) {
        return this.future.applyToEitherAsync((CompletionStage)other, fn, executor);
    }

    public CompletableFuture<Void> acceptEither(CompletionStage<? extends T> other, Consumer<? super T> action) {
        return this.future.acceptEither((CompletionStage)other, (Consumer)action);
    }

    public CompletableFuture<Void> acceptEitherAsync(CompletionStage<? extends T> other, Consumer<? super T> action) {
        return this.future.acceptEitherAsync((CompletionStage)other, (Consumer)action);
    }

    public CompletableFuture<Void> acceptEitherAsync(CompletionStage<? extends T> other, Consumer<? super T> action, Executor executor) {
        return this.future.acceptEitherAsync((CompletionStage)other, (Consumer)action, executor);
    }

    public CompletableFuture<Void> runAfterEither(CompletionStage<?> other, Runnable action) {
        return this.future.runAfterEither((CompletionStage)other, action);
    }

    public CompletableFuture<Void> runAfterEitherAsync(CompletionStage<?> other, Runnable action) {
        return this.future.runAfterEitherAsync((CompletionStage)other, action);
    }

    public CompletableFuture<Void> runAfterEitherAsync(CompletionStage<?> other, Runnable action, Executor executor) {
        return this.future.runAfterEitherAsync((CompletionStage)other, action, executor);
    }

    @Override
    public <U> CompletableFuture<U> thenCompose(Function<? super T, ? extends CompletionStage<U>> fn) {
        return this.future.thenCompose(fn);
    }

    @Override
    public <U> CompletableFuture<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> fn) {
        return this.future.thenComposeAsync(fn);
    }

    @Override
    public <U> CompletableFuture<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> fn, Executor executor) {
        return this.future.thenComposeAsync(fn, executor);
    }

    @Override
    public CompletableFuture<T> whenComplete(BiConsumer<? super T, ? super Throwable> action) {
        return this.future.whenComplete(action);
    }

    @Override
    public CompletableFuture<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> action) {
        return this.future.whenCompleteAsync(action);
    }

    @Override
    public CompletableFuture<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> action, Executor executor) {
        return this.future.whenCompleteAsync(action, executor);
    }

    @Override
    public <U> CompletableFuture<U> handle(BiFunction<? super T, Throwable, ? extends U> fn) {
        return this.future.handle(fn);
    }

    @Override
    public <U> CompletableFuture<U> handleAsync(BiFunction<? super T, Throwable, ? extends U> fn) {
        return this.future.handleAsync(fn);
    }

    @Override
    public <U> CompletableFuture<U> handleAsync(BiFunction<? super T, Throwable, ? extends U> fn, Executor executor) {
        return this.future.handleAsync(fn, executor);
    }

    @Override
    public CompletableFuture<T> toCompletableFuture() {
        return this.future.toCompletableFuture();
    }

    @Override
    public CompletableFuture<T> exceptionally(Function<Throwable, ? extends T> fn) {
        return this.future.exceptionally(fn);
    }

    @Override
    public CompletableFuture<T> exceptionallyAsync(Function<Throwable, ? extends T> fn) {
        return this.future.exceptionallyAsync(fn);
    }

    @Override
    public CompletableFuture<T> exceptionallyAsync(Function<Throwable, ? extends T> fn, Executor executor) {
        return this.future.exceptionallyAsync(fn, executor);
    }

    @Override
    public CompletableFuture<T> exceptionallyCompose(Function<Throwable, ? extends CompletionStage<T>> fn) {
        return this.future.exceptionallyCompose(fn);
    }

    @Override
    public CompletableFuture<T> exceptionallyComposeAsync(Function<Throwable, ? extends CompletionStage<T>> fn) {
        return this.future.exceptionallyComposeAsync(fn);
    }

    @Override
    public CompletableFuture<T> exceptionallyComposeAsync(Function<Throwable, ? extends CompletionStage<T>> fn, Executor executor) {
        return this.future.exceptionallyComposeAsync(fn, executor);
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.future.cancel(mayInterruptIfRunning);
    }

    public boolean isCancelled() {
        return this.future.isCancelled();
    }

    public boolean isCompletedExceptionally() {
        return this.future.isCompletedExceptionally();
    }

    public void obtrudeValue(T value) {
        this.future.obtrudeValue(value);
    }

    public void obtrudeException(Throwable ex) {
        this.future.obtrudeException(ex);
    }

    public int getNumberOfDependents() {
        return this.future.getNumberOfDependents();
    }

    public <U> CompletableFuture<U> newIncompleteFuture() {
        return this.future.newIncompleteFuture();
    }

    public Executor defaultExecutor() {
        return this.future.defaultExecutor();
    }

    public CompletableFuture<T> copy() {
        return this.future.copy();
    }

    public CompletionStage<T> minimalCompletionStage() {
        return this.future.minimalCompletionStage();
    }

    public CompletableFuture<T> completeAsync(Supplier<? extends T> supplier, Executor executor) {
        return this.future.completeAsync(supplier, executor);
    }

    public CompletableFuture<T> completeAsync(Supplier<? extends T> supplier) {
        return this.future.completeAsync(supplier);
    }

    public CompletableFuture<T> orTimeout(long timeout, TimeUnit unit) {
        return this.future.orTimeout(timeout, unit);
    }

    public CompletableFuture<T> completeOnTimeout(T value, long timeout, TimeUnit unit) {
        return this.future.completeOnTimeout(value, timeout, unit);
    }

    public class Listener
    extends ClientCall.Listener<T> {
        public void onHeaders(Metadata headers) {
            RpcFuture.this.onHeaders(headers);
        }

        public void onMessage(T message) {
            RpcFuture.this.onMessage(message);
        }

        public void onClose(Status status, Metadata trailers) {
            RpcFuture.this.onClose(status, trailers);
        }

        public void onReady() {
            RpcFuture.this.onReady();
        }
    }
}

