/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.service.caller;

import io.dingodb.sdk.service.Caller;
import io.dingodb.sdk.service.Service;
import io.dingodb.sdk.service.ServiceCallCycles;
import io.dingodb.sdk.service.caller.RpcFuture;
import io.dingodb.sdk.service.entity.Message;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.ClientCalls;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcCaller<S extends Service<S>>
implements Caller<S>,
InvocationHandler {
    private static final Logger log = LoggerFactory.getLogger(RpcCaller.class);
    private final Channel channel;
    private final CallOptions options;
    private final S service;

    public RpcCaller(Channel channel, CallOptions options, Class<S> genericClass) {
        this.channel = channel;
        this.options = options;
        this.service = this.proxy(genericClass);
    }

    private S proxy(Class<S> genericType) {
        for (Class<?> child : genericType.getClasses()) {
            if (child.getSuperclass().equals(genericType)) continue;
            try {
                return (S)((Service)child.getConstructor(Caller.class).newInstance(this));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        throw new RuntimeException("Not found " + genericType.getName() + " impl.");
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        return method.invoke(this.service, args);
    }

    @Override
    public <REQ extends Message.Request, RES extends Message.Response> RES call(MethodDescriptor<REQ, RES> method, long requestId, REQ request, ServiceCallCycles<REQ, RES> handler) {
        return RpcCaller.call(method, request, this.options, this.channel, System.identityHashCode(request), handler);
    }

    protected static <REQ extends Message, RES extends Message.Response> RpcFuture<RES> asyncCall(MethodDescriptor<REQ, RES> method, REQ request, CallOptions options, Channel channel) {
        RpcFuture future = new RpcFuture();
        ClientCall call = channel.newCall(method, options);
        call.start((ClientCall.Listener)future.listener, new Metadata());
        call.request(2);
        call.sendMessage(request);
        call.halfClose();
        return future;
    }

    public static <REQ extends Message.Request, RES extends Message.Response> RES call(MethodDescriptor<REQ, RES> method, REQ request, CallOptions options, Channel channel, long trace, ServiceCallCycles<REQ, RES> handler) {
        Message.Response response;
        String methodName = method.getFullMethodName();
        if (channel == null) {
            handler.rBefore(request, options, null, trace);
            return null;
        }
        handler.rBefore(request, options, channel.authority(), trace);
        try {
            response = (Message.Response)ClientCalls.blockingUnaryCall((Channel)channel, method, (CallOptions)options, request);
        }
        catch (StatusRuntimeException e) {
            handler.rError(request, options, channel.authority(), trace, e.getMessage());
            return null;
        }
        handler.rAfter(request, response, options, channel.authority(), trace);
        return (RES)response;
    }

    public RpcCaller(Channel channel, CallOptions options, S service) {
        this.channel = channel;
        this.options = options;
        this.service = service;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public CallOptions getOptions() {
        return this.options;
    }

    public S getService() {
        return this.service;
    }
}

