/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.service;

import io.dingodb.sdk.common.DingoClientException;
import io.dingodb.sdk.service.LockService;
import io.dingodb.sdk.service.Services;
import io.dingodb.sdk.service.VersionService;
import io.dingodb.sdk.service.entity.common.Location;
import io.dingodb.sdk.service.entity.version.Event;
import io.dingodb.sdk.service.entity.version.EventType;
import io.dingodb.sdk.service.entity.version.Kv;
import io.dingodb.sdk.service.entity.version.WatchRequest;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WatchService {
    private static final Logger log = LoggerFactory.getLogger(WatchService.class);
    protected Set<Location> locations;
    protected VersionService kvService;

    public WatchService(String servers) {
        this.locations = Services.parse(servers);
        this.kvService = Services.versionService(this.locations);
    }

    public void watchAllOpEvent(Kv kv, Function<String, String> function) {
        CompletableFuture.supplyAsync(() -> this.kvService.watch(this.watchAllOpRequest(kv.getKv().getKey(), kv.getModRevision()))).whenCompleteAsync((r, e) -> {
            if (e != null) {
                log.error("Watch locked error, or watch retry time great than lease ttl.", e);
                if (!(e instanceof DingoClientException)) {
                    this.resetVerService();
                    this.watchAllOpEvent(kv, function);
                    return;
                }
                return;
            }
            String typeStr = "normal";
            if (r.getEvents() == null) {
                typeStr = "transferLeader";
            } else if (r.getEvents().stream().map(Event::getType).anyMatch(type -> type == EventType.DELETE || type == EventType.NOT_EXISTS)) {
                typeStr = "keyNone";
            }
            function.apply(typeStr);
            this.watchAllOpEvent(kv, function);
        }, (Executor)LockService.LOCK_FUTURE_POOL);
    }

    private WatchRequest watchAllOpRequest(byte[] resourceKey, long revision) {
        return ((WatchRequest.WatchRequestBuilder)WatchRequest.builder().requestUnion((WatchRequest.RequestUnionNest)((Object)((WatchRequest.RequestUnionNest.OneTimeRequest.OneTimeRequestBuilder)((WatchRequest.RequestUnionNest.OneTimeRequest.OneTimeRequestBuilder)((WatchRequest.RequestUnionNest.OneTimeRequest.OneTimeRequestBuilder)WatchRequest.RequestUnionNest.OneTimeRequest.builder().key(resourceKey)).needPrevKv(true)).startRevision(revision)).build()))).build();
    }

    public void resetVerService() {
        Services.invalidateVersionService(this.locations);
        this.kvService = Services.versionService(this.locations);
    }
}

