/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.service;

import io.dingodb.sdk.service.ChannelManager;
import io.dingodb.sdk.service.ChannelProvider;
import io.dingodb.sdk.service.MetaService;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.common.Location;
import io.dingodb.sdk.service.entity.common.RegionEpoch;
import io.dingodb.sdk.service.entity.meta.DingoCommonId;
import io.dingodb.sdk.service.entity.meta.EntityType;
import io.dingodb.sdk.service.entity.meta.GetIndexRangeRequest;
import io.dingodb.sdk.service.entity.meta.GetTableRangeRequest;
import io.dingodb.sdk.service.entity.meta.RangeDistribution;
import io.dingodb.sdk.service.entity.store.Context;
import io.grpc.Channel;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableRegionsFailOver {
    private static final Logger log = LoggerFactory.getLogger(TableRegionsFailOver.class);
    private final DingoCommonId tableId;
    private final MetaService metaService;
    private final AtomicBoolean refresh = new AtomicBoolean();
    private Map<DingoCommonId, RangeDistribution> regionChannels = Collections.emptyMap();
    private final Function<Long, List<RangeDistribution>> rangesGetter;

    public TableRegionsFailOver(DingoCommonId tableId, MetaService metaService) {
        this.tableId = tableId;
        this.metaService = metaService;
        this.rangesGetter = tableId.getEntityType() == EntityType.ENTITY_TYPE_TABLE ? this::tableGetter : this::indexGetter;
    }

    public ChannelProvider createRegionProvider(DingoCommonId regionId) {
        return new RegionChannelProvider(regionId);
    }

    private List<RangeDistribution> tableGetter(long trace) {
        return this.metaService.getTableRange(trace, (GetTableRangeRequest)((GetTableRangeRequest.GetTableRangeRequestBuilder)GetTableRangeRequest.builder().tableId(this.tableId)).build()).getTableRange().getRangeDistribution();
    }

    private List<RangeDistribution> indexGetter(long trace) {
        return this.metaService.getIndexRange(trace, (GetIndexRangeRequest)((GetIndexRangeRequest.GetIndexRangeRequestBuilder)GetIndexRangeRequest.builder().indexId(this.tableId)).build()).getIndexRange().getRangeDistribution();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(DingoCommonId regionId, Location location, long trace) {
        if (!this.refresh.compareAndSet(false, true)) {
            return;
        }
        try {
            if (!this.regionChannels.containsKey(regionId) || this.regionChannels.get(regionId).getLeader() == null || this.regionChannels.get(regionId).getLeader().equals(location)) {
                this.regionChannels = this.rangesGetter.apply(trace).stream().collect(Collectors.toMap(RangeDistribution::getId, $ -> $));
            }
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.warn("Get table ranges failed, table id: [{}], will retry...", (Object)this.tableId, (Object)e);
            }
        }
        finally {
            this.refresh.set(false);
        }
    }

    public class RegionChannelProvider
    implements ChannelProvider {
        private final DingoCommonId regionId;
        private Location location;
        private Channel channel;
        private RegionEpoch regionEpoch;

        private RegionChannelProvider(DingoCommonId regionId) {
            this.regionId = regionId;
            this.refresh(null, 0L);
        }

        @Override
        public Channel channel() {
            return this.channel;
        }

        @Override
        public synchronized void refresh(Channel channel, long trace) {
            RangeDistribution distribution;
            if (channel != null || this.location != null || this.regionEpoch != null) {
                TableRegionsFailOver.this.refresh(this.regionId, this.location, trace);
            }
            if ((distribution = TableRegionsFailOver.this.regionChannels.get(this.regionId)) == null || distribution.getLeader() == null) {
                TableRegionsFailOver.this.refresh(this.regionId, this.location, trace);
                distribution = TableRegionsFailOver.this.regionChannels.get(this.regionId);
                if (distribution == null) {
                    return;
                }
            }
            this.location = distribution.getLeader();
            this.channel = ChannelManager.getChannel(this.location);
            this.regionEpoch = distribution.getRegionEpoch();
        }

        @Override
        public void before(Message.Request message) {
            if (message instanceof Message.StoreRequest) {
                Context context = ((Message.StoreRequest)message).getContext();
                if (context == null) {
                    context = new Context();
                    ((Message.StoreRequest)message).setContext(context);
                }
                context.setRegionEpoch(this.regionEpoch);
                context.setRegionId(this.regionId.getEntityId());
            }
        }
    }
}

