/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.service;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import io.dingodb.sdk.common.DingoClientException;
import io.dingodb.sdk.common.codec.CodecUtils;
import io.dingodb.sdk.common.utils.ByteArrayUtils;
import io.dingodb.sdk.common.utils.Optional;
import io.dingodb.sdk.common.utils.Parameters;
import io.dingodb.sdk.service.ChannelProvider;
import io.dingodb.sdk.service.CoordinatorChannelProvider;
import io.dingodb.sdk.service.CoordinatorService;
import io.dingodb.sdk.service.DocumentService;
import io.dingodb.sdk.service.IndexService;
import io.dingodb.sdk.service.MetaService;
import io.dingodb.sdk.service.RegionChannelProvider;
import io.dingodb.sdk.service.StoreService;
import io.dingodb.sdk.service.TableRegionsFailOver;
import io.dingodb.sdk.service.UtilService;
import io.dingodb.sdk.service.VersionService;
import io.dingodb.sdk.service.caller.ServiceCaller;
import io.dingodb.sdk.service.entity.common.Location;
import io.dingodb.sdk.service.entity.common.Range;
import io.dingodb.sdk.service.entity.coordinator.GetCoordinatorMapResponse;
import io.dingodb.sdk.service.entity.coordinator.ScanRegionInfo;
import io.dingodb.sdk.service.entity.coordinator.ScanRegionsRequest;
import io.dingodb.sdk.service.entity.coordinator.ScanRegionsResponse;
import io.dingodb.sdk.service.entity.meta.DingoCommonId;
import io.grpc.CallOptions;
import java.util.Arrays;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class Services {
    public static final int DEFAULT_RETRY_TIMES = 30;
    private static final LoadingCache<Set<Location>, CoordinatorChannelProvider> coordinatorCache = CacheBuilder.newBuilder().expireAfterAccess(60L, TimeUnit.MINUTES).expireAfterWrite(60L, TimeUnit.MINUTES).maximumSize(8L).build((CacheLoader)new CacheLoader<Set<Location>, CoordinatorChannelProvider>(){

        public CoordinatorChannelProvider load(Set<Location> key) {
            return Services.coordinatorServiceChannelProvider(key);
        }
    });
    private static final LoadingCache<Set<Location>, CoordinatorChannelProvider> autoIncrementCache = CacheBuilder.newBuilder().expireAfterAccess(60L, TimeUnit.MINUTES).expireAfterWrite(60L, TimeUnit.MINUTES).maximumSize(8L).build((CacheLoader)new CacheLoader<Set<Location>, CoordinatorChannelProvider>(){

        public CoordinatorChannelProvider load(Set<Location> key) {
            return Services.autoIncrementChannelProvider(key);
        }
    });
    private static final LoadingCache<Set<Location>, CoordinatorChannelProvider> metaCache = CacheBuilder.newBuilder().expireAfterAccess(60L, TimeUnit.MINUTES).expireAfterWrite(60L, TimeUnit.MINUTES).maximumSize(8L).build((CacheLoader)new CacheLoader<Set<Location>, CoordinatorChannelProvider>(){

        public CoordinatorChannelProvider load(Set<Location> key) {
            return Services.metaServiceChannelProvider(key);
        }
    });
    private static final LoadingCache<Set<Location>, CoordinatorChannelProvider> tsoCache = CacheBuilder.newBuilder().expireAfterAccess(60L, TimeUnit.MINUTES).expireAfterWrite(60L, TimeUnit.MINUTES).maximumSize(8L).build((CacheLoader)new CacheLoader<Set<Location>, CoordinatorChannelProvider>(){

        public CoordinatorChannelProvider load(Set<Location> key) {
            return Services.tsoServiceChannelProvider(key);
        }
    });
    private static final LoadingCache<Set<Location>, CoordinatorChannelProvider> versionCache = CacheBuilder.newBuilder().expireAfterAccess(60L, TimeUnit.MINUTES).expireAfterWrite(60L, TimeUnit.MINUTES).maximumSize(8L).build((CacheLoader)new CacheLoader<Set<Location>, CoordinatorChannelProvider>(){

        public CoordinatorChannelProvider load(Set<Location> key) {
            return Services.kvServiceChannelProvider(key);
        }
    });
    private static final LoadingCache<Set<Location>, LoadingCache<Long, RegionChannelProvider>> regionCache = CacheBuilder.newBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).expireAfterWrite(30L, TimeUnit.MINUTES).maximumSize(64L).build((CacheLoader)new CacheLoader<Set<Location>, LoadingCache<Long, RegionChannelProvider>>(){

        public LoadingCache<Long, RegionChannelProvider> load(final Set<Location> locations) throws Exception {
            return CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).expireAfterWrite(10L, TimeUnit.MINUTES).maximumSize(4096L).build((CacheLoader)new CacheLoader<Long, RegionChannelProvider>(){

                public RegionChannelProvider load(Long regionId) throws Exception {
                    return new RegionChannelProvider(Services.coordinatorService(locations), regionId);
                }
            });
        }
    });
    private static final LoadingCache<Set<Location>, LoadingCache<DingoCommonId, TableRegionsFailOver>> tableFailOverCache = CacheBuilder.newBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).expireAfterWrite(30L, TimeUnit.MINUTES).maximumSize(64L).build((CacheLoader)new CacheLoader<Set<Location>, LoadingCache<DingoCommonId, TableRegionsFailOver>>(){

        public LoadingCache<DingoCommonId, TableRegionsFailOver> load(final Set<Location> locations) throws Exception {
            return CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).expireAfterWrite(10L, TimeUnit.MINUTES).maximumSize(256L).build((CacheLoader)new CacheLoader<DingoCommonId, TableRegionsFailOver>(){

                public TableRegionsFailOver load(DingoCommonId tableId) throws Exception {
                    return new TableRegionsFailOver(tableId, Services.metaService(locations));
                }
            });
        }
    });
    private static final NavigableMap<byte[], NavigableMap<byte[], ScanRegionInfo>> rangeRegions = new ConcurrentSkipListMap<byte[], NavigableMap<byte[], ScanRegionInfo>>(ByteArrayUtils::compare);

    public static CoordinatorChannelProvider coordinatorServiceChannelProvider(Set<Location> locations) {
        return new CoordinatorChannelProvider(locations, GetCoordinatorMapResponse::getLeaderLocation);
    }

    public static CoordinatorChannelProvider metaServiceChannelProvider(Set<Location> locations) {
        return new CoordinatorChannelProvider(locations, GetCoordinatorMapResponse::getLeaderLocation);
    }

    public static CoordinatorChannelProvider tsoServiceChannelProvider(Set<Location> locations) {
        return new CoordinatorChannelProvider(locations, GetCoordinatorMapResponse::getTsoLeaderLocation);
    }

    public static CoordinatorChannelProvider kvServiceChannelProvider(Set<Location> locations) {
        return new CoordinatorChannelProvider(locations, GetCoordinatorMapResponse::getKvLeaderLocation);
    }

    public static CoordinatorChannelProvider autoIncrementChannelProvider(Set<Location> locations) {
        return new CoordinatorChannelProvider(locations, GetCoordinatorMapResponse::getAutoIncrementLeaderLocation);
    }

    public static Set<Location> parse(String locations) {
        return Arrays.stream(locations.split(",")).map(ss -> ss.split(":")).map(ss -> ((Location.LocationBuilder)((Location.LocationBuilder)Location.builder().host(ss[0])).port(Integer.parseInt(ss[1]))).build()).collect(Collectors.toSet());
    }

    public static CoordinatorService coordinatorService(Set<Location> locations) {
        Parameters.notEmpty(locations, "locations");
        return new ServiceCaller<CoordinatorService>((ChannelProvider)coordinatorCache.get(locations), 30, CallOptions.DEFAULT, CoordinatorService.Impl::new).getService();
    }

    public static MetaService metaService(Set<Location> locations) {
        Parameters.notEmpty(locations, "locations");
        return new ServiceCaller<MetaService>((ChannelProvider)metaCache.get(locations), 30, CallOptions.DEFAULT, MetaService.Impl::new).getService();
    }

    public static MetaService tsoService(Set<Location> locations) {
        Parameters.notEmpty(locations, "locations");
        return new ServiceCaller<MetaService>((ChannelProvider)tsoCache.get(locations), 30, CallOptions.DEFAULT, MetaService.Impl::new).getService();
    }

    public static MetaService autoIncrementMetaService(Set<Location> locations) {
        Parameters.notEmpty(locations, "locations");
        return new ServiceCaller<MetaService>((ChannelProvider)autoIncrementCache.get(locations), 30, CallOptions.DEFAULT, MetaService.Impl::new).getService();
    }

    public static VersionService versionService(Set<Location> locations) {
        Parameters.notEmpty(locations, "locations");
        return new ServiceCaller<VersionService>((ChannelProvider)versionCache.get(locations), 30, CallOptions.DEFAULT, VersionService.Impl::new).getService();
    }

    public static void invalidateVersionService(Set<Location> locations) {
        versionCache.invalidate(locations);
    }

    public static ChannelProvider regionChannelProvider(Set<Location> locations, DingoCommonId tableId, DingoCommonId regionId) {
        return ((TableRegionsFailOver)((LoadingCache)tableFailOverCache.get(locations)).get((Object)tableId)).createRegionProvider(regionId);
    }

    public static long findRegion(Set<Location> locations, byte[] key) {
        return Services.regionChannelProvider(locations, key).getRegionId();
    }

    public static long findRegionNewly(Set<Location> locations, byte[] key) {
        return Services.regionChannelProviderNewly(locations, key).getRegionId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RegionChannelProvider regionChannelProvider(Set<Location> locations, byte[] key) {
        NavigableMap regions;
        NavigableMap navigableMap = regions = Optional.ofNullable(rangeRegions.floorEntry(key)).map(Map.Entry::getValue).ifAbsentSet(() -> {
            long id = CodecUtils.readId(key);
            byte[] begin = CodecUtils.encodeId(key[0], id);
            return rangeRegions.computeIfAbsent(begin, k -> new TreeMap(ByteArrayUtils::compare));
        }).get();
        synchronized (navigableMap) {
            Range range;
            ScanRegionInfo region2 = Optional.mapOrNull(regions.floorEntry(key), Map.Entry::getValue);
            if (region2 != null && (range = Optional.mapOrNull(region2, ScanRegionInfo::getRange)) != null && ByteArrayUtils.compare(key, range.getStartKey()) >= 0 && ByteArrayUtils.compare(key, range.getEndKey()) < 0) {
                try {
                    RegionChannelProvider regionProvider = (RegionChannelProvider)((LoadingCache)regionCache.get(locations)).get((Object)region2.getRegionId());
                    if (regionProvider.isStatus() && regionProvider.isIn(key)) {
                        return regionProvider;
                    }
                }
                catch (UncheckedExecutionException | DingoClientException.InvalidRouteTableException throwable) {
                    // empty catch block
                }
            }
            return Services.regionChannelProviderNewly(locations, key);
        }
    }

    public static RegionChannelProvider regionChannelProviderNewly(Set<Location> locations, byte[] key) {
        NavigableMap regions;
        long id = CodecUtils.readId(key);
        byte[] begin = CodecUtils.encodeId(key[0], id);
        byte[] end = CodecUtils.encodeId(key[0], id + 1L);
        NavigableMap navigableMap = regions = rangeRegions.computeIfAbsent(begin, k -> new TreeMap(ByteArrayUtils::compare));
        synchronized (navigableMap) {
            RegionChannelProvider regionProvider;
            regions.clear();
            Optional.ofNullable(Services.coordinatorService(locations).scanRegions((ScanRegionsRequest)((ScanRegionsRequest.ScanRegionsRequestBuilder)((ScanRegionsRequest.ScanRegionsRequestBuilder)ScanRegionsRequest.builder().key(begin)).rangeEnd(end)).build())).map(ScanRegionsResponse::getRegions).ifPresent($ -> $.forEach(region2 -> regions.put(region2.getRange().getStartKey(), region2)));
            ScanRegionInfo region2 = Optional.mapOrNull(regions.floorEntry(key), Map.Entry::getValue);
            Range range = Optional.mapOrNull(region2, ScanRegionInfo::getRange);
            if (range != null && ByteArrayUtils.compare(key, range.getStartKey()) >= 0 && ByteArrayUtils.compare(key, range.getEndKey()) < 0 && (regionProvider = (RegionChannelProvider)((LoadingCache)regionCache.get(locations)).get((Object)region2.getRegionId())).isIn(key)) {
                return regionProvider;
            }
            throw new RuntimeException("Cannot found region for " + Arrays.toString(key));
        }
    }

    public static StoreService storeRegionService(Set<Location> locations, byte[] key, int retry) {
        return new ServiceCaller<StoreService>(Services.regionChannelProvider(locations, key), retry, CallOptions.DEFAULT, StoreService.Impl::new).getService();
    }

    public static IndexService indexRegionService(Set<Location> locations, byte[] key, int retry) {
        return new ServiceCaller<IndexService>(Services.regionChannelProvider(locations, key), retry, CallOptions.DEFAULT, IndexService.Impl::new).getService();
    }

    public static StoreService storeRegionService(Set<Location> locations, long regionId, int retry) {
        Set<Location> locationsStr = Parameters.notEmpty(locations, "locations");
        ChannelProvider regionProvider = (ChannelProvider)((LoadingCache)regionCache.get(locationsStr)).get((Object)regionId);
        return new ServiceCaller<StoreService>(regionProvider, retry, CallOptions.DEFAULT, StoreService.Impl::new).getService();
    }

    public static IndexService indexRegionService(Set<Location> locations, long regionId, int retry) {
        Set<Location> locationsStr = Parameters.notEmpty(locations, "locations");
        ChannelProvider regionProvider = (ChannelProvider)((LoadingCache)regionCache.get(locationsStr)).get((Object)regionId);
        return new ServiceCaller<IndexService>(regionProvider, retry, CallOptions.DEFAULT, IndexService.Impl::new).getService();
    }

    public static DocumentService documentRegionService(Set<Location> locations, long regionId, int retry) {
        Set<Location> locationsStr = Parameters.notEmpty(locations, "locations");
        ChannelProvider regionProvider = (ChannelProvider)((LoadingCache)regionCache.get(locationsStr)).get((Object)regionId);
        return new ServiceCaller<DocumentService>(regionProvider, retry, CallOptions.DEFAULT, DocumentService.Impl::new).getService();
    }

    public static UtilService utilService(Set<Location> locations, long regionId, int retry) {
        Set<Location> locationsStr = Parameters.notEmpty(locations, "locations");
        ChannelProvider regionProvider = (ChannelProvider)((LoadingCache)regionCache.get(locationsStr)).get((Object)regionId);
        return new ServiceCaller<UtilService>(regionProvider, retry, CallOptions.DEFAULT, UtilService.Impl::new).getService();
    }

    public static StoreService storeRegionService(Set<Location> locations, DingoCommonId tableId, DingoCommonId regionId, int retry) {
        Set<Location> locationsStr = Parameters.notEmpty(locations, "locations");
        ChannelProvider regionProvider = ((TableRegionsFailOver)((LoadingCache)tableFailOverCache.get(locationsStr)).get((Object)tableId)).createRegionProvider(regionId);
        return new ServiceCaller<StoreService>(regionProvider, retry, CallOptions.DEFAULT, StoreService.Impl::new).getService();
    }

    public static IndexService indexRegionService(Set<Location> locations, DingoCommonId indexId, DingoCommonId regionId, int retry) {
        Set<Location> locationsStr = Parameters.notEmpty(locations, "locations");
        ChannelProvider regionProvider = ((TableRegionsFailOver)((LoadingCache)tableFailOverCache.get(locationsStr)).get((Object)indexId)).createRegionProvider(regionId);
        return new ServiceCaller<IndexService>(regionProvider, retry, CallOptions.DEFAULT, IndexService.Impl::new).getService();
    }
}

