/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.service;

import io.dingodb.sdk.common.DingoClientException;
import io.dingodb.sdk.common.utils.ErrorCodeUtils;
import io.dingodb.sdk.service.Caller;
import io.dingodb.sdk.service.JsonMessageUtils;
import io.dingodb.sdk.service.ServiceCallCycle;
import io.dingodb.sdk.service.caller.RpcCaller;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.common.RequestInfo;
import io.dingodb.sdk.service.util.OnlineDdlLogUtils;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.MethodDescriptor;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceCallCycles<REQ extends Message.Request, RES extends Message.Response>
implements ServiceCallCycle<REQ, RES>,
ServiceCallCycle.Before<REQ, RES>,
ServiceCallCycle.After<REQ, RES>,
ServiceCallCycle.OnException<REQ, RES>,
ServiceCallCycle.OnRetry<REQ, RES>,
ServiceCallCycle.OnIgnore<REQ, RES>,
ServiceCallCycle.OnRefresh<REQ, RES>,
ServiceCallCycle.OnThrow<REQ, RES>,
ServiceCallCycle.OnNonConnection<REQ, RES>,
ServiceCallCycle.OnErrRes<REQ, RES>,
ServiceCallCycle.OnFailed<REQ, RES>,
ServiceCallCycle.RBefore<REQ, RES>,
ServiceCallCycle.RAfter<REQ, RES>,
ServiceCallCycle.RError<REQ, RES>,
Caller.CallExecutor<REQ, RES> {
    private static final Logger log = LoggerFactory.getLogger(ServiceCallCycles.class);
    private final DelegateList<ServiceCallCycle.Before<REQ, RES>> before = new DelegateList();
    private final DelegateList<ServiceCallCycle.After<REQ, RES>> after = new DelegateList();
    private final DelegateList<ServiceCallCycle.OnException<REQ, RES>> onException = new DelegateList();
    private final DelegateList<ServiceCallCycle.OnRetry<REQ, RES>> onRetry = new DelegateList();
    private final DelegateList<ServiceCallCycle.OnIgnore<REQ, RES>> onIgnore = new DelegateList();
    private final DelegateList<ServiceCallCycle.OnRefresh<REQ, RES>> onRefresh = new DelegateList();
    private final DelegateList<ServiceCallCycle.OnThrow<REQ, RES>> onThrow = new DelegateList();
    private final DelegateList<ServiceCallCycle.OnNonConnection<REQ, RES>> onNonConnection = new DelegateList();
    private final DelegateList<ServiceCallCycle.OnFailed<REQ, RES>> onFailed = new DelegateList();
    private final DelegateList<ServiceCallCycle.RBefore<REQ, RES>> rBefore = new DelegateList();
    private final DelegateList<ServiceCallCycle.RAfter<REQ, RES>> rAfter = new DelegateList();
    private final DelegateList<ServiceCallCycle.RError<REQ, RES>> rError = new DelegateList();
    private final DelegateReference<ServiceCallCycle.OnErrRes<REQ, RES>> onErrRes = new DelegateReference<Object>(null);
    private final DelegateReference<Caller.CallExecutor<REQ, RES>> callExecutor = new DelegateReference<Caller.CallExecutor<Message.Request, Message.Response>>(RpcCaller::call);
    public final MethodDescriptor<REQ, RES> method;
    public final Logger logger;

    public ServiceCallCycles(MethodDescriptor<REQ, RES> method, Logger logger) {
        this.method = method;
        this.logger = logger;
    }

    @Override
    public RES call(MethodDescriptor<REQ, RES> method, REQ request, CallOptions options, Channel channel, long trace, ServiceCallCycles<REQ, RES> handlers) {
        return ((Caller.CallExecutor)this.callExecutor.ref).call(method, request, options, channel, trace, handlers);
    }

    @Override
    public void before(REQ req, CallOptions options, long trace) {
        if (Before.log.isDebugEnabled() && this.logger.isDebugEnabled() && OnlineDdlLogUtils.onlineDdlReq(req)) {
            this.logger.debug(JsonMessageUtils.toJson(this.method.getFullMethodName(), trace, req, null, options));
        }
        req.setRequestInfo((RequestInfo)((RequestInfo.RequestInfoBuilder)RequestInfo.builder().requestId(trace)).build());
        for (ServiceCallCycle.Before before : this.before.list) {
            before.before(req, options, trace);
        }
    }

    @Override
    public void rBefore(REQ req, CallOptions options, String remote, long trace) {
        if (RBefore.log.isDebugEnabled() && this.logger.isDebugEnabled() && OnlineDdlLogUtils.onlineDdlReq(req)) {
            this.logger.debug(JsonMessageUtils.toJson(remote, this.method.getFullMethodName(), trace, req, null, options));
        }
        for (ServiceCallCycle.RBefore rBefore : this.rBefore.list) {
            rBefore.rBefore(req, options, remote, trace);
        }
    }

    @Override
    public void after(REQ req, RES res, CallOptions options, String remote, long trace) {
        if (After.log.isDebugEnabled() && this.logger.isDebugEnabled() && OnlineDdlLogUtils.onlineDdlReq(req)) {
            this.logger.debug(JsonMessageUtils.toJson(remote, this.method.getFullMethodName(), trace, req, res, options));
        }
        for (ServiceCallCycle.After after : this.after.list) {
            after.after(req, res, options, remote, trace);
        }
    }

    @Override
    public void rAfter(REQ req, RES res, CallOptions options, String remote, long trace) {
        if (RAfter.log.isDebugEnabled() && this.logger.isDebugEnabled() && OnlineDdlLogUtils.onlineDdlReq(req)) {
            this.logger.debug(JsonMessageUtils.toJson(remote, this.method.getFullMethodName(), trace, req, res, options));
        }
        for (ServiceCallCycle.RAfter rAfter : this.rAfter.list) {
            rAfter.rAfter(req, res, options, remote, trace);
        }
    }

    @Override
    public void rError(REQ req, CallOptions options, String remote, long trace, String statusMessage) {
        if (RError.log.isDebugEnabled() && this.logger.isDebugEnabled()) {
            this.logger.debug(JsonMessageUtils.toJson(statusMessage, remote, this.method.getFullMethodName(), trace, req, null, options, null));
        }
        for (ServiceCallCycle.RError rError : this.rError.list) {
            rError.rError(req, options, remote, trace, statusMessage);
        }
    }

    @Override
    public ErrorCodeUtils.Strategy onErrStrategy(ErrorCodeUtils.Strategy strategy, int retry, int remain, REQ req, RES res, CallOptions options, String remote, long trace) {
        if (OnErrRes.log.isDebugEnabled() && this.logger.isDebugEnabled()) {
            this.logger.debug("Service call [{}:{}] error on [{}], trace [{}], retry: {}, remain: {}, req: {}, res: {}, options: {}", new Object[]{remote, this.method.getFullMethodName(), System.currentTimeMillis(), trace, retry, remain, req, res, options});
        }
        ErrorCodeUtils.Strategy before = strategy;
        ServiceCallCycle.OnErrRes onErrRes = (ServiceCallCycle.OnErrRes)this.onErrRes.ref;
        if (onErrRes != null) {
            strategy = onErrRes.onErrStrategy(strategy, retry, remain, req, res, options, remote, trace);
        }
        if (before != strategy && OnErrRes.log.isDebugEnabled() && this.logger.isDebugEnabled()) {
            this.logger.debug("Service call [{}:{}] error on [{}], trace [{}], before strategy [{}], change to [{}]", new Object[]{remote, this.method.getFullMethodName(), System.currentTimeMillis(), trace, before, strategy});
        }
        return strategy;
    }

    @Override
    public void onException(REQ req, Exception ex, CallOptions options, String remote, long trace) {
        if (OnException.log.isDebugEnabled() && this.logger.isDebugEnabled()) {
            this.logger.debug(JsonMessageUtils.toJson(null, remote, this.method.getFullMethodName(), trace, req, null, options, ex));
        }
        for (ServiceCallCycle.OnException onException : this.onException.list) {
            onException.onException(req, ex, options, remote, trace);
        }
    }

    @Override
    public void onRetry(REQ req, RES res, CallOptions options, String remote, long trace) {
        if (OnRetry.log.isDebugEnabled() && this.logger.isDebugEnabled()) {
            this.logger.debug(JsonMessageUtils.toJson(remote, this.method.getFullMethodName(), trace, req, res, options));
        }
        for (ServiceCallCycle.OnRetry onRetry : this.onRetry.list) {
            onRetry.onRetry(req, res, options, remote, trace);
        }
    }

    @Override
    public void onFailed(REQ req, RES res, CallOptions options, String remote, long trace) {
        if (OnFailed.log.isDebugEnabled() && this.logger.isDebugEnabled()) {
            this.logger.debug(JsonMessageUtils.toJson(remote, this.method.getFullMethodName(), trace, req, res, options));
        }
        for (ServiceCallCycle.OnFailed onFailed : this.onFailed.list) {
            onFailed.onFailed(req, res, options, remote, trace);
        }
    }

    @Override
    public void onIgnore(REQ req, RES res, CallOptions options, String remote, long trace) {
        if (OnIgnore.log.isDebugEnabled() && this.logger.isDebugEnabled()) {
            this.logger.debug(JsonMessageUtils.toJson(remote, this.method.getFullMethodName(), trace, req, res, options));
        }
        for (ServiceCallCycle.OnIgnore onIgnore : this.onIgnore.list) {
            onIgnore.onIgnore(req, res, options, remote, trace);
        }
    }

    @Override
    public void onRefresh(REQ req, RES res, CallOptions options, String remote, long trace) {
        if (OnRefresh.log.isDebugEnabled() && this.logger.isDebugEnabled()) {
            this.logger.debug(JsonMessageUtils.toJson(remote, this.method.getFullMethodName(), trace, req, res, options));
        }
        for (ServiceCallCycle.OnRefresh onRefresh : this.onRefresh.list) {
            onRefresh.onRefresh(req, res, options, remote, trace);
        }
    }

    @Override
    public void onNonConnection(REQ req, CallOptions options, long trace) {
        if (OnNonConnection.log.isDebugEnabled() && this.logger.isDebugEnabled()) {
            this.logger.debug(JsonMessageUtils.toJson(this.method.getFullMethodName(), trace, req, null, options));
        }
        for (ServiceCallCycle.OnNonConnection onNonConnection : this.onNonConnection.list) {
            onNonConnection.onNonConnection(req, options, trace);
        }
    }

    @Override
    public void onThrow(REQ req, DingoClientException.ExhaustedRetryException ex, CallOptions options, long trace) {
        if (OnThrow.log.isDebugEnabled() && this.logger.isDebugEnabled()) {
            this.logger.debug(JsonMessageUtils.toJson(null, null, this.method.getFullMethodName(), trace, req, null, options, ex));
        }
        for (ServiceCallCycle.OnThrow onThrow : this.onThrow.list) {
            onThrow.onThrow(req, ex, options, trace);
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServiceCallCycles)) {
            return false;
        }
        ServiceCallCycles other = (ServiceCallCycles)o;
        if (!other.canEqual(this)) {
            return false;
        }
        MethodDescriptor<REQ, RES> this$method = this.method;
        MethodDescriptor<REQ, RES> other$method = other.method;
        return !(this$method == null ? other$method != null : !this$method.equals(other$method));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServiceCallCycles;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MethodDescriptor<REQ, RES> $method = this.method;
        result = result * 59 + ($method == null ? 43 : $method.hashCode());
        return result;
    }

    public void addListener(ServiceCallCycle.Before<REQ, RES> t) {
        this.before.addListener(t);
    }

    public void removeListener(ServiceCallCycle.Before<REQ, RES> t) {
        this.before.removeListener(t);
    }

    public void addListener(ServiceCallCycle.After<REQ, RES> t) {
        this.after.addListener(t);
    }

    public void removeListener(ServiceCallCycle.After<REQ, RES> t) {
        this.after.removeListener(t);
    }

    public void addListener(ServiceCallCycle.OnException<REQ, RES> t) {
        this.onException.addListener(t);
    }

    public void removeListener(ServiceCallCycle.OnException<REQ, RES> t) {
        this.onException.removeListener(t);
    }

    public void addListener(ServiceCallCycle.OnRetry<REQ, RES> t) {
        this.onRetry.addListener(t);
    }

    public void removeListener(ServiceCallCycle.OnRetry<REQ, RES> t) {
        this.onRetry.removeListener(t);
    }

    public void addListener(ServiceCallCycle.OnIgnore<REQ, RES> t) {
        this.onIgnore.addListener(t);
    }

    public void removeListener(ServiceCallCycle.OnIgnore<REQ, RES> t) {
        this.onIgnore.removeListener(t);
    }

    public void addListener(ServiceCallCycle.OnRefresh<REQ, RES> t) {
        this.onRefresh.addListener(t);
    }

    public void removeListener(ServiceCallCycle.OnRefresh<REQ, RES> t) {
        this.onRefresh.removeListener(t);
    }

    public void addListener(ServiceCallCycle.OnThrow<REQ, RES> t) {
        this.onThrow.addListener(t);
    }

    public void removeListener(ServiceCallCycle.OnThrow<REQ, RES> t) {
        this.onThrow.removeListener(t);
    }

    public void addListener(ServiceCallCycle.OnNonConnection<REQ, RES> t) {
        this.onNonConnection.addListener(t);
    }

    public void removeListener(ServiceCallCycle.OnNonConnection<REQ, RES> t) {
        this.onNonConnection.removeListener(t);
    }

    public void addListener(ServiceCallCycle.OnFailed<REQ, RES> t) {
        this.onFailed.addListener(t);
    }

    public void removeListener(ServiceCallCycle.OnFailed<REQ, RES> t) {
        this.onFailed.removeListener(t);
    }

    public void addListener(ServiceCallCycle.RBefore<REQ, RES> t) {
        this.rBefore.addListener(t);
    }

    public void removeListener(ServiceCallCycle.RBefore<REQ, RES> t) {
        this.rBefore.removeListener(t);
    }

    public void addListener(ServiceCallCycle.RAfter<REQ, RES> t) {
        this.rAfter.addListener(t);
    }

    public void removeListener(ServiceCallCycle.RAfter<REQ, RES> t) {
        this.rAfter.removeListener(t);
    }

    public void addListener(ServiceCallCycle.RError<REQ, RES> t) {
        this.rError.addListener(t);
    }

    public void removeListener(ServiceCallCycle.RError<REQ, RES> t) {
        this.rError.removeListener(t);
    }

    public void setHandler(ServiceCallCycle.OnErrRes<REQ, RES> ref) {
        this.onErrRes.setHandler(ref);
    }

    public void setHandler(Caller.CallExecutor<REQ, RES> ref) {
        this.callExecutor.setHandler(ref);
    }

    static class DelegateList<T> {
        private final List<T> list = new ArrayList<T>();

        DelegateList() {
        }

        public synchronized void addListener(T t) {
            this.list.add(t);
        }

        public synchronized void removeListener(T t) {
            this.list.remove(t);
        }
    }

    static class DelegateReference<T> {
        public final T defaultRef;
        private T ref;

        DelegateReference(T defaultRef) {
            this.defaultRef = defaultRef;
            this.ref = defaultRef;
        }

        public synchronized void setHandler(T ref) {
            if (ref == null) {
                ref = this.defaultRef;
            }
            this.ref = ref;
        }
    }

    public static final class Before {
        private static final Logger log = LoggerFactory.getLogger(Before.class);
    }

    public static final class RBefore {
        private static final Logger log = LoggerFactory.getLogger(RBefore.class);
    }

    public static final class After {
        private static final Logger log = LoggerFactory.getLogger(After.class);
    }

    public static final class RAfter {
        private static final Logger log = LoggerFactory.getLogger(RAfter.class);
    }

    public static final class RError {
        private static final Logger log = LoggerFactory.getLogger(RError.class);
    }

    public static final class OnErrRes {
        private static final Logger log = LoggerFactory.getLogger(OnErrRes.class);
    }

    public static final class OnException {
        private static final Logger log = LoggerFactory.getLogger(OnException.class);
    }

    public static final class OnRetry {
        private static final Logger log = LoggerFactory.getLogger(OnRetry.class);
    }

    public static final class OnFailed {
        private static final Logger log = LoggerFactory.getLogger(OnFailed.class);
    }

    public static final class OnIgnore {
        private static final Logger log = LoggerFactory.getLogger(OnIgnore.class);
    }

    public static final class OnRefresh {
        private static final Logger log = LoggerFactory.getLogger(OnRefresh.class);
    }

    public static final class OnNonConnection {
        private static final Logger log = LoggerFactory.getLogger(OnNonConnection.class);
    }

    public static final class OnThrow {
        private static final Logger log = LoggerFactory.getLogger(OnThrow.class);
    }
}

