/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.service;

import io.dingodb.sdk.common.DingoClientException;
import io.dingodb.sdk.common.utils.ErrorCodeUtils;
import io.dingodb.sdk.service.entity.Message;
import io.grpc.CallOptions;

public interface ServiceCallCycle<REQ extends Message.Request, RES extends Message.Response> {

    public static interface OnThrow<REQ extends Message.Request, RES extends Message.Response> {
        default public void onThrow(REQ req, DingoClientException.ExhaustedRetryException exception, CallOptions options, long trace) {
        }
    }

    public static interface OnNonConnection<REQ extends Message.Request, RES extends Message.Response> {
        default public void onNonConnection(REQ req, CallOptions options, long trace) {
        }
    }

    public static interface OnRefresh<REQ extends Message.Request, RES extends Message.Response> {
        default public void onRefresh(REQ req, RES res, CallOptions options, String remote, long trace) {
        }
    }

    public static interface OnIgnore<REQ extends Message.Request, RES extends Message.Response> {
        default public void onIgnore(REQ req, RES res, CallOptions options, String remote, long trace) {
        }
    }

    public static interface OnFailed<REQ extends Message.Request, RES extends Message.Response> {
        default public void onFailed(REQ req, RES res, CallOptions options, String remote, long trace) {
        }
    }

    public static interface OnRetry<REQ extends Message.Request, RES extends Message.Response> {
        default public void onRetry(REQ req, RES res, CallOptions options, String remote, long trace) {
        }
    }

    public static interface OnException<REQ extends Message.Request, RES extends Message.Response> {
        default public void onException(REQ req, Exception exception, CallOptions options, String remote, long trace) {
        }
    }

    public static interface OnErrRes<REQ extends Message.Request, RES extends Message.Response> {
        default public ErrorCodeUtils.Strategy onErrStrategy(ErrorCodeUtils.Strategy strategy, int retry, int remain, REQ req, RES res, CallOptions options, String remote, long trace) {
            return strategy;
        }
    }

    public static interface RError<REQ extends Message.Request, RES extends Message.Response> {
        default public void rError(REQ req, CallOptions options, String remote, long trace, String statusMessage) {
        }
    }

    public static interface RAfter<REQ extends Message.Request, RES extends Message.Response> {
        default public void rAfter(REQ req, RES res, CallOptions options, String remote, long trace) {
        }
    }

    public static interface RBefore<REQ extends Message.Request, RES extends Message.Response> {
        default public void rBefore(REQ req, CallOptions options, String remote, long trace) {
        }
    }

    public static interface After<REQ extends Message.Request, RES extends Message.Response> {
        default public void after(REQ req, RES res, CallOptions options, String remote, long trace) {
        }
    }

    public static interface Before<REQ extends Message.Request, RES extends Message.Response> {
        default public void before(REQ req, CallOptions options, long trace) {
        }
    }
}

