/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.service;

import io.dingodb.sdk.common.DingoClientException;
import io.dingodb.sdk.common.codec.CodecUtils;
import io.dingodb.sdk.common.utils.ByteArrayUtils;
import io.dingodb.sdk.common.utils.Optional;
import io.dingodb.sdk.service.ChannelManager;
import io.dingodb.sdk.service.ChannelProvider;
import io.dingodb.sdk.service.CoordinatorService;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.common.Location;
import io.dingodb.sdk.service.entity.common.Range;
import io.dingodb.sdk.service.entity.common.Region;
import io.dingodb.sdk.service.entity.common.RegionDefinition;
import io.dingodb.sdk.service.entity.common.RegionEpoch;
import io.dingodb.sdk.service.entity.coordinator.QueryRegionRequest;
import io.dingodb.sdk.service.entity.coordinator.QueryRegionResponse;
import io.dingodb.sdk.service.entity.coordinator.ScanRegionsRequest;
import io.dingodb.sdk.service.entity.coordinator.ScanRegionsResponse;
import io.dingodb.sdk.service.entity.store.Context;
import io.grpc.Channel;

public class RegionChannelProvider
implements ChannelProvider {
    private final long regionId;
    private Range range;
    private byte[] idKey;
    private byte[] nextIdKey;
    private final CoordinatorService coordinatorService;
    private Location location;
    private Channel channel;
    private RegionEpoch regionEpoch;
    private boolean status = true;

    public RegionChannelProvider(CoordinatorService coordinatorService, long regionId) {
        this.coordinatorService = coordinatorService;
        this.regionId = regionId;
        this.refresh(null, 0L);
    }

    @Override
    public Channel channel() {
        return this.channel;
    }

    @Override
    public synchronized void refresh(Channel channel, long trace) {
        if (channel == this.channel) {
            this.refresh(trace);
        }
    }

    @Override
    public void before(Message.Request message) {
        if (message instanceof Message.StoreRequest) {
            Context context = ((Message.StoreRequest)message).getContext();
            if (context == null) {
                context = new Context();
                ((Message.StoreRequest)message).setContext(context);
            }
            context.setRegionEpoch(this.regionEpoch);
            context.setRegionId(this.regionId);
        }
    }

    public boolean isStatus() {
        if (!this.status) {
            throw new DingoClientException.InvalidRouteTableException("region id not found");
        }
        return true;
    }

    public boolean isIn(byte[] key) {
        if (this.range == null) {
            throw new RuntimeException("Not refresh!");
        }
        return ByteArrayUtils.compare(this.range.getStartKey(), key) <= 0 && ByteArrayUtils.compare(key, this.range.getEndKey()) < 0;
    }

    private void refresh(long trace) {
        if (this.idKey == null) {
            this.refreshIdKey(trace);
        }
        Optional.ofNullable(this.coordinatorService.scanRegions(trace, (ScanRegionsRequest)((ScanRegionsRequest.ScanRegionsRequestBuilder)((ScanRegionsRequest.ScanRegionsRequestBuilder)ScanRegionsRequest.builder().key(this.idKey)).rangeEnd(this.nextIdKey)).build())).map(ScanRegionsResponse::getRegions).map($ -> $.stream().filter(region2 -> region2.getRegionId() == this.regionId).findAny().orElse(null)).filter($ -> $.getLeader() != null).ifPresent($ -> {
            this.location = $.getLeader();
            this.channel = ChannelManager.getChannel(this.location);
            this.regionEpoch = $.getRegionEpoch();
            this.range = $.getRange();
        }).ifAbsent(() -> {
            this.status = false;
        });
    }

    private synchronized void refreshIdKey(long trace) {
        if (this.idKey != null) {
            return;
        }
        Optional.ofNullable(this.coordinatorService.queryRegion(trace, (QueryRegionRequest)((QueryRegionRequest.QueryRegionRequestBuilder)QueryRegionRequest.builder().regionId(this.regionId)).build())).map(QueryRegionResponse::getRegion).map(Region::getDefinition).map(RegionDefinition::getRange).ifPresent(range -> {
            this.range = range;
        }).map(Range::getStartKey).ifPresent($ -> {
            long id = CodecUtils.readId($);
            this.idKey = CodecUtils.encodeId($[0], id);
            this.nextIdKey = CodecUtils.encodeId($[0], id + 1L);
        });
    }

    public long getRegionId() {
        return this.regionId;
    }

    public Range getRange() {
        return this.range;
    }

    public byte[] getIdKey() {
        return this.idKey;
    }
}

