/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.service;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.common.base.CaseFormat;
import io.dingodb.sdk.common.utils.ByteArrayUtils;
import io.dingodb.sdk.common.utils.StackTraces;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.ServiceCallCycleEntity;
import io.grpc.CallOptions;
import java.io.IOException;

public class JsonMessageUtils {
    private static final ObjectMapper jsonMapper = new ObjectMapper();

    public static String toJson(Message message) {
        return jsonMapper.writeValueAsString((Object)message);
    }

    public static String toJson(ServiceCallCycleEntity entity) {
        return jsonMapper.writeValueAsString((Object)entity);
    }

    public static String toJson(String method, long trace, Message.Request request, Message.Response response, CallOptions options) {
        return jsonMapper.writeValueAsString((Object)ServiceCallCycleEntity.builder().trace(trace).options(options).method(method).step(CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, StackTraces.methodName(2))).request(request).response(response).build());
    }

    public static String toJson(String remote, String method, long trace, Message.Request request, Message.Response response, CallOptions options) {
        return jsonMapper.writeValueAsString((Object)ServiceCallCycleEntity.builder().trace(trace).options(options).method(method).step(CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, StackTraces.methodName(2))).remote(remote).request(request).response(response).build());
    }

    public static String toJson(String status, String remote, String method, long trace, Message.Request request, Message.Response response, CallOptions options, Exception exception) {
        return jsonMapper.writeValueAsString((Object)ServiceCallCycleEntity.builder().trace(trace).options(options).method(method).step(CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, StackTraces.methodName(2))).remote(remote).request(request).response(response).exception(exception).status(status).build());
    }

    static {
        SimpleModule simpleModule = new SimpleModule();
        ByteArraySerializer bytesSerializer = new ByteArraySerializer();
        simpleModule.addSerializer(byte[].class, (JsonSerializer)bytesSerializer);
        jsonMapper.registerModule((Module)simpleModule);
    }

    private static class ByteArraySerializer
    extends JsonSerializer<byte[]> {
        private ByteArraySerializer() {
        }

        public void serialize(byte[] value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeStartObject();
            gen.writeFieldName("bytes");
            gen.writeStartArray();
            for (byte b : value) {
                gen.writeNumber((short)b);
            }
            gen.writeEndArray();
            gen.writeFieldName("hex");
            gen.writeString(ByteArrayUtils.toHex(value));
            gen.writeEndObject();
        }
    }
}

