/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.service;

import io.dingodb.sdk.common.utils.Optional;
import io.dingodb.sdk.common.utils.Parameters;
import io.dingodb.sdk.service.ChannelManager;
import io.dingodb.sdk.service.ChannelProvider;
import io.dingodb.sdk.service.caller.RpcCaller;
import io.dingodb.sdk.service.desc.coordinator.CoordinatorServiceDescriptors;
import io.dingodb.sdk.service.entity.common.Location;
import io.dingodb.sdk.service.entity.coordinator.GetCoordinatorMapRequest;
import io.dingodb.sdk.service.entity.coordinator.GetCoordinatorMapResponse;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoordinatorChannelProvider
implements ChannelProvider {
    private static final Logger log = LoggerFactory.getLogger(CoordinatorChannelProvider.class);
    private final Function<GetCoordinatorMapResponse, Location> locationGetter;
    private Set<Location> locations;
    private Channel channel;

    public CoordinatorChannelProvider(Set<Location> locations, Function<GetCoordinatorMapResponse, Location> locationGetter) {
        this.locations = locations;
        this.locationGetter = locationGetter;
    }

    @Override
    public synchronized Channel channel() {
        return this.channel;
    }

    @Override
    public synchronized void refresh(Channel oldChannel, long trace) {
        if (oldChannel != this.channel) {
            return;
        }
        AtomicBoolean findLeader = new AtomicBoolean(false);
        for (Location location : this.locations) {
            ManagedChannel channel = ChannelManager.getChannel(location);
            try {
                GetCoordinatorMapResponse response = this.requestCoordinatorMap(trace, (Channel)channel);
                Optional.ofNullable(response).map(this.locationGetter).ifPresent(leader -> Parameters.nonNull(leader.getHost(), "location")).map(ChannelManager::getChannel).ifPresent(ch -> {
                    this.channel = ch;
                }).ifPresent($ -> findLeader.set(true)).map(ch -> this.requestCoordinatorMap(trace, (Channel)ChannelManager.getChannel(response.getLeaderLocation()))).map(GetCoordinatorMapResponse::getCoordinatorLocations).filter($ -> !$.isEmpty()).ifPresent($ -> {
                    this.locations = new HashSet<Location>((Collection<Location>)$);
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!findLeader.get()) continue;
            break;
        }
    }

    private GetCoordinatorMapResponse requestCoordinatorMap(long trace, Channel channel) {
        return RpcCaller.call(CoordinatorServiceDescriptors.getCoordinatorMap, new GetCoordinatorMapRequest(), CallOptions.DEFAULT.withDeadlineAfter(30L, TimeUnit.SECONDS), channel, trace, CoordinatorServiceDescriptors.getCoordinatorMapHandlers);
    }
}

