/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.service;

import io.dingodb.sdk.common.utils.NoBreakFunctions;
import io.dingodb.sdk.common.utils.Optional;
import io.dingodb.sdk.common.utils.StackTraces;
import io.dingodb.sdk.service.entity.common.Location;
import io.grpc.ChannelCredentials;
import io.grpc.InsecureChannelCredentials;
import io.grpc.ManagedChannel;
import io.grpc.NameResolver;
import io.grpc.internal.DnsNameResolverProvider;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ChannelManager {
    private static final Logger log = LoggerFactory.getLogger(ChannelManager.class);
    public static final int DEFAULT_MAX_MESSAGE_SIZE = 0x40000000;
    private static final Map<Location, ManagedChannel> channels = new ConcurrentHashMap<Location, ManagedChannel>();

    private ChannelManager() {
        Runtime.getRuntime().addShutdownHook(new Thread(ChannelManager::shutdown));
    }

    public static ManagedChannel getChannel(String host, int port) {
        return ChannelManager.getChannel(((Location.LocationBuilder)((Location.LocationBuilder)Location.builder().host(host)).port(port)).build());
    }

    public static ManagedChannel getChannel(io.dingodb.sdk.common.Location location) {
        return Optional.ofNullable(location).filter(__ -> __.getHost() != null).filter(__ -> !__.getHost().isEmpty()).ifAbsent(() -> {
            if (log.isDebugEnabled()) {
                log.warn("Cannot connect empty host, call stack {}.", (Object)StackTraces.stack(1));
            }
        }).map(__ -> channels.computeIfAbsent((Location)((Location.LocationBuilder)((Location.LocationBuilder)Location.builder().host(location.getHost())).port(location.getPort())).build(), k -> ChannelManager.newChannel(k.getHost(), k.getPort()))).orNull();
    }

    public static ManagedChannel getChannel(Location location) {
        return Optional.ofNullable(location).filter(__ -> __.getHost() != null).filter(__ -> !__.getHost().isEmpty()).ifAbsent(() -> {
            if (log.isDebugEnabled()) {
                log.warn("Cannot connect empty host, call stack {}.", (Object)StackTraces.stack(1));
            }
        }).map(__ -> channels.computeIfAbsent(location, k -> ChannelManager.newChannel(k.getHost(), k.getPort()))).orNull();
    }

    private static ManagedChannel newChannel(String host, int port) {
        return ((NettyChannelBuilder)NettyChannelBuilder.forAddress((String)host, (int)port, (ChannelCredentials)InsecureChannelCredentials.create()).nameResolverFactory((NameResolver.Factory)new DnsNameResolverProvider())).flowControlWindow(0x40000000).maxInboundMessageSize(0x40000000).maxInboundMetadataSize(0x40000000).keepAliveWithoutCalls(true).build();
    }

    private static void shutdown() {
        channels.values().forEach(NoBreakFunctions.wrap(ch -> ch.shutdown(), e -> log.error("Close channel error.", e)));
    }
}

