/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.service;

import io.dingodb.sdk.service.MetaService;
import io.dingodb.sdk.service.Services;
import io.dingodb.sdk.service.entity.common.Location;
import io.dingodb.sdk.service.entity.meta.DingoCommonId;
import io.dingodb.sdk.service.entity.meta.GenerateAutoIncrementRequest;
import io.dingodb.sdk.service.entity.meta.GenerateAutoIncrementResponse;
import io.dingodb.sdk.service.entity.meta.GetAutoIncrementRequest;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoIncrementService {
    private static final Logger log = LoggerFactory.getLogger(AutoIncrementService.class);
    private static final Map<Set<Location>, Map<DingoCommonId, AutoIncrement>> cache = new ConcurrentHashMap<Set<Location>, Map<DingoCommonId, AutoIncrement>>();
    private final MetaService metaService;
    private final Map<DingoCommonId, AutoIncrement> innerCache;
    private Long count = 10000L;
    private Integer increment = 1;
    private Integer offset = 1;

    public AutoIncrementService(String servers) {
        Set<Location> coordinators = Services.parse(servers);
        this.metaService = Services.autoIncrementMetaService(coordinators);
        this.innerCache = cache.computeIfAbsent(coordinators, s -> new ConcurrentHashMap());
    }

    public AutoIncrementService(Set<Location> coordinators) {
        this.metaService = Services.autoIncrementMetaService(coordinators);
        this.innerCache = cache.computeIfAbsent(coordinators, s -> new ConcurrentHashMap());
    }

    public void resetCount(long count) {
        this.count = count;
    }

    public void resetOffset(int offset) {
        this.offset = offset;
        cache.forEach((k, v) -> v.clear());
    }

    public void resetIncrement(int increment) {
        this.increment = increment;
        cache.forEach((k, v) -> v.clear());
    }

    public void reset(long count, int increment, int offset) {
        this.count = count;
        this.offset = offset;
        this.increment = increment;
        cache.forEach((k, v) -> v.clear());
    }

    private Increment fetch(DingoCommonId tableId) {
        try {
            GenerateAutoIncrementResponse response = this.metaService.generateAutoIncrement((GenerateAutoIncrementRequest)((GenerateAutoIncrementRequest.GenerateAutoIncrementRequestBuilder)((GenerateAutoIncrementRequest.GenerateAutoIncrementRequestBuilder)((GenerateAutoIncrementRequest.GenerateAutoIncrementRequestBuilder)((GenerateAutoIncrementRequest.GenerateAutoIncrementRequestBuilder)GenerateAutoIncrementRequest.builder().tableId(tableId)).count(this.count)).autoIncrementIncrement(this.increment)).autoIncrementOffset(this.offset)).build());
            log.info("Generated {} auto increment count: {}, increment: {}, offset:{}, startId:{}, endId:{}", new Object[]{tableId, this.count, this.increment, this.offset, response.getStartId(), response.getEndId()});
            return new Increment(response.getEndId(), response.getStartId());
        }
        catch (Exception e) {
            this.innerCache.remove(tableId);
            throw e;
        }
    }

    public long current(DingoCommonId tableId) {
        return this.metaService.getAutoIncrement((GetAutoIncrementRequest)((GetAutoIncrementRequest.GetAutoIncrementRequestBuilder)GetAutoIncrementRequest.builder().tableId(tableId)).build()).getStartId();
    }

    public long localCurrent(DingoCommonId tableId) {
        AutoIncrement autoIncrement = this.innerCache.get(tableId);
        if (autoIncrement == null) {
            return this.current(tableId);
        }
        return autoIncrement.current();
    }

    public long next(DingoCommonId tableId) {
        return this.innerCache.computeIfAbsent(tableId, id -> new AutoIncrement((DingoCommonId)id, this.increment, this.offset)).inc();
    }

    protected static class Increment {
        public final long limit;
        public final long inc;

        public Increment(long limit, long inc) {
            this.limit = limit;
            this.inc = inc;
        }
    }

    protected class AutoIncrement {
        private final DingoCommonId tableId;
        private final int increment;
        private final int offset;
        private long limit = 0L;
        private long inc = 0L;

        public AutoIncrement(DingoCommonId tableId, int increment, int offset) {
            this.tableId = tableId;
            this.increment = increment;
            this.offset = offset;
        }

        public long current() {
            return this.inc;
        }

        public synchronized long inc() {
            long current = this.inc;
            if (current >= this.limit) {
                current = this.fetch();
            }
            this.inc += (long)this.increment;
            return current;
        }

        private long fetch() {
            Increment increment = AutoIncrementService.this.fetch(this.tableId);
            if (increment.inc + (long)this.increment >= increment.limit) {
                throw new RuntimeException("Fetch zero increment, table id: {}" + String.valueOf(this.tableId));
            }
            this.inc = increment.inc % (long)this.offset != 0L ? increment.inc + (long)this.offset - increment.inc % (long)this.offset : increment.inc;
            this.limit = increment.limit;
            return this.inc;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AutoIncrement)) {
                return false;
            }
            AutoIncrement other = (AutoIncrement)o;
            if (!other.canEqual(this)) {
                return false;
            }
            DingoCommonId this$tableId = this.tableId;
            DingoCommonId other$tableId = other.tableId;
            return !(this$tableId == null ? other$tableId != null : !((Object)this$tableId).equals(other$tableId));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AutoIncrement;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            DingoCommonId $tableId = this.tableId;
            result = result * 59 + ($tableId == null ? 43 : ((Object)$tableId).hashCode());
            return result;
        }
    }
}

