/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.grpc.serializer;

import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.WireFormat;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.Numeric;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;

public class Writer {
    public static void write(Boolean value, CodedOutputStream out) {
        if (value != null) {
            out.writeBoolNoTag(value.booleanValue());
        }
    }

    public static void write(Integer value, CodedOutputStream out) {
        if (value != null) {
            out.writeInt32NoTag(value.intValue());
        }
    }

    public static void write(Long value, CodedOutputStream out) {
        if (value != null) {
            out.writeInt64NoTag(value.longValue());
        }
    }

    public static void write(Float value, CodedOutputStream out) {
        if (value != null) {
            out.writeFloatNoTag(value.floatValue());
        }
    }

    public static void write(Double value, CodedOutputStream out) {
        if (value != null) {
            out.writeDoubleNoTag(value.doubleValue());
        }
    }

    public static void write(Numeric value, CodedOutputStream out) {
        if (value != null) {
            Writer.write(value.number(), out);
        }
    }

    public static void write(String value, CodedOutputStream out) {
        if (value != null) {
            out.writeStringNoTag(value);
        }
    }

    public static void write(byte[] value, CodedOutputStream out) {
        if (value != null) {
            out.writeUInt32NoTag(value.length);
            out.write(value, 0, value.length);
        }
    }

    public static void write(Message value, CodedOutputStream out) {
        if (value != null) {
            out.writeUInt32NoTag(value.sizeOf());
            value.write(out);
        }
    }

    public static void write(Integer number, Boolean value, CodedOutputStream out) {
        if (value != null) {
            out.writeTag(number.intValue(), WireFormat.FieldType.BOOL.getWireType());
            Writer.write(value, out);
        }
    }

    public static void write(Integer number, Integer value, CodedOutputStream out) {
        if (value != null) {
            out.writeTag(number.intValue(), WireFormat.FieldType.INT32.getWireType());
            Writer.write(value, out);
        }
    }

    public static void write(Integer number, Long value, CodedOutputStream out) {
        if (value != null) {
            out.writeTag(number.intValue(), WireFormat.FieldType.INT64.getWireType());
            Writer.write(value, out);
        }
    }

    public static void write(Integer number, Float value, CodedOutputStream out) {
        if (value != null) {
            out.writeTag(number.intValue(), WireFormat.FieldType.FLOAT.getWireType());
            Writer.write(value, out);
        }
    }

    public static void write(Integer number, Double value, CodedOutputStream out) {
        if (value != null) {
            out.writeTag(number.intValue(), WireFormat.FieldType.DOUBLE.getWireType());
            Writer.write(value, out);
        }
    }

    public static void write(Integer number, Numeric value, CodedOutputStream out) {
        if (value != null) {
            Writer.write(number, value.number(), out);
        }
    }

    public static void write(Integer number, String value, CodedOutputStream out) {
        if (value != null) {
            out.writeTag(number.intValue(), 2);
            out.writeStringNoTag(value);
        }
    }

    public static void write(Integer number, byte[] value, CodedOutputStream out) {
        if (value != null) {
            out.writeTag(number.intValue(), 2);
            out.writeByteArrayNoTag(value);
        }
    }

    public static void write(Integer number, Message value, CodedOutputStream out) {
        if (value != null) {
            if (!value.isDirect()) {
                out.writeTag(number.intValue(), 2);
                out.writeUInt32NoTag(value.sizeOf());
            }
            value.write(out);
        }
    }

    public static void write(Numeric numeric, Message value, CodedOutputStream out) {
        if (value != null) {
            if (!value.isDirect()) {
                out.writeTag(numeric.number(), 2);
                out.writeUInt32NoTag(value.sizeOf());
            }
            value.write(out);
        }
    }

    public static <M> void write(Integer number, List<M> value, BiConsumer<Integer, M> serializer) {
        if (value != null) {
            value.forEach(v -> serializer.accept(number, v));
        }
    }

    public static <T> void write(Integer number, List<T> value, CodedOutputStream out, BiConsumer<T, CodedOutputStream> serializer, Function<T, Integer> sizeComputer) {
        if (value != null && value.size() > 0) {
            out.writeTag(number.intValue(), 2);
            Integer size = 0;
            for (Object object : value) {
                size = size + sizeComputer.apply(object);
            }
            out.writeUInt32NoTag(size.intValue());
            value.forEach(element -> serializer.accept(element, out));
        }
    }

    public static <K, V> void write(Integer number, Map<K, V> value, CodedOutputStream out, BiConsumer<Integer, K> keySerializer, BiConsumer<Integer, V> valueSerializer, Function<K, Integer> keySizeComputer, Function<V, Integer> valueSizeComputer) {
        if (value != null && value.size() > 0) {
            for (Map.Entry<K, V> entry : value.entrySet()) {
                out.writeTag(number.intValue(), 2);
                K k = entry.getKey();
                V v = entry.getValue();
                out.writeUInt32NoTag(CodedOutputStream.computeTagSize((int)1) + keySizeComputer.apply(k) + CodedOutputStream.computeTagSize((int)2) + valueSizeComputer.apply(v));
                keySerializer.accept(1, k);
                valueSerializer.accept(2, v);
            }
        }
    }
}

