/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.grpc.serializer;

import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.Numeric;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;

public class SizeUtils {
    public static Integer sizeOf(Boolean value) {
        return value == null ? 0 : CodedOutputStream.computeBoolSizeNoTag((boolean)value);
    }

    public static Integer sizeOf(Integer value) {
        return value == null ? 0 : CodedOutputStream.computeInt32SizeNoTag((int)value);
    }

    public static Integer sizeOf(Long value) {
        return value == null ? 0 : CodedOutputStream.computeInt64SizeNoTag((long)value);
    }

    public static Integer sizeOf(Float value) {
        return value == null ? 0 : CodedOutputStream.computeFloatSizeNoTag((float)value.floatValue());
    }

    public static Integer sizeOf(Double value) {
        return value == null ? 0 : CodedOutputStream.computeDoubleSizeNoTag((double)value);
    }

    public static Integer sizeOf(Numeric value) {
        return value == null ? 0 : CodedOutputStream.computeEnumSizeNoTag((int)value.number());
    }

    public static Integer sizeOf(String value) {
        return value == null ? 0 : CodedOutputStream.computeStringSizeNoTag((String)value);
    }

    public static Integer sizeOf(byte[] value) {
        return value == null ? 0 : CodedOutputStream.computeUInt32SizeNoTag((int)value.length) + value.length;
    }

    public static Integer sizeOf(Message value) {
        if (value != null) {
            int size = value.sizeOf();
            size += CodedOutputStream.computeInt32SizeNoTag((int)size);
            return size;
        }
        return 0;
    }

    public static Integer sizeOf(Integer number, Boolean value) {
        return value == null ? 0 : CodedOutputStream.computeBoolSize((int)number, (boolean)value);
    }

    public static Integer sizeOf(Integer number, Integer value) {
        return value == null ? 0 : CodedOutputStream.computeInt32Size((int)number, (int)value);
    }

    public static Integer sizeOf(Integer number, Long value) {
        return value == null ? 0 : CodedOutputStream.computeInt64Size((int)number, (long)value);
    }

    public static Integer sizeOf(Integer number, Float value) {
        return value == null ? 0 : CodedOutputStream.computeFloatSize((int)number, (float)value.floatValue());
    }

    public static Integer sizeOf(Integer number, Double value) {
        return value == null ? 0 : CodedOutputStream.computeDoubleSize((int)number, (double)value);
    }

    public static Integer sizeOf(Integer number, Numeric value) {
        return value == null ? 0 : CodedOutputStream.computeEnumSize((int)number, (int)value.number());
    }

    public static Integer sizeOf(Integer number, String value) {
        return value == null ? 0 : CodedOutputStream.computeStringSize((int)number, (String)value);
    }

    public static Integer sizeOf(Integer number, byte[] value) {
        return value == null ? 0 : CodedOutputStream.computeTagSize((int)number) + SizeUtils.sizeOf(value);
    }

    public static Integer sizeOf(Integer number, Message value) {
        if (value != null) {
            int size = value.sizeOf();
            size += CodedOutputStream.computeInt32SizeNoTag((int)size);
            return size += CodedOutputStream.computeTagSize((int)number);
        }
        return 0;
    }

    public static Integer sizeOf(Numeric numeric, Message value) {
        if (value != null) {
            int size = value.sizeOf();
            if (!value.isDirect()) {
                size += CodedOutputStream.computeInt32SizeNoTag((int)size);
                size += CodedOutputStream.computeTagSize((int)numeric.number());
            }
            return size;
        }
        return 0;
    }

    public static <T> int sizeOfPack(Integer number, List<T> value, Function<T, Integer> sizeComputer) {
        if (value != null && value.size() > 0) {
            int size = 0;
            for (T element : value) {
                size += sizeComputer.apply(element).intValue();
            }
            size = CodedOutputStream.computeUInt32SizeNoTag((int)size) + size + CodedOutputStream.computeTagSize((int)number);
            return size;
        }
        return 0;
    }

    public static <T> int sizeOf(Integer number, List<T> value, Function<T, Integer> sizeComputer) {
        if (value != null && value.size() > 0) {
            int size = 0;
            for (T element : value) {
                size += CodedOutputStream.computeTagSize((int)number);
                size += sizeComputer.apply(element).intValue();
            }
            return size;
        }
        return 0;
    }

    public static <K, V> int sizeOf(Integer number, Map<K, V> value, BiFunction<Integer, K, Integer> keySizeComputer, BiFunction<Integer, V, Integer> valueSizeComputer) {
        if (value != null && value.size() > 0) {
            int size = 0;
            for (Map.Entry<K, V> entry : value.entrySet()) {
                int entrySize = 0;
                size += CodedOutputStream.computeTagSize((int)number);
                entrySize += keySizeComputer.apply(1, entry.getKey()).intValue();
                entrySize += valueSizeComputer.apply(2, entry.getValue()).intValue();
                entrySize += CodedOutputStream.computeUInt32SizeNoTag((int)entrySize);
                size += entrySize;
            }
            return size;
        }
        return 0;
    }
}

