/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.grpc.serializer;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.WireFormat;
import io.dingodb.sdk.common.utils.Parameters;
import io.dingodb.sdk.service.entity.Message;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class Reader {
    public static int readNumber(CodedInputStream input) {
        return WireFormat.getTagFieldNumber((int)input.readTag());
    }

    public static boolean readBoolean(CodedInputStream input) {
        return input.readBool();
    }

    public static int readInt(CodedInputStream input) {
        return input.readInt32();
    }

    public static long readLong(CodedInputStream input) {
        return input.readInt64();
    }

    public static float readFloat(CodedInputStream input) {
        return input.readFloat();
    }

    public static double readDouble(CodedInputStream input) {
        return input.readDouble();
    }

    public static byte[] readBytes(CodedInputStream input) {
        return input.readByteArray();
    }

    public static String readString(CodedInputStream input) {
        return input.readString();
    }

    public static void skip(CodedInputStream input) {
        input.skipField(input.getLastTag());
    }

    public static <M extends Message> M readMessage(M message, CodedInputStream input) {
        if (message.isDirect()) {
            message.read(input);
            return message;
        }
        int length = input.readRawVarint32();
        input.checkRecursionLimit();
        int oldLimit = input.pushLimit(length);
        boolean hasValue = message.read(input);
        input.checkLastTagWas(0);
        if (input.getBytesUntilLimit() != 0) {
            throw new RuntimeException("The message " + String.valueOf(message.getClass()) + " not read finish.");
        }
        input.popLimit(oldLimit);
        return (M)(hasValue ? message : null);
    }

    public static <M extends Message> M readMessage(CodedInputStream input, Function<CodedInputStream, M> reader) {
        int length = input.readRawVarint32();
        int oldLimit = input.pushLimit(length);
        Message result = (Message)reader.apply(input);
        input.popLimit(oldLimit);
        return (M)result;
    }

    public static <T> List<T> readPack(CodedInputStream input, Function<CodedInputStream, T> reader) {
        ArrayList<T> result = new ArrayList<T>();
        int length = input.readRawVarint32();
        int oldLimit = input.pushLimit(length);
        while (input.getBytesUntilLimit() > 0) {
            result.add(reader.apply(input));
        }
        input.popLimit(oldLimit);
        return Collections.unmodifiableList(result);
    }

    public static <T> List<T> readList(List<T> current, CodedInputStream input, Function<CodedInputStream, T> reader) {
        current = Parameters.cleanNull(current, ArrayList::new);
        current.add(reader.apply(input));
        return current;
    }

    public static <K, V> Map<K, V> readMap(int number, Map<K, V> current, CodedInputStream input, Function<CodedInputStream, K> keyReader, Function<CodedInputStream, V> valueReader) {
        current = Parameters.cleanNull(current, HashMap::new);
        Map.Entry<K, V> entry = Reader.readMap(input, keyReader, valueReader);
        current.put(entry.getKey(), entry.getValue());
        return current;
    }

    public static <K, V> Map.Entry<K, V> readMap(CodedInputStream input, Function<CodedInputStream, K> keyReader, Function<CodedInputStream, V> valueReader) {
        int number;
        int length = input.readRawVarint32();
        int oldLimit = input.pushLimit(length);
        Object key = null;
        Object value = null;
        while ((number = Reader.readNumber(input)) != 0) {
            if (number == 1) {
                key = keyReader.apply(input);
            }
            if (number != 2) continue;
            value = valueReader.apply(input);
        }
        input.popLimit(oldLimit);
        return new AbstractMap.SimpleEntry<Object, Object>(key, value);
    }
}

