/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.grpc.serializer;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.service.entity.Message;
import io.grpc.MethodDescriptor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.function.Supplier;

public class Marshaller<T extends Message>
implements MethodDescriptor.Marshaller<T> {
    private final Supplier<T> supplier;

    public Marshaller(Supplier<T> supplier) {
        this.supplier = supplier;
    }

    public T newInstance() {
        return (T)((Message)this.supplier.get());
    }

    public InputStream stream(T value) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CodedOutputStream out = CodedOutputStream.newInstance((OutputStream)baos);
        value.write(out);
        out.flush();
        return new ByteArrayInputStream(baos.toByteArray());
    }

    public T parse(InputStream stream) {
        CodedInputStream inputStream = CodedInputStream.newInstance((InputStream)stream);
        T message = this.newInstance();
        message.read(inputStream);
        return message;
    }
}

