/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.common.vector;

import io.dingodb.sdk.common.index.VectorIndexParameter;

public class VectorIndexMetrics {
    private VectorIndexParameter.VectorIndexType vectorIndexType;
    private Long currentCount;
    private Long deletedCount;
    private Long maxId;
    private Long minId;
    private Long memoryBytes;

    public VectorIndexMetrics merge(VectorIndexMetrics other) {
        this.vectorIndexType = other.getVectorIndexType();
        this.currentCount = Long.sum(this.currentCount, other.currentCount);
        this.deletedCount = Long.sum(this.deletedCount, other.deletedCount);
        this.memoryBytes = Long.sum(this.memoryBytes, other.memoryBytes);
        this.maxId = Long.max(this.maxId, other.maxId);
        this.minId = Long.min(this.minId, other.maxId);
        return this;
    }

    public VectorIndexParameter.VectorIndexType getVectorIndexType() {
        return this.vectorIndexType;
    }

    public Long getCurrentCount() {
        return this.currentCount;
    }

    public Long getDeletedCount() {
        return this.deletedCount;
    }

    public Long getMaxId() {
        return this.maxId;
    }

    public Long getMinId() {
        return this.minId;
    }

    public Long getMemoryBytes() {
        return this.memoryBytes;
    }

    public VectorIndexMetrics(VectorIndexParameter.VectorIndexType vectorIndexType, Long currentCount, Long deletedCount, Long maxId, Long minId, Long memoryBytes) {
        this.vectorIndexType = vectorIndexType;
        this.currentCount = currentCount;
        this.deletedCount = deletedCount;
        this.maxId = maxId;
        this.minId = minId;
        this.memoryBytes = memoryBytes;
    }
}

