/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.common.vector;

import java.util.ArrayList;
import java.util.List;

public class Vector {
    private int dimension;
    private ValueType valueType;
    private List<Float> floatValues;
    private List<byte[]> binaryValues;

    public Vector() {
    }

    public Vector(int dimension, ValueType valueType, List<Float> floatValues, List<byte[]> binaryValues) {
        this.dimension = dimension;
        this.valueType = valueType;
        this.floatValues = floatValues;
        this.binaryValues = binaryValues;
    }

    public static Vector getFloatInstance(int dimension, List<Float> values) {
        return new Vector(dimension, ValueType.FLOAT, values, new ArrayList<byte[]>());
    }

    public static Vector getBinaryInstance(int dimension, List<byte[]> values) {
        return new Vector(dimension, ValueType.BINARY, new ArrayList<Float>(), values);
    }

    public int getDimension() {
        return this.dimension;
    }

    public ValueType getValueType() {
        return this.valueType;
    }

    public List<Float> getFloatValues() {
        return this.floatValues;
    }

    public List<byte[]> getBinaryValues() {
        return this.binaryValues;
    }

    public String toString() {
        return "Vector(dimension=" + this.getDimension() + ", valueType=" + String.valueOf((Object)this.getValueType()) + ", floatValues=" + String.valueOf(this.getFloatValues()) + ", binaryValues=" + String.valueOf(this.getBinaryValues()) + ")";
    }

    public static enum ValueType {
        FLOAT,
        BINARY;

    }
}

