/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.common.utils;

import io.dingodb.sdk.common.serial.schema.BitSchema;
import io.dingodb.sdk.common.serial.schema.BooleanListSchema;
import io.dingodb.sdk.common.serial.schema.BooleanSchema;
import io.dingodb.sdk.common.serial.schema.BytesSchema;
import io.dingodb.sdk.common.serial.schema.DecimalSchema;
import io.dingodb.sdk.common.serial.schema.DingoSchema;
import io.dingodb.sdk.common.serial.schema.DoubleListSchema;
import io.dingodb.sdk.common.serial.schema.DoubleSchema;
import io.dingodb.sdk.common.serial.schema.FloatListSchema;
import io.dingodb.sdk.common.serial.schema.FloatSchema;
import io.dingodb.sdk.common.serial.schema.IntegerListSchema;
import io.dingodb.sdk.common.serial.schema.IntegerSchema;
import io.dingodb.sdk.common.serial.schema.LongListSchema;
import io.dingodb.sdk.common.serial.schema.LongSchema;
import io.dingodb.sdk.common.serial.schema.StringListSchema;
import io.dingodb.sdk.common.serial.schema.StringSchema;
import io.dingodb.sdk.common.serial.schema.VectorSchema;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;

public class TypeSchemaMapper {
    private static final Map<String, Supplier<DingoSchema>> typeSchemaMap = new HashMap<String, Supplier<DingoSchema>>();

    public static synchronized void addScalaTypeSchemaMapping(String typeName, Supplier<DingoSchema> schemaSupplier) {
        if (typeSchemaMap.containsKey(typeName)) {
            throw new IllegalArgumentException("Adding existing " + typeName + " types is not supported");
        }
        typeSchemaMap.put(typeName, schemaSupplier);
    }

    public static synchronized void addCompoundTypeSchemaMapping(String typeName, String elementType, Supplier<DingoSchema> schemaSupplier) {
        String key = TypeSchemaMapper.getTypeName(typeName);
        String finalKey = TypeSchemaMapper.getFinalKey(key, elementType);
        if (typeSchemaMap.containsKey(finalKey)) {
            throw new IllegalArgumentException("Adding existing " + typeName + " types and elementType " + elementType + " is not supported");
        }
        typeSchemaMap.put(finalKey, schemaSupplier);
    }

    public static DingoSchema getSchemaForTypeName(String typeName, String elementType) {
        String key = TypeSchemaMapper.getTypeName(typeName);
        String finalKey = TypeSchemaMapper.getFinalKey(key, elementType);
        Supplier<DingoSchema> schemaSupplier = typeSchemaMap.get(finalKey);
        if (schemaSupplier == null) {
            throw new IllegalArgumentException("There is no schema mapping for " + typeName + " and " + elementType);
        }
        return schemaSupplier.get();
    }

    private static String getFinalKey(String typeName, String elementType) {
        if (elementType != null && !elementType.equals("")) {
            return typeName + ":" + elementType.toUpperCase();
        }
        return typeName;
    }

    private static String getTypeName(String typeName) {
        String key = typeName.toUpperCase();
        if (key.equals("ARRAY") || key.equals("LIST") || key.equals("MULTISET")) {
            key = "ARRAY";
        }
        return key;
    }

    public static boolean checkType(String typeName, String elementType) {
        String key = TypeSchemaMapper.getTypeName(typeName);
        String finalKey = TypeSchemaMapper.getFinalKey(key, elementType);
        return typeSchemaMap.containsKey(finalKey);
    }

    static {
        TypeSchemaMapper.addScalaTypeSchemaMapping("INT", IntegerSchema::new);
        TypeSchemaMapper.addScalaTypeSchemaMapping("INTEGER", IntegerSchema::new);
        TypeSchemaMapper.addScalaTypeSchemaMapping("TINYINT", IntegerSchema::new);
        TypeSchemaMapper.addScalaTypeSchemaMapping("LONG", LongSchema::new);
        TypeSchemaMapper.addScalaTypeSchemaMapping("BIGINT", LongSchema::new);
        TypeSchemaMapper.addScalaTypeSchemaMapping("BIT", BitSchema::new);
        TypeSchemaMapper.addScalaTypeSchemaMapping("BOOL", BooleanSchema::new);
        TypeSchemaMapper.addScalaTypeSchemaMapping("BOOLEAN", BooleanSchema::new);
        TypeSchemaMapper.addScalaTypeSchemaMapping("FLOAT", FloatSchema::new);
        TypeSchemaMapper.addScalaTypeSchemaMapping("DOUBLE", DoubleSchema::new);
        TypeSchemaMapper.addScalaTypeSchemaMapping("REAL", DoubleSchema::new);
        TypeSchemaMapper.addScalaTypeSchemaMapping("DECIMAL", DecimalSchema::new);
        TypeSchemaMapper.addScalaTypeSchemaMapping("STRING", StringSchema::new);
        TypeSchemaMapper.addScalaTypeSchemaMapping("CHAR", StringSchema::new);
        TypeSchemaMapper.addScalaTypeSchemaMapping("VARCHAR", StringSchema::new);
        TypeSchemaMapper.addScalaTypeSchemaMapping("DATE", LongSchema::new);
        TypeSchemaMapper.addScalaTypeSchemaMapping("TIME", LongSchema::new);
        TypeSchemaMapper.addScalaTypeSchemaMapping("TIMESTAMP", LongSchema::new);
        TypeSchemaMapper.addScalaTypeSchemaMapping("VECTOR", VectorSchema::new);
        TypeSchemaMapper.addScalaTypeSchemaMapping("BINARY", BytesSchema::new);
        TypeSchemaMapper.addScalaTypeSchemaMapping("BYTES", BytesSchema::new);
        TypeSchemaMapper.addScalaTypeSchemaMapping("VARBINARY", BytesSchema::new);
        TypeSchemaMapper.addScalaTypeSchemaMapping("BLOB", BytesSchema::new);
        TypeSchemaMapper.addScalaTypeSchemaMapping("MAP", BytesSchema::new);
        TypeSchemaMapper.addScalaTypeSchemaMapping("TUPLE", BytesSchema::new);
        TypeSchemaMapper.addScalaTypeSchemaMapping("DICT", BytesSchema::new);
        TypeSchemaMapper.addScalaTypeSchemaMapping("OBJECT", BytesSchema::new);
        TypeSchemaMapper.addScalaTypeSchemaMapping("ANY", BytesSchema::new);
        TypeSchemaMapper.addCompoundTypeSchemaMapping("ARRAY", "INT", IntegerListSchema::new);
        TypeSchemaMapper.addCompoundTypeSchemaMapping("ARRAY", "INTEGER", IntegerListSchema::new);
        TypeSchemaMapper.addCompoundTypeSchemaMapping("ARRAY", "TINYINT", IntegerListSchema::new);
        TypeSchemaMapper.addCompoundTypeSchemaMapping("ARRAY", "LONG", LongListSchema::new);
        TypeSchemaMapper.addCompoundTypeSchemaMapping("ARRAY", "BIGINT", LongListSchema::new);
        TypeSchemaMapper.addCompoundTypeSchemaMapping("ARRAY", "BOOL", BooleanListSchema::new);
        TypeSchemaMapper.addCompoundTypeSchemaMapping("ARRAY", "BOOLEAN", BooleanListSchema::new);
        TypeSchemaMapper.addCompoundTypeSchemaMapping("ARRAY", "FLOAT", FloatListSchema::new);
        TypeSchemaMapper.addCompoundTypeSchemaMapping("ARRAY", "DOUBLE", DoubleListSchema::new);
        TypeSchemaMapper.addCompoundTypeSchemaMapping("ARRAY", "REAL", DoubleListSchema::new);
        TypeSchemaMapper.addCompoundTypeSchemaMapping("ARRAY", "DECIMAL", StringListSchema::new);
        TypeSchemaMapper.addCompoundTypeSchemaMapping("ARRAY", "STRING", StringListSchema::new);
        TypeSchemaMapper.addCompoundTypeSchemaMapping("ARRAY", "CHAR", StringListSchema::new);
        TypeSchemaMapper.addCompoundTypeSchemaMapping("ARRAY", "VARCHAR", StringListSchema::new);
        TypeSchemaMapper.addCompoundTypeSchemaMapping("ARRAY", "DATE", LongListSchema::new);
        TypeSchemaMapper.addCompoundTypeSchemaMapping("ARRAY", "TIME", LongListSchema::new);
        TypeSchemaMapper.addCompoundTypeSchemaMapping("ARRAY", "TIMESTAMP", LongListSchema::new);
    }
}

