/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.common.utils;

import java.util.StringJoiner;

public final class StackTraces {
    public static final int CURRENT_STACK = 1;

    private StackTraces() {
    }

    public static String methodName() {
        return StackTraces.methodName(2);
    }

    public static String methodName(int stack) {
        return Thread.currentThread().getStackTrace()[1 + stack].getMethodName();
    }

    public static int lineNumber() {
        return StackTraces.lineNumber(2);
    }

    public static int lineNumber(int stack) {
        return Thread.currentThread().getStackTrace()[1 + stack].getLineNumber();
    }

    public static Class<?> clazz() throws ClassNotFoundException {
        return StackTraces.clazz(2);
    }

    public static Class<?> clazz(int stack) throws ClassNotFoundException {
        return Class.forName(StackTraces.className(stack + 1));
    }

    public static String className() {
        return StackTraces.className(2);
    }

    public static String className(int stack) {
        return Thread.currentThread().getStackTrace()[1 + stack].getClassName();
    }

    public static String fileName() {
        return StackTraces.fileName(2);
    }

    public static String fileName(int stack) {
        return Thread.currentThread().getStackTrace()[1 + stack].getFileName();
    }

    public static String packageName() {
        return StackTraces.packageName(2);
    }

    public static String packageName(int stack) {
        String className = StackTraces.className(stack);
        return className.substring(0, className.lastIndexOf(46));
    }

    public static String stack() {
        return StackTraces.stack(2);
    }

    public static String stack(int stack) {
        return String.format("%s.%s:%s", StackTraces.className(stack + 1), StackTraces.methodName(stack + 1), StackTraces.lineNumber(stack + 1));
    }

    public static String stackTrace() {
        return StackTraces.stackTrace(2, 0x7FFFFFFD);
    }

    public static String stackTrace(int stack, int deep) {
        return StackTraces.formatStackTrace(Thread.currentThread().getStackTrace(), stack, deep);
    }

    public static String formatStackTrace(StackTraceElement[] stackTrace, int stack, int deep) {
        StringJoiner joiner = new StringJoiner("\n    =======> ", "[\n    |||||||| ", "\n]");
        for (int i = deep = (deep += stack) < 0 ? stackTrace.length - 1 : Math.min(deep, stackTrace.length - 1); i > stack; --i) {
            joiner.add(stackTrace[i].toString());
        }
        return joiner.toString();
    }
}

