/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.common.utils;

import java.util.Collection;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Parameters {
    private static final Logger log = LoggerFactory.getLogger(Parameters.class);

    private Parameters() {
    }

    public static <T> @NonNull T nonNull(T input, String message) {
        return (T)Parameters.check(input, Objects::nonNull, () -> new NullPointerException(message));
    }

    public static <E, C extends Collection<E>> @NonNull C notEmpty(C input, String message) {
        return (C)Parameters.check(input, (T in) -> in != null && !in.isEmpty(), () -> new IllegalArgumentException(message));
    }

    public static <T> T check(T input, Predicate<T> checkFunction, String message) {
        return Parameters.check(input, checkFunction, () -> new IllegalArgumentException(message));
    }

    public static <T> T check(T input, Predicate<T> checkFunction, Supplier<RuntimeException> throwableSupplier) {
        Exception testEx = null;
        try {
            if (checkFunction.test(input)) {
                return input;
            }
        }
        catch (Exception e) {
            log.error("Run check function error, input is: --[{}]--, caller is [{}].", new Object[]{input, Thread.currentThread().getStackTrace()[2].getMethodName(), e});
            testEx = e;
        }
        RuntimeException exception = throwableSupplier.get();
        if (exception == null) {
            if (testEx == null) {
                log.warn("Run check function error, input is: --[{}]--, caller is [{}].", input, (Object)Thread.currentThread().getStackTrace()[2].getMethodName());
            } else {
                log.warn("Run check function error, but it is ignore, input is: --[{}]--, caller is [{}].", input, (Object)Thread.currentThread().getStackTrace()[2].getMethodName());
            }
            return input;
        }
        throw exception;
    }

    public static <T> T cleanNull(T input, T defaultValue) {
        return (T)Parameters.clean(input, Objects::nonNull, defaultValue);
    }

    public static <T> T cleanNull(T input, Supplier<T> valueSupplier) {
        return (T)Parameters.clean(input, Objects::nonNull, valueSupplier);
    }

    public static <T> T clean(T input, Predicate<T> checkFunction, Supplier<T> valueSupplier) {
        try {
            if (checkFunction.test(input)) {
                return input;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return valueSupplier.get();
    }

    public static <T> T clean(T input, Predicate<T> checkFunction, T defaultValue) {
        try {
            if (checkFunction.test(input)) {
                return input;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defaultValue;
    }
}

