/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.common.utils;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Optional<T> {
    private static final Logger log = LoggerFactory.getLogger(Optional.class);
    private java.util.Optional<T> optional;

    private Optional(java.util.Optional<T> optional) {
        this.optional = optional;
    }

    public static <T> Optional<T> of(java.util.Optional optional) {
        return new Optional<T>(optional);
    }

    public static <T> Optional<T> of(T value) {
        return Optional.of(java.util.Optional.of(value));
    }

    public static <T> Optional<T> ofNullable(T value) {
        return Optional.of(java.util.Optional.ofNullable(value));
    }

    public static <T> Optional<T> ofNullable(T value, Supplier<T> supplier) {
        if (value == null) {
            return Optional.of(supplier.get());
        }
        return Optional.of(java.util.Optional.ofNullable(value));
    }

    public static <T> void or(T value, Consumer<T> present) {
        if (value != null) {
            present.accept(value);
        }
    }

    public static <T> void or(T value, Consumer<T> present, Runnable absent) {
        if (value == null) {
            absent.run();
        } else {
            present.accept(value);
        }
    }

    public static void or(Object value, Runnable present, Runnable absent) {
        if (value == null) {
            absent.run();
        } else {
            present.run();
        }
    }

    public static <T> Optional<T> empty() {
        return Optional.of(java.util.Optional.empty());
    }

    public T get() {
        return this.optional.get();
    }

    public boolean isAbsent() {
        return !this.isPresent();
    }

    public boolean isPresent() {
        return this.optional.isPresent();
    }

    public Optional<T> ifPresent(Consumer<? super T> consumer) {
        this.optional.ifPresent(consumer);
        return this;
    }

    public Optional<T> ifPresent(Runnable runnable) {
        if (this.optional.isPresent()) {
            runnable.run();
        }
        return this;
    }

    public static <T> void ifPresent(T value, Runnable runnable) {
        if (value == null) {
            return;
        }
        runnable.run();
    }

    public static <T> void ifPresent(T value, Consumer<? super T> consumer) {
        if (value == null) {
            return;
        }
        consumer.accept(value);
    }

    public Optional<T> ifAbsent(Runnable runnable) {
        if (!this.optional.isPresent()) {
            runnable.run();
        }
        return this;
    }

    public void ifAbsentThrow(Supplier<RuntimeException> supplier) {
        if (!this.optional.isPresent()) {
            throw supplier.get();
        }
    }

    public Optional<T> ifAbsentSet(T other) {
        if (!this.optional.isPresent()) {
            this.optional = java.util.Optional.ofNullable(other);
        }
        return this;
    }

    public Optional<T> ifAbsentSet(Supplier<? extends T> other) {
        return this.ifAbsentSet(other.get());
    }

    public Optional<T> filter(Predicate<? super T> predicate) {
        return Optional.of(this.optional.filter(predicate));
    }

    public Optional<T> filter(Supplier<Boolean> predicate) {
        if (predicate.get().booleanValue()) {
            return this;
        }
        return Optional.empty();
    }

    public Optional<T> filter(boolean whether) {
        if (whether) {
            return this;
        }
        return Optional.empty();
    }

    public <U> Optional<U> map(Function<? super T, U> mapper) {
        return Optional.of(this.optional.map(mapper));
    }

    public <U> Optional<U> flatMap(Function<? super T, java.util.Optional<T>> mapper) {
        return Optional.of(this.optional.flatMap(mapper));
    }

    public <E extends Enum<E>> E orElse(E other) {
        return (E)this.optional.map((? super T __) -> (Enum)__).orElse(other);
    }

    public short orElse(short other) {
        return this.optional.map(Short.class::cast).orElse(other);
    }

    public int orElse(int other) {
        return this.optional.map(Integer.class::cast).orElse(other);
    }

    public long orElse(long other) {
        return this.optional.map(Long.class::cast).orElse(other);
    }

    public float orElse(float other) {
        return this.optional.map(Float.class::cast).orElse(Float.valueOf(other)).floatValue();
    }

    public double orElse(double other) {
        return this.optional.map(Double.class::cast).orElse(other);
    }

    public boolean orElse(boolean other) {
        return this.optional.map(Boolean.class::cast).orElse(other);
    }

    public char orElse(char other) {
        return this.optional.map(Character.class::cast).orElse(Character.valueOf(other)).charValue();
    }

    public String orElse(String other) {
        return this.optional.map(String.class::cast).orElse(other);
    }

    public <U> U mapOrNull(Function<? super T, U> mapper) {
        return this.optional.map(mapper).orElse(null);
    }

    public static <T, U> U mapOrNull(T value, Function<? super T, U> mapper) {
        return value == null ? null : (U)mapper.apply((T)value);
    }

    public <U> U mapOrGet(Function<? super T, U> mapper, Supplier<U> other) {
        return this.optional.map(mapper).orElseGet(other);
    }

    public static <T, U> U mapOrGet(T value, Function<? super T, ? extends U> mapper, Supplier<U> other) {
        return value == null ? other.get() : mapper.apply(value);
    }

    public static <T, U> U mapOrThrow(T value, Function<? super T, ? extends U> mapper, String message) {
        return Optional.mapOrThrow(value, mapper, () -> new RuntimeException(message));
    }

    public static <T, U, X extends Throwable> U mapOrThrow(T value, Function<? super T, ? extends U> mapper, Supplier<? extends X> exceptionSupplier) throws X {
        U result;
        if (value == null || (result = mapper.apply(value)) == null) {
            throw (Throwable)exceptionSupplier.get();
        }
        return result;
    }

    public T orNull() {
        return this.optional.orElse(null);
    }

    public T orElseGet(Supplier<? extends T> other) {
        return this.optional.orElseGet(other);
    }

    public T orElseThrow(String message) {
        return this.optional.orElseThrow(() -> new RuntimeException(message));
    }

    public <X extends Throwable> T orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
        return this.optional.orElseThrow(exceptionSupplier);
    }
}

