/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.common.utils;

import io.dingodb.sdk.common.utils.Optional;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class LinkedIterator<T>
implements Iterator<T> {
    private final List<Iterator<T>> iterators = new ArrayList<Iterator<T>>();
    private Iterator<T> currentIterator;
    private int position = 0;
    private boolean hasNext = true;

    public synchronized LinkedIterator<T> append(Iterator<T> iterator) {
        Optional.ifPresent(iterator, this.iterators::add);
        return this;
    }

    @Override
    public boolean hasNext() {
        if (!this.hasNext) {
            return false;
        }
        if (this.currentIterator == null || !this.currentIterator.hasNext()) {
            if (this.position < this.iterators.size()) {
                this.currentIterator = this.iterators.get(this.position++);
                return this.hasNext();
            }
            this.hasNext = false;
            return false;
        }
        return true;
    }

    @Override
    public T next() {
        if (this.hasNext()) {
            return this.currentIterator.next();
        }
        throw new NoSuchElementException();
    }
}

