/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.common.utils;

import java.util.Arrays;
import java.util.List;
import java.util.function.Function;

public final class ErrorCodeUtils {
    public static final List<Integer> refreshCode = Arrays.asList(10101, 60009, 60006, 60007, 60001, 60010);
    public static final List<Integer> retryCode = Arrays.asList(50000, 50002, 50003, 60002, 60008, 60003, 70019, 10110, 30201);
    public static final List<Integer> ignoreCode = Arrays.asList(30004, 30001);
    public static final Function<Integer, Strategy> errorToStrategyFunc = ErrorCodeUtils::errorToStrategy;

    private ErrorCodeUtils() {
    }

    public static Strategy errorToStrategy(int code) {
        if (ignoreCode.contains(code)) {
            return Strategy.IGNORE;
        }
        if (refreshCode.contains(code)) {
            return Strategy.REFRESH;
        }
        if (retryCode.contains(code)) {
            return Strategy.RETRY;
        }
        return Strategy.FAILED;
    }

    public static enum Strategy {
        FAILED,
        RETRY,
        REFRESH,
        IGNORE;

    }
}

