/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.common.utils;

import com.google.common.collect.Maps;
import com.google.protobuf.ByteString;
import io.dingodb.common.Common;
import io.dingodb.meta.Meta;
import io.dingodb.sdk.common.Context;
import io.dingodb.sdk.common.DingoClientException;
import io.dingodb.sdk.common.DingoCommonId;
import io.dingodb.sdk.common.KeyValue;
import io.dingodb.sdk.common.Location;
import io.dingodb.sdk.common.Range;
import io.dingodb.sdk.common.RangeWithOptions;
import io.dingodb.sdk.common.SDKCommonId;
import io.dingodb.sdk.common.cluster.Executor;
import io.dingodb.sdk.common.cluster.ExecutorMap;
import io.dingodb.sdk.common.cluster.ExecutorUser;
import io.dingodb.sdk.common.cluster.InternalCoordinator;
import io.dingodb.sdk.common.cluster.InternalExecutor;
import io.dingodb.sdk.common.cluster.InternalExecutorMap;
import io.dingodb.sdk.common.cluster.InternalExecutorUser;
import io.dingodb.sdk.common.cluster.InternalRegion;
import io.dingodb.sdk.common.cluster.InternalStore;
import io.dingodb.sdk.common.codec.CodecUtils;
import io.dingodb.sdk.common.codec.DingoKeyValueCodec;
import io.dingodb.sdk.common.codec.KeyValueCodec;
import io.dingodb.sdk.common.index.BruteForceParam;
import io.dingodb.sdk.common.index.DiskAnnParam;
import io.dingodb.sdk.common.index.FlatParam;
import io.dingodb.sdk.common.index.HnswParam;
import io.dingodb.sdk.common.index.Index;
import io.dingodb.sdk.common.index.IndexDefinition;
import io.dingodb.sdk.common.index.IndexMetrics;
import io.dingodb.sdk.common.index.IndexParameter;
import io.dingodb.sdk.common.index.IvfFlatParam;
import io.dingodb.sdk.common.index.IvfPqParam;
import io.dingodb.sdk.common.index.ScalarIndexParameter;
import io.dingodb.sdk.common.index.VectorIndexParameter;
import io.dingodb.sdk.common.partition.Partition;
import io.dingodb.sdk.common.partition.PartitionDetail;
import io.dingodb.sdk.common.partition.PartitionDetailDefinition;
import io.dingodb.sdk.common.partition.PartitionRule;
import io.dingodb.sdk.common.region.RegionEpoch;
import io.dingodb.sdk.common.region.RegionHeartbeatState;
import io.dingodb.sdk.common.region.RegionState;
import io.dingodb.sdk.common.region.RegionStatus;
import io.dingodb.sdk.common.serial.schema.DingoSchema;
import io.dingodb.sdk.common.serial.schema.LongSchema;
import io.dingodb.sdk.common.serial.schema.Type;
import io.dingodb.sdk.common.table.Column;
import io.dingodb.sdk.common.table.ColumnDefinition;
import io.dingodb.sdk.common.table.RangeDistribution;
import io.dingodb.sdk.common.table.Table;
import io.dingodb.sdk.common.table.TableDefinition;
import io.dingodb.sdk.common.table.metric.TableMetrics;
import io.dingodb.sdk.common.utils.ByteArrayUtils;
import io.dingodb.sdk.common.utils.NoBreakFunctions;
import io.dingodb.sdk.common.utils.Optional;
import io.dingodb.sdk.common.utils.Parameters;
import io.dingodb.sdk.common.vector.ScalarField;
import io.dingodb.sdk.common.vector.ScalarValue;
import io.dingodb.sdk.common.vector.Vector;
import io.dingodb.sdk.common.vector.VectorIndexMetrics;
import io.dingodb.sdk.common.vector.VectorTableData;
import io.dingodb.sdk.common.vector.VectorWithDistance;
import io.dingodb.sdk.common.vector.VectorWithId;
import io.dingodb.sdk.service.store.AggregationOperator;
import io.dingodb.sdk.service.store.Coprocessor;
import io.dingodb.store.Store;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class EntityConversion {
    public static final LongSchema SCHEMA = new LongSchema(0);

    public static Meta.TableDefinition mapping(Table table2, Meta.DingoCommonId tableId, List<Meta.DingoCommonId> partitionIds) {
        Optional.ofNullable(table2.getColumns()).filter(__ -> __.stream().map(Column::getName).distinct().count() == (long)__.size()).orElseThrow(() -> new DingoClientException("Table field names cannot be repeated."));
        List columnDefinitions = table2.getColumns().stream().map(EntityConversion::mapping).collect(Collectors.toList());
        return Meta.TableDefinition.newBuilder().setName(table2.getName().toUpperCase()).setVersion(table2.getVersion()).setTtl(table2.getTtl()).setTablePartition(EntityConversion.calcRange(table2, tableId, partitionIds)).setEngine(Common.Engine.valueOf(table2.getEngine())).setReplica(table2.getReplica()).addAllColumns(columnDefinitions).setAutoIncrement(table2.getAutoIncrement()).putAllProperties(table2.getProperties() == null ? new HashMap() : table2.getProperties()).setCreateSql(Parameters.cleanNull(table2.getCreateSql(), "")).setIndexParameter(Optional.mapOrGet(table2.getIndexParameter(), EntityConversion::mapping, () -> Common.IndexParameter.newBuilder().build())).setComment(Parameters.cleanNull(table2.getComment(), "")).setCharset(Parameters.cleanNull(table2.getCharset(), "utf8")).setCollate(Parameters.cleanNull(table2.getCollate(), "utf8_bin")).setTableType(Parameters.cleanNull(table2.getTableType(), "BASE TABLE")).setRowFormat(Parameters.cleanNull(table2.getRowFormat(), "Dynamic")).build();
    }

    public static Table mapping(Meta.TableDefinitionWithId tableDefinitionWithId) {
        Meta.TableDefinition tableDefinition = tableDefinitionWithId.getTableDefinition();
        List<Column> columns = tableDefinition.getColumnsList().stream().map(EntityConversion::mapping).collect(Collectors.toList());
        return TableDefinition.builder().name(tableDefinition.getName()).columns(columns).version(tableDefinition.getVersion()).ttl((int)tableDefinition.getTtl()).engine(tableDefinition.getEngine().name()).properties(tableDefinition.getPropertiesMap()).partition(EntityConversion.mapping(tableDefinitionWithId.getTableId().getEntityId(), tableDefinition, columns)).replica(tableDefinition.getReplica()).autoIncrement(tableDefinition.getAutoIncrement()).createSql(tableDefinition.getCreateSql()).indexParameter(Optional.mapOrNull(tableDefinition.getIndexParameter(), EntityConversion::mapping)).comment(tableDefinition.getComment()).charset(Parameters.cleanNull(tableDefinition.getCharset(), "utf8")).collate(Parameters.cleanNull(tableDefinition.getCollate(), "utf8_bin")).tableType(Parameters.cleanNull(tableDefinition.getTableType(), "BASE TABLE")).rowFormat(Parameters.cleanNull(tableDefinition.getRowFormat(), "Dynamic")).createTime(tableDefinition.getCreateTimestamp()).updateTime(tableDefinition.getUpdateTimestamp()).build();
    }

    public static Partition mapping(long id, Meta.TableDefinition tableDefinition, List<Column> columns) {
        Meta.PartitionRule partition = tableDefinition.getTablePartition();
        if (partition.getPartitionsCount() < 1) {
            return null;
        }
        DingoKeyValueCodec codec = DingoKeyValueCodec.of(tableDefinition.getCodecVersion(), id, columns);
        List<PartitionDetail> details = partition.getPartitionsList().stream().map(Meta.Partition::getRange).map(Common.Range::getStartKey).map(ByteString::toByteArray).map(__ -> codec.resetPrefix((byte[])__, id)).sorted(ByteArrayUtils::compare).skip(1L).map(NoBreakFunctions.wrap(codec::decodeKeyPrefix)).map(key -> new PartitionDetailDefinition((Object)null, null, (Object[])key)).collect(Collectors.toList());
        return new PartitionRule(EntityConversion.getStrategy(partition.getStrategy()), (List<String>)partition.getColumnsList(), details);
    }

    public static Column mapping(Meta.ColumnDefinition definition) {
        return ColumnDefinition.builder().name(definition.getName()).type(definition.getSqlType()).elementType(definition.getElementType()).precision(definition.getPrecision()).scale(definition.getScale()).nullable(definition.getNullable()).primary(definition.getIndexOfKey()).defaultValue(definition.getDefaultVal()).isAutoIncrement(definition.getIsAutoIncrement()).state(definition.getState() == 0 ? 1 : definition.getState()).comment(definition.getComment()).build();
    }

    public static TableMetrics mapping(Meta.TableMetrics metrics) {
        return new TableMetrics(metrics.getMinKey().toByteArray(), metrics.getMaxKey().toByteArray(), metrics.getRowsCount(), metrics.getPartCount());
    }

    public static KeyValue mapping(Common.KeyValue keyValue) {
        return new KeyValue(keyValue.getKey().toByteArray(), keyValue.getValue().toByteArray());
    }

    public static Common.KeyValue mapping(KeyValue keyValue) {
        return Common.KeyValue.newBuilder().setKey(ByteString.copyFrom((byte[])keyValue.getKey())).setValue(ByteString.copyFrom((byte[])keyValue.getValue())).build();
    }

    public static Store.Context mapping(Context context) {
        return Store.Context.newBuilder().setRegionId(context.getRegionId().entityId()).setRegionEpoch(EntityConversion.mapping(context.getRegionEpoch())).build();
    }

    public static RangeDistribution mapping(Meta.RangeDistribution rangeDistribution) {
        return new RangeDistribution(EntityConversion.mapping(rangeDistribution.getId()), EntityConversion.mapping(rangeDistribution.getRange()), EntityConversion.mapping(rangeDistribution.getLeader()), rangeDistribution.getVotersList().stream().map(EntityConversion::mapping).collect(Collectors.toList()), EntityConversion.mapping(rangeDistribution.getRegionEpoch()), EntityConversion.mapping(rangeDistribution.getStatus()));
    }

    public static RegionEpoch mapping(Common.RegionEpoch regionEpoch) {
        return new RegionEpoch(regionEpoch.getConfVersion(), regionEpoch.getVersion());
    }

    public static Common.RegionEpoch mapping(RegionEpoch regionEpoch) {
        return Common.RegionEpoch.newBuilder().setConfVersion(regionEpoch.getConfVersion()).setVersion(regionEpoch.getVersion()).build();
    }

    public static RegionStatus mapping(Meta.RegionStatus status) {
        return new RegionStatus(RegionState.valueOf(status.getState().name()), RegionHeartbeatState.valueOf(status.getHeartbeatState().name()));
    }

    public static Location mapping(Common.Location location) {
        return new Location(location.getHost(), location.getPort());
    }

    public static Common.Location mapping(Location location) {
        return Common.Location.newBuilder().setHost(location.getHost()).setPort(location.getPort()).build();
    }

    public static Range mapping(Common.Range range) {
        return new Range(range.getStartKey().toByteArray(), range.getEndKey().toByteArray());
    }

    public static Common.Range mapping(Range range) {
        return Common.Range.newBuilder().setStartKey(ByteString.copyFrom((byte[])range.getStartKey())).setEndKey(ByteString.copyFrom((byte[])range.getEndKey())).build();
    }

    public static RangeWithOptions mapping(Common.RangeWithOptions options) {
        return new RangeWithOptions(EntityConversion.mapping(options.getRange()), options.getWithStart(), options.getWithEnd());
    }

    public static Common.RangeWithOptions mapping(RangeWithOptions options) {
        return Common.RangeWithOptions.newBuilder().setRange(EntityConversion.mapping(options.getRange())).setWithStart(options.isWithStart()).setWithEnd(options.isWithEnd()).build();
    }

    public static Meta.DingoCommonId mapping(DingoCommonId commonId) {
        return Meta.DingoCommonId.newBuilder().setEntityType(Meta.EntityType.valueOf(commonId.type().name())).setParentEntityId(commonId.parentId()).setEntityId(commonId.entityId()).build();
    }

    public static DingoCommonId mapping(Meta.DingoCommonId commonId) {
        return new SDKCommonId(DingoCommonId.Type.valueOf(commonId.getEntityType().name()), commonId.getParentEntityId(), commonId.getEntityId());
    }

    public static Common.Executor mapping(Executor executor) {
        return Common.Executor.newBuilder().setServerLocation(EntityConversion.mapping(executor.serverLocation())).setExecutorUser(EntityConversion.mapping(executor.executorUser())).build();
    }

    public static Executor mapping(Common.Executor executor) {
        return new InternalExecutor(EntityConversion.mapping(executor.getServerLocation()), EntityConversion.mapping(executor.getExecutorUser()), executor.getResourceTag());
    }

    public static Common.ExecutorUser mapping(ExecutorUser executorUser) {
        return Common.ExecutorUser.newBuilder().setUser(executorUser.getUser()).setKeyring(executorUser.getKeyring()).build();
    }

    public static ExecutorUser mapping(Common.ExecutorUser executorUser) {
        return new InternalExecutorUser(executorUser.getUser(), executorUser.getKeyring());
    }

    public static ExecutorMap mapping(Common.ExecutorMap executorMap) {
        return new InternalExecutorMap(executorMap.getEpoch(), executorMap.getExecutorsList().stream().map(EntityConversion::mapping).collect(Collectors.toList()));
    }

    public static Index mapping(long id, Meta.IndexDefinition definition) {
        return new IndexDefinition(definition.getName(), definition.getVersion(), EntityConversion.mapping(id, definition.getIndexPartition()), definition.getReplica(), EntityConversion.mapping(definition.getIndexParameter()), definition.getWithAutoIncrment(), definition.getAutoIncrement());
    }

    public static PartitionRule mapping(long id, Meta.PartitionRule partition) {
        if (partition.getPartitionsCount() < 1) {
            return null;
        }
        SCHEMA.setIsKey(true);
        SCHEMA.setAllowNull(false);
        DingoKeyValueCodec codec = new DingoKeyValueCodec(id, Collections.singletonList(SCHEMA));
        List<PartitionDetail> details = partition.getPartitionsList().stream().map(Meta.Partition::getRange).map(Common.Range::getStartKey).map(ByteString::toByteArray).map(__ -> codec.resetPrefix((byte[])__, id)).sorted(ByteArrayUtils::compare).skip(1L).map(codec::decodeKeyPrefix).map(key -> new PartitionDetailDefinition((Object)"", "", (Object[])key)).collect(Collectors.toList());
        return new PartitionRule(EntityConversion.getStrategy(partition.getStrategy()), (List<String>)partition.getColumnsList(), details);
    }

    private static String getStrategy(Meta.PartitionStrategy partitionStrategy) {
        String strategy = partitionStrategy == Meta.PartitionStrategy.PT_STRATEGY_HASH ? "HASH" : "RANGE";
        return strategy;
    }

    private static void getStrategy(Partition partition, Meta.PartitionRule.Builder builder) {
        if (partition != null && partition.getFuncName() != null) {
            if (partition.getFuncName().equalsIgnoreCase("HASH")) {
                builder.setStrategy(Meta.PartitionStrategy.PT_STRATEGY_HASH);
            } else {
                builder.setStrategy(Meta.PartitionStrategy.PT_STRATEGY_RANGE);
            }
        }
    }

    public static Meta.IndexDefinition mapping(long id, Index index, List<Meta.DingoCommonId> partitionIds) {
        SCHEMA.setIsKey(true);
        SCHEMA.setAllowNull(false);
        DingoKeyValueCodec codec = new DingoKeyValueCodec(id, Collections.singletonList(SCHEMA));
        Iterator keys = Optional.mapOrGet(index.getIndexPartition(), __ -> EntityConversion.encodePartitionDetails(__.getDetails(), codec), Stream::empty).sorted(ByteArrayUtils::compare).iterator();
        Meta.PartitionRule.Builder builder = Meta.PartitionRule.newBuilder();
        byte[] start = codec.encodeMinKeyPrefix();
        for (Meta.DingoCommonId commonId : partitionIds) {
            builder.addPartitions(Meta.Partition.newBuilder().setId(commonId).setRange(Common.Range.newBuilder().setStartKey(ByteString.copyFrom((byte[])codec.resetPrefix(start, commonId.getEntityId()))).setEndKey(ByteString.copyFrom((byte[])codec.resetPrefix(codec.encodeMaxKeyPrefix(), commonId.getEntityId() + 1L))).build()).build());
            start = keys.hasNext() ? (byte[])keys.next() : start;
        }
        EntityConversion.getStrategy(index.getIndexPartition(), builder);
        return Meta.IndexDefinition.newBuilder().setName(index.getName()).setVersion(index.getVersion()).setIndexPartition(builder.build()).setReplica(index.getReplica()).setIndexParameter(EntityConversion.mapping(index.getIndexParameter())).setWithAutoIncrment(index.getIsAutoIncrement()).setAutoIncrement(index.getAutoIncrement()).build();
    }

    public static IndexParameter mapping(Common.IndexParameter parameter) {
        if (parameter.getIndexType() == Common.IndexType.INDEX_TYPE_VECTOR) {
            Common.VectorIndexParameter vectorParam = parameter.getVectorIndexParameter();
            switch (vectorParam.getVectorIndexType()) {
                case VECTOR_INDEX_TYPE_FLAT: {
                    Common.CreateFlatParam flatParam = vectorParam.getFlatParameter();
                    return new IndexParameter(IndexParameter.IndexType.valueOf(parameter.getIndexType().name()), new VectorIndexParameter(VectorIndexParameter.VectorIndexType.VECTOR_INDEX_TYPE_FLAT, new FlatParam(flatParam.getDimension(), VectorIndexParameter.MetricType.valueOf(flatParam.getMetricType().name()))));
                }
                case VECTOR_INDEX_TYPE_IVF_FLAT: {
                    Common.CreateIvfFlatParam ivfFlatParam = vectorParam.getIvfFlatParameter();
                    return new IndexParameter(IndexParameter.IndexType.valueOf(parameter.getIndexType().name()), new VectorIndexParameter(VectorIndexParameter.VectorIndexType.VECTOR_INDEX_TYPE_IVF_FLAT, new IvfFlatParam(ivfFlatParam.getDimension(), VectorIndexParameter.MetricType.valueOf(ivfFlatParam.getMetricType().name()), ivfFlatParam.getNcentroids())));
                }
                case VECTOR_INDEX_TYPE_IVF_PQ: {
                    Common.CreateIvfPqParam pqParam = vectorParam.getIvfPqParameter();
                    return new IndexParameter(IndexParameter.IndexType.valueOf(parameter.getIndexType().name()), new VectorIndexParameter(VectorIndexParameter.VectorIndexType.VECTOR_INDEX_TYPE_IVF_PQ, new IvfPqParam(pqParam.getDimension(), VectorIndexParameter.MetricType.valueOf(pqParam.getMetricType().name()), pqParam.getNcentroids(), pqParam.getNsubvector(), pqParam.getBucketInitSize(), pqParam.getBucketMaxSize(), pqParam.getNbitsPerIdx())));
                }
                case VECTOR_INDEX_TYPE_HNSW: {
                    Common.CreateHnswParam hnswParam = vectorParam.getHnswParameter();
                    return new IndexParameter(IndexParameter.IndexType.valueOf(parameter.getIndexType().name()), new VectorIndexParameter(VectorIndexParameter.VectorIndexType.VECTOR_INDEX_TYPE_HNSW, new HnswParam(hnswParam.getDimension(), VectorIndexParameter.MetricType.valueOf(hnswParam.getMetricType().name()), hnswParam.getEfConstruction(), hnswParam.getMaxElements(), hnswParam.getNlinks())));
                }
                case VECTOR_INDEX_TYPE_DISKANN: {
                    Common.CreateDiskAnnParam annParam = vectorParam.getDiskannParameter();
                    return new IndexParameter(IndexParameter.IndexType.valueOf(parameter.getIndexType().name()), new VectorIndexParameter(VectorIndexParameter.VectorIndexType.VECTOR_INDEX_TYPE_DISKANN, new DiskAnnParam(annParam.getDimension(), VectorIndexParameter.MetricType.valueOf(annParam.getMetricType().name()))));
                }
                case VECTOR_INDEX_TYPE_BRUTEFORCE: {
                    Common.CreateBruteForceParam bruteForceParam = vectorParam.getBruteforceParameter();
                    return new IndexParameter(IndexParameter.IndexType.valueOf(parameter.getIndexType().name()), new VectorIndexParameter(VectorIndexParameter.VectorIndexType.VECTOR_INDEX_TYPE_BRUTEFORCE, new BruteForceParam(bruteForceParam.getDimension(), VectorIndexParameter.MetricType.valueOf(bruteForceParam.getMetricType().name()))));
                }
            }
            throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)vectorParam.getVectorIndexType()));
        }
        if (parameter.getIndexType() == Common.IndexType.INDEX_TYPE_SCALAR) {
            Common.ScalarIndexParameter scalarParam = parameter.getScalarIndexParameter();
            return new IndexParameter(IndexParameter.IndexType.valueOf(parameter.getIndexType().name()), new ScalarIndexParameter(ScalarIndexParameter.ScalarIndexType.valueOf(scalarParam.getScalarIndexType().name()), scalarParam.getIsUnique()));
        }
        return null;
    }

    public static Common.IndexParameter mapping(IndexParameter parameter) {
        Common.IndexParameter.Builder builder = Common.IndexParameter.newBuilder();
        if (parameter.getIndexType().equals((Object)IndexParameter.IndexType.INDEX_TYPE_VECTOR)) {
            VectorIndexParameter vectorParameter = parameter.getVectorIndexParameter();
            Common.VectorIndexParameter.Builder build = Common.VectorIndexParameter.newBuilder().setVectorIndexType(Common.VectorIndexType.valueOf(vectorParameter.getVectorIndexType().name()));
            switch (vectorParameter.getVectorIndexType()) {
                case VECTOR_INDEX_TYPE_FLAT: {
                    build.setFlatParameter(Common.CreateFlatParam.newBuilder().setDimension(vectorParameter.getFlatParam().getDimension()).setMetricType(Common.MetricType.valueOf(vectorParameter.getFlatParam().getMetricType().name())).build());
                    break;
                }
                case VECTOR_INDEX_TYPE_IVF_FLAT: {
                    IvfFlatParam ivfFlatParam = vectorParameter.getIvfFlatParam();
                    build.setIvfFlatParameter(Common.CreateIvfFlatParam.newBuilder().setDimension(ivfFlatParam.getDimension()).setMetricType(Common.MetricType.valueOf(ivfFlatParam.getMetricType().name())).setNcentroids(ivfFlatParam.getNcentroids()).build());
                    break;
                }
                case VECTOR_INDEX_TYPE_IVF_PQ: {
                    IvfPqParam ivfPqParam = vectorParameter.getIvfPqParam();
                    build.setIvfPqParameter(Common.CreateIvfPqParam.newBuilder().setDimension(ivfPqParam.getDimension()).setMetricType(Common.MetricType.valueOf(ivfPqParam.getMetricType().name())).setNcentroids(ivfPqParam.getNcentroids()).setBucketInitSize(ivfPqParam.getBucketInitSize()).setBucketMaxSize(ivfPqParam.getBucketMaxSize()).setNbitsPerIdx(ivfPqParam.getNbitsPerIdx()).setNsubvector(ivfPqParam.getNsubvector()).build());
                    break;
                }
                case VECTOR_INDEX_TYPE_HNSW: {
                    HnswParam hnswParam = vectorParameter.getHnswParam();
                    build.setHnswParameter(Common.CreateHnswParam.newBuilder().setDimension(hnswParam.getDimension()).setMetricType(Common.MetricType.valueOf(hnswParam.getMetricType().name())).setEfConstruction(hnswParam.getEfConstruction()).setMaxElements(hnswParam.getMaxElements()).setNlinks(hnswParam.getNlinks()).build());
                    break;
                }
                case VECTOR_INDEX_TYPE_DISKANN: {
                    DiskAnnParam diskAnnParam = vectorParameter.getDiskAnnParam();
                    build.setDiskannParameter(Common.CreateDiskAnnParam.newBuilder().setDimension(diskAnnParam.getDimension()).setMetricType(Common.MetricType.valueOf(diskAnnParam.getMetricType().name())).build());
                    break;
                }
                case VECTOR_INDEX_TYPE_BRUTEFORCE: {
                    BruteForceParam bruteForceParam = vectorParameter.getBruteForceParam();
                    build.setBruteforceParameter(Common.CreateBruteForceParam.newBuilder().setDimension(bruteForceParam.getDimension()).setMetricType(Common.MetricType.valueOf(bruteForceParam.getMetricType().name())).build());
                }
            }
            builder.setVectorIndexParameter(build.build());
        } else {
            ScalarIndexParameter scalarParameter = parameter.getScalarIndexParameter();
            Common.ScalarIndexParameter scalarIndexParameter = Common.ScalarIndexParameter.newBuilder().setScalarIndexType(Common.ScalarIndexType.valueOf(scalarParameter.getScalarIndexType().name())).setIsUnique(scalarParameter.isUnique()).build();
            builder.setScalarIndexParameter(scalarIndexParameter);
        }
        return builder.setIndexType(Common.IndexType.valueOf(parameter.getIndexType().name())).build();
    }

    public static Common.VectorWithId mapping(VectorWithId withId) {
        Common.VectorWithId.Builder builder = Common.VectorWithId.newBuilder().setId(withId.getId());
        if (withId.getVector() != null) {
            Vector vector = withId.getVector();
            builder.setVector(EntityConversion.mapping(vector));
        }
        if (withId.getScalarData() != null) {
            builder.setScalarData(EntityConversion.mapping(withId.getScalarData()));
        }
        if (withId.getTableData() != null) {
            VectorTableData tableData = withId.getTableData();
            builder.setTableData(Common.VectorTableData.newBuilder().setTableKey(ByteString.copyFrom((byte[])tableData.getKey())).setTableValue(ByteString.copyFrom((byte[])tableData.getValue())).build());
        }
        return builder.build();
    }

    public static Common.Vector mapping(Vector vector) {
        return Common.Vector.newBuilder().setDimension(vector.getDimension()).setValueType(Common.ValueType.valueOf(vector.getValueType().name())).addAllFloatValues(vector.getFloatValues()).addAllBinaryValues(vector.getBinaryValues().stream().map(ByteString::copyFrom).collect(Collectors.toList())).build();
    }

    public static Vector mapping(Common.Vector vector) {
        return new Vector(vector.getDimension(), Vector.ValueType.valueOf(vector.getValueType().name()), vector.getFloatValuesList(), vector.getBinaryValuesList().stream().map(ByteString::toByteArray).collect(Collectors.toList()));
    }

    public static Common.VectorScalardata mapping(Map<String, ScalarValue> scalarData) {
        return Common.VectorScalardata.newBuilder().putAllScalarData(scalarData.entrySet().stream().collect(Maps::newHashMap, (map, entry) -> map.put((String)entry.getKey(), EntityConversion.mapping((ScalarValue)entry.getValue())), Map::putAll)).build();
    }

    public static VectorWithId mapping(Common.VectorWithId withId) {
        Common.Vector vector = withId.getVector();
        return new VectorWithId(withId.getId(), EntityConversion.mapping(vector), withId.getScalarData().getScalarDataMap().entrySet().stream().collect(Maps::newHashMap, (map, entry) -> map.put((String)entry.getKey(), EntityConversion.mapping((Common.ScalarValue)entry.getValue())), Map::putAll), new VectorTableData(withId.getTableData().getTableKey().toByteArray(), withId.getTableData().getTableValue().toByteArray()));
    }

    public static IndexMetrics mapping(Meta.IndexMetrics metrics) {
        return new IndexMetrics(metrics.getRowsCount(), metrics.getMinKey().toByteArray(), metrics.getMaxKey().toByteArray(), metrics.getPartCount(), VectorIndexParameter.VectorIndexType.valueOf(metrics.getVectorIndexType().name()), metrics.getCurrentCount(), metrics.getDeletedCount(), metrics.getMaxId(), metrics.getMinId(), metrics.getMemoryBytes());
    }

    public static VectorIndexMetrics mapping(Common.VectorIndexMetrics metrics) {
        return new VectorIndexMetrics(VectorIndexParameter.VectorIndexType.valueOf(metrics.getVectorIndexType().name()), metrics.getCurrentCount(), metrics.getDeletedCount(), metrics.getMaxId(), metrics.getMinId(), metrics.getMemoryBytes());
    }

    public static ScalarValue mapping(Common.ScalarValue value) {
        return new ScalarValue(ScalarValue.ScalarFieldType.valueOf(value.getFieldType().name()), value.getFieldsList().stream().map(f -> EntityConversion.mapping(f, value.getFieldType())).collect(Collectors.toList()));
    }

    public static ScalarField mapping(Common.ScalarField field, Common.ScalarFieldType type) {
        switch (type) {
            case BOOL: {
                return new ScalarField(field.getBoolData());
            }
            case INT8: 
            case INT16: 
            case INT32: {
                return new ScalarField(field.getIntData());
            }
            case INT64: {
                return new ScalarField(field.getLongData());
            }
            case FLOAT32: {
                return new ScalarField(Float.valueOf(field.getFloatData()));
            }
            case DOUBLE: {
                return new ScalarField(field.getDoubleData());
            }
            case STRING: {
                return new ScalarField(field.getStringData());
            }
            case BYTES: {
                return new ScalarField(field.getBytesData().toByteArray());
            }
        }
        throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)type));
    }

    public static Common.ScalarValue mapping(ScalarValue value) {
        return Common.ScalarValue.newBuilder().setFieldType(Common.ScalarFieldType.valueOf(value.getFieldType().name())).addAllFields(value.getFields().stream().map(f -> EntityConversion.mapping(f, value.getFieldType())).collect(Collectors.toList())).build();
    }

    public static Common.ScalarField mapping(ScalarField field, ScalarValue.ScalarFieldType type) {
        switch (type) {
            case BOOL: {
                return Common.ScalarField.newBuilder().setBoolData((Boolean)field.getData()).build();
            }
            case INTEGER: {
                return Common.ScalarField.newBuilder().setIntData((Integer)field.getData()).build();
            }
            case LONG: {
                return Common.ScalarField.newBuilder().setLongData((Long)field.getData()).build();
            }
            case FLOAT: {
                return Common.ScalarField.newBuilder().setFloatData(((Float)field.getData()).floatValue()).build();
            }
            case DOUBLE: {
                return Common.ScalarField.newBuilder().setDoubleData((Double)field.getData()).build();
            }
            case STRING: {
                return Common.ScalarField.newBuilder().setStringData(field.getData().toString()).build();
            }
            case BYTES: {
                return Common.ScalarField.newBuilder().setBytesData(ByteString.copyFromUtf8((String)field.getData().toString())).build();
            }
        }
        throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)type));
    }

    public static VectorWithDistance mapping(Common.VectorWithDistance distance) {
        return new VectorWithDistance(EntityConversion.mapping(distance.getVectorWithId()), distance.getDistance(), VectorIndexParameter.MetricType.valueOf(distance.getMetricType().name()));
    }

    public static Common.CoprocessorV2 mapping(Coprocessor coprocessor, long partId) {
        Common.CoprocessorV2.SchemaWrapper schemaWrapper = Common.CoprocessorV2.SchemaWrapper.newBuilder().addAllSchema(EntityConversion.mapping(coprocessor.getOriginalSchema())).setCommonId(partId).build();
        return Common.CoprocessorV2.newBuilder().setSchemaVersion(coprocessor.getSchemaVersion()).setOriginalSchema(schemaWrapper).addAllSelectionColumns(Parameters.cleanNull(coprocessor.getSelection(), Collections.emptyList())).setRelExpr(ByteString.copyFrom((byte[])Parameters.cleanNull(coprocessor.getExpression(), ByteArrayUtils.EMPTY_BYTES))).build();
    }

    public static List<Common.Schema> mapping(Coprocessor.SchemaWrapper schemaWrapper) {
        if (schemaWrapper == null) {
            return Collections.emptyList();
        }
        return CodecUtils.createSchemaForColumns(schemaWrapper.getSchemas()).stream().map(schema -> Common.Schema.newBuilder().setType(switch (schema.getType()) {
            case Type.BOOLEAN -> Common.Schema.Type.BOOL;
            case Type.INTEGER -> Common.Schema.Type.INTEGER;
            case Type.FLOAT -> Common.Schema.Type.FLOAT;
            case Type.LONG -> Common.Schema.Type.LONG;
            case Type.DOUBLE -> Common.Schema.Type.DOUBLE;
            case Type.BYTES, Type.STRING -> Common.Schema.Type.STRING;
            case Type.BOOLEANLIST -> Common.Schema.Type.BOOLLIST;
            case Type.INTEGERLIST -> Common.Schema.Type.INTEGERLIST;
            case Type.FLOATLIST -> Common.Schema.Type.FLOATLIST;
            case Type.LONGLIST -> Common.Schema.Type.LONGLIST;
            case Type.DOUBLELIST -> Common.Schema.Type.DOUBLELIST;
            case Type.STRINGLIST -> Common.Schema.Type.STRINGLIST;
            default -> throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)schema.getType()));
        }).setIsKey(schema.isKey()).setIsNullable(schema.isAllowNull()).setIndex(schema.getIndex()).build()).collect(Collectors.toList());
    }

    public static Store.Coprocessor mapping(Coprocessor coprocessor, DingoCommonId regionId) {
        return Store.Coprocessor.newBuilder().setSchemaVersion(coprocessor.getSchemaVersion()).setOriginalSchema(EntityConversion.mapping(coprocessor.getOriginalSchema(), regionId.parentId())).setResultSchema(EntityConversion.mapping(coprocessor.getResultSchema(), coprocessor.getResultSchema().getCommonId())).addAllSelectionColumns(coprocessor.getSelection()).setExpression(ByteString.copyFrom((byte[])coprocessor.getExpression())).addAllGroupByColumns(coprocessor.getGroupBy()).addAllAggregationOperators(coprocessor.getAggregations().stream().map(EntityConversion::mapping).collect(Collectors.toList())).build();
    }

    public static Store.Coprocessor.SchemaWrapper mapping(Coprocessor.SchemaWrapper schemaWrapper, long schemaId) {
        return Store.Coprocessor.SchemaWrapper.newBuilder().addAllSchema(CodecUtils.createSchemaForColumns(schemaWrapper.getSchemas()).stream().map(EntityConversion::mapping).collect(Collectors.toList())).setCommonId(schemaId).build();
    }

    public static Store.AggregationOperator mapping(AggregationOperator aggregationOperator) {
        return Store.AggregationOperator.newBuilder().setOper(Store.AggregationType.forNumber(aggregationOperator.getOperation().getCode())).setIndexOfColumn(aggregationOperator.getIndexOfColumn()).build();
    }

    public static Common.Schema mapping(DingoSchema schema) {
        return Common.Schema.newBuilder().setType(EntityConversion.mapping(schema.getType())).setIsKey(schema.isKey()).setIsNullable(schema.isAllowNull()).setIndex(schema.getIndex()).build();
    }

    public static Common.Schema.Type mapping(Type type) {
        switch (type) {
            case BOOLEAN: {
                return Common.Schema.Type.BOOL;
            }
            case INTEGER: {
                return Common.Schema.Type.INTEGER;
            }
            case FLOAT: {
                return Common.Schema.Type.FLOAT;
            }
            case LONG: {
                return Common.Schema.Type.LONG;
            }
            case DOUBLE: {
                return Common.Schema.Type.DOUBLE;
            }
            case BYTES: 
            case STRING: {
                return Common.Schema.Type.STRING;
            }
            case BOOLEANLIST: {
                return Common.Schema.Type.BOOLLIST;
            }
            case INTEGERLIST: {
                return Common.Schema.Type.INTEGERLIST;
            }
            case FLOATLIST: {
                return Common.Schema.Type.FLOATLIST;
            }
            case LONGLIST: {
                return Common.Schema.Type.LONGLIST;
            }
            case DOUBLELIST: {
                return Common.Schema.Type.DOUBLELIST;
            }
            case STRINGLIST: {
                return Common.Schema.Type.STRINGLIST;
            }
        }
        throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)type));
    }

    public static Meta.PartitionRule calcRange(Table table2, Meta.DingoCommonId tableId, List<Meta.DingoCommonId> partitionIds) {
        DingoCommonId tableId1 = EntityConversion.mapping(tableId);
        List<Column> keyColumns = table2.getKeyColumns();
        keyColumns.sort(Comparator.comparingInt(Column::getPrimary));
        DingoKeyValueCodec codec = DingoKeyValueCodec.of(table2.getCodecVersion(), tableId1.entityId(), keyColumns);
        byte[] minKeyPrefix = codec.encodeMinKeyPrefix();
        byte[] maxKeyPrefix = codec.encodeMaxKeyPrefix();
        Meta.PartitionRule.Builder builder = Meta.PartitionRule.newBuilder();
        boolean isTxn = Parameters.cleanNull(table2.getEngine(), "").startsWith("TXN");
        minKeyPrefix[0] = (byte)(isTxn ? 116 : 114);
        maxKeyPrefix[0] = (byte)(isTxn ? 116 : 114);
        Iterator keys = Optional.mapOrGet(table2.getPartition(), __ -> EntityConversion.encodePartitionDetails(__.getDetails(), codec), Stream::empty).sorted(ByteArrayUtils::compare).peek($ -> {
            $[0] = (byte)(isTxn ? 116 : 114);
        }).iterator();
        byte[] start = minKeyPrefix;
        for (Meta.DingoCommonId id : partitionIds) {
            builder.addPartitions(Meta.Partition.newBuilder().setId(id).setRange(Common.Range.newBuilder().setStartKey(ByteString.copyFrom((byte[])codec.resetPrefix(start, id.getEntityId()))).setEndKey(ByteString.copyFrom((byte[])codec.resetPrefix(maxKeyPrefix, id.getEntityId() + 1L))).build()).build());
            start = keys.hasNext() ? (byte[])keys.next() : start;
        }
        EntityConversion.getStrategy(table2.getPartition(), builder);
        return builder.build();
    }

    private static Stream<byte[]> encodePartitionDetails(List<PartitionDetail> details, KeyValueCodec codec) {
        return Parameters.cleanNull(details, Collections::emptyList).stream().map(PartitionDetail::getOperand).map(NoBreakFunctions.wrap(operand -> codec.encodeKeyPrefix((Object[])operand, ((Object[])operand).length), NoBreakFunctions.throwException()));
    }

    public static Meta.ColumnDefinition mapping(Column column) {
        return Meta.ColumnDefinition.newBuilder().setName(column.getName()).setNullable(column.isNullable()).setElementType(Parameters.cleanNull(column.getElementType(), "")).setDefaultVal(Parameters.cleanNull(column.getDefaultValue(), "")).setPrecision(column.getPrecision()).setScale(column.getScale()).setIndexOfKey(column.getPrimary()).setSqlType(column.getType()).setIsAutoIncrement(column.isAutoIncrement()).setState(column.getState() == 0 ? 1 : column.getState()).setComment(Parameters.cleanNull(column.getComment(), "")).build();
    }

    public static InternalCoordinator mapping(Location location, Location leaderLocation) {
        boolean isLeader = false;
        if (location.equals(leaderLocation)) {
            isLeader = true;
        }
        return new InternalCoordinator(location, isLeader);
    }

    public static InternalStore mapping(Common.Store store) {
        return new InternalStore(store.getId(), store.getStoreType().getNumber(), store.getState().getNumber(), EntityConversion.mapping(store.getServerLocation()), EntityConversion.mapping(store.getRaftLocation()));
    }

    public static InternalRegion mapping(Common.Region region2) {
        long leaderStoreId = region2.getLeaderStoreId();
        List<Common.Peer> peerList = region2.getDefinition().getPeersList();
        List<Location> followers = null;
        Location leader = null;
        if (peerList != null && peerList.size() > 0) {
            followers = peerList.stream().filter(p -> p.getStoreId() != leaderStoreId).map(peer -> EntityConversion.mapping(peer.getRaftLocation())).collect(Collectors.toList());
            leader = peerList.stream().filter(p -> p.getStoreId() == leaderStoreId).map(peer -> EntityConversion.mapping(peer.getRaftLocation())).findAny().orElseThrow(() -> new DingoClientException("Not found region leader"));
        }
        int regionType = region2.getRegionTypeValue();
        int regionState = region2.getStateValue();
        long createTime = region2.getCreateTimestamp();
        long deleteTime = region2.getDeletedTimestamp();
        return new InternalRegion(region2.getId(), regionState, regionType, createTime, deleteTime, followers, leader, leaderStoreId);
    }
}

