/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.common.utils;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ByteArrayUtils {
    public static final byte[] EMPTY_BYTES = new byte[0];
    public static final byte[] MAX_BYTES = new byte[]{-1};
    public static final int POS = 8;

    private ByteArrayUtils() {
    }

    public static int compare(byte[] bytes1, byte[] bytes2, boolean ignoreLen, int pos) {
        if (bytes1 == bytes2) {
            return 0;
        }
        int n = Math.min(bytes1.length, bytes2.length);
        for (int i = pos; i < n; ++i) {
            if (bytes1[i] == bytes2[i]) continue;
            return (bytes1[i] & 0xFF) - (bytes2[i] & 0xFF);
        }
        return ignoreLen ? 0 : bytes1.length - bytes2.length;
    }

    public static int compare(byte[] bytes1, byte[] bytes2) {
        return ByteArrayUtils.compare(bytes1, bytes2, false, 0);
    }

    public static int compare(byte[] bytes1, byte[] bytes2, int pos) {
        return ByteArrayUtils.compare(bytes1, bytes2, false, pos);
    }

    public static int compareWithoutLen(byte[] bytes1, byte[] bytes2) {
        return ByteArrayUtils.compareWithoutLen(bytes1, bytes2, 0);
    }

    public static int compareWithoutLen(byte[] bytes1, byte[] bytes2, int pos) {
        return ByteArrayUtils.compare(bytes1, bytes2, true, pos);
    }

    public static boolean equal(byte[] bytes1, byte[] bytes2) {
        return bytes2 != null && ByteArrayUtils.compare(bytes1, bytes2) == 0;
    }

    public static boolean lessThan(byte[] bytes1, byte[] bytes2) {
        return ByteArrayUtils.compare(bytes1, bytes2) < 0;
    }

    public static boolean greatThan(byte[] bytes1, byte[] bytes2) {
        return ByteArrayUtils.compare(bytes1, bytes2) > 0;
    }

    public static boolean lessThanOrEqual(byte[] bytes1, byte[] bytes2) {
        return ByteArrayUtils.compareWithoutLen(bytes1, bytes2) <= 0;
    }

    public static boolean greatThanOrEqual(byte[] bytes1, byte[] bytes2) {
        return ByteArrayUtils.compareWithoutLen(bytes1, bytes2) >= 0;
    }

    public static String toHex(byte[] bytes) {
        if (bytes == null) {
            return "null";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (byte b : bytes) {
            stringBuilder.append(String.format("%02X", b));
        }
        return stringBuilder.toString();
    }

    public static byte[] increment(@NonNull byte[] input) {
        if (input == null) {
            return null;
        }
        byte[] ret = new byte[input.length];
        byte carry = 1;
        for (int i = input.length - 1; i >= 0; --i) {
            if (input[i] == -1 && carry == 1) {
                ret[i] = 0;
                continue;
            }
            ret[i] = (byte)(input[i] + carry);
            carry = 0;
        }
        return carry == 0 ? ret : input;
    }

    public static List<byte[]> toList(byte[] ... bytes) {
        return Stream.of(bytes).collect(Collectors.toList());
    }

    public static byte[] concatByteArray(byte @NonNull [] bytes1, byte @NonNull [] bytes2) {
        byte[] result = new byte[bytes1.length + bytes2.length];
        System.arraycopy(bytes1, 0, result, 0, bytes1.length);
        System.arraycopy(bytes2, 0, result, bytes1.length, bytes2.length);
        return result;
    }

    public static byte[] slice(byte @NonNull [] source, int pos, int len) {
        byte[] slice = new byte[len];
        System.arraycopy(source, pos, slice, 0, len);
        return slice;
    }

    public static byte[] unsliced(byte @NonNull [] slice, int pos) {
        return ByteArrayUtils.unsliced(slice, Math.max(pos, 0), Math.abs(pos) + slice.length);
    }

    public static byte[] unsliced(byte @NonNull [] slice, int pos, int len) {
        byte[] source = new byte[len];
        System.arraycopy(slice, 0, source, pos, slice.length);
        return source;
    }

    public static class ComparableByteArray
    implements Comparable<ComparableByteArray> {
        @JsonProperty
        private byte[] bytes;
        @JsonProperty
        private boolean ignoreLen = false;
        @JsonProperty
        private int pos = 0;

        public ComparableByteArray(byte[] bytes) {
            this.bytes = bytes;
        }

        public ComparableByteArray(byte[] bytes, int pos) {
            this.bytes = bytes;
            this.pos = pos;
        }

        @Override
        public int compareTo(@NonNull ComparableByteArray other) {
            if (!this.ignoreLen) {
                return ByteArrayUtils.compare(this.bytes, other.bytes, this.pos);
            }
            return ByteArrayUtils.compareWithoutLen(this.bytes, other.bytes, this.pos);
        }

        public byte[] getBytes() {
            return this.bytes;
        }

        public boolean isIgnoreLen() {
            return this.ignoreLen;
        }

        public int getPos() {
            return this.pos;
        }

        @JsonProperty
        public void setBytes(byte[] bytes) {
            this.bytes = bytes;
        }

        @JsonProperty
        public void setIgnoreLen(boolean ignoreLen) {
            this.ignoreLen = ignoreLen;
        }

        @JsonProperty
        public void setPos(int pos) {
            this.pos = pos;
        }

        public String toString() {
            return "ByteArrayUtils.ComparableByteArray(bytes=" + Arrays.toString(this.getBytes()) + ", ignoreLen=" + this.isIgnoreLen() + ", pos=" + this.getPos() + ")";
        }

        public ComparableByteArray() {
        }

        public ComparableByteArray(byte[] bytes, boolean ignoreLen, int pos) {
            this.bytes = bytes;
            this.ignoreLen = ignoreLen;
            this.pos = pos;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ComparableByteArray)) {
                return false;
            }
            ComparableByteArray other = (ComparableByteArray)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isIgnoreLen() != other.isIgnoreLen()) {
                return false;
            }
            if (this.getPos() != other.getPos()) {
                return false;
            }
            return Arrays.equals(this.getBytes(), other.getBytes());
        }

        protected boolean canEqual(Object other) {
            return other instanceof ComparableByteArray;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isIgnoreLen() ? 79 : 97);
            result = result * 59 + this.getPos();
            result = result * 59 + Arrays.hashCode(this.getBytes());
            return result;
        }
    }
}

