/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.common.table;

import io.dingodb.sdk.common.index.IndexParameter;
import io.dingodb.sdk.common.partition.Partition;
import io.dingodb.sdk.common.table.Column;
import io.dingodb.sdk.common.table.Table;
import java.util.List;
import java.util.Map;

public class TableDefinition
implements Table {
    private String name;
    private List<Column> columns;
    private int version;
    private int ttl;
    private Partition partition;
    private String engine;
    private Map<String, String> properties;
    private int replica;
    private long autoIncrement;
    private String createSql;
    private IndexParameter indexParameter;
    private String comment;
    private String charset;
    private String collate;
    private String tableType;
    private String rowFormat;
    private long createTime;
    private long updateTime;
    private int codecVersion;

    private static long $default$autoIncrement() {
        return 1L;
    }

    public static TableDefinitionBuilder builder() {
        return new TableDefinitionBuilder();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<Column> getColumns() {
        return this.columns;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public int getTtl() {
        return this.ttl;
    }

    @Override
    public Partition getPartition() {
        return this.partition;
    }

    @Override
    public String getEngine() {
        return this.engine;
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Override
    public int getReplica() {
        return this.replica;
    }

    @Override
    public long getAutoIncrement() {
        return this.autoIncrement;
    }

    @Override
    public String getCreateSql() {
        return this.createSql;
    }

    @Override
    public IndexParameter getIndexParameter() {
        return this.indexParameter;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public String getCharset() {
        return this.charset;
    }

    @Override
    public String getCollate() {
        return this.collate;
    }

    @Override
    public String getTableType() {
        return this.tableType;
    }

    @Override
    public String getRowFormat() {
        return this.rowFormat;
    }

    @Override
    public long getCreateTime() {
        return this.createTime;
    }

    @Override
    public long getUpdateTime() {
        return this.updateTime;
    }

    @Override
    public int getCodecVersion() {
        return this.codecVersion;
    }

    public String toString() {
        return "TableDefinition(name=" + this.getName() + ", columns=" + String.valueOf(this.getColumns()) + ", version=" + this.getVersion() + ", ttl=" + this.getTtl() + ", partition=" + String.valueOf(this.getPartition()) + ", engine=" + this.getEngine() + ", properties=" + String.valueOf(this.getProperties()) + ", replica=" + this.getReplica() + ", autoIncrement=" + this.getAutoIncrement() + ", createSql=" + this.getCreateSql() + ", indexParameter=" + String.valueOf(this.getIndexParameter()) + ", comment=" + this.getComment() + ", charset=" + this.getCharset() + ", collate=" + this.getCollate() + ", tableType=" + this.getTableType() + ", rowFormat=" + this.getRowFormat() + ", createTime=" + this.getCreateTime() + ", updateTime=" + this.getUpdateTime() + ", codecVersion=" + this.getCodecVersion() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TableDefinition)) {
            return false;
        }
        TableDefinition other = (TableDefinition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getVersion() != other.getVersion()) {
            return false;
        }
        if (this.getTtl() != other.getTtl()) {
            return false;
        }
        if (this.getReplica() != other.getReplica()) {
            return false;
        }
        if (this.getAutoIncrement() != other.getAutoIncrement()) {
            return false;
        }
        if (this.getCreateTime() != other.getCreateTime()) {
            return false;
        }
        if (this.getUpdateTime() != other.getUpdateTime()) {
            return false;
        }
        if (this.getCodecVersion() != other.getCodecVersion()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List<Column> this$columns = this.getColumns();
        List<Column> other$columns = other.getColumns();
        if (this$columns == null ? other$columns != null : !((Object)this$columns).equals(other$columns)) {
            return false;
        }
        Partition this$partition = this.getPartition();
        Partition other$partition = other.getPartition();
        if (this$partition == null ? other$partition != null : !this$partition.equals(other$partition)) {
            return false;
        }
        String this$engine = this.getEngine();
        String other$engine = other.getEngine();
        if (this$engine == null ? other$engine != null : !this$engine.equals(other$engine)) {
            return false;
        }
        Map<String, String> this$properties = this.getProperties();
        Map<String, String> other$properties = other.getProperties();
        if (this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties)) {
            return false;
        }
        String this$createSql = this.getCreateSql();
        String other$createSql = other.getCreateSql();
        if (this$createSql == null ? other$createSql != null : !this$createSql.equals(other$createSql)) {
            return false;
        }
        IndexParameter this$indexParameter = this.getIndexParameter();
        IndexParameter other$indexParameter = other.getIndexParameter();
        if (this$indexParameter == null ? other$indexParameter != null : !((Object)this$indexParameter).equals(other$indexParameter)) {
            return false;
        }
        String this$comment = this.getComment();
        String other$comment = other.getComment();
        if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
            return false;
        }
        String this$charset = this.getCharset();
        String other$charset = other.getCharset();
        if (this$charset == null ? other$charset != null : !this$charset.equals(other$charset)) {
            return false;
        }
        String this$collate = this.getCollate();
        String other$collate = other.getCollate();
        if (this$collate == null ? other$collate != null : !this$collate.equals(other$collate)) {
            return false;
        }
        String this$tableType = this.getTableType();
        String other$tableType = other.getTableType();
        if (this$tableType == null ? other$tableType != null : !this$tableType.equals(other$tableType)) {
            return false;
        }
        String this$rowFormat = this.getRowFormat();
        String other$rowFormat = other.getRowFormat();
        return !(this$rowFormat == null ? other$rowFormat != null : !this$rowFormat.equals(other$rowFormat));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TableDefinition;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getVersion();
        result = result * 59 + this.getTtl();
        result = result * 59 + this.getReplica();
        long $autoIncrement = this.getAutoIncrement();
        result = result * 59 + (int)($autoIncrement >>> 32 ^ $autoIncrement);
        long $createTime = this.getCreateTime();
        result = result * 59 + (int)($createTime >>> 32 ^ $createTime);
        long $updateTime = this.getUpdateTime();
        result = result * 59 + (int)($updateTime >>> 32 ^ $updateTime);
        result = result * 59 + this.getCodecVersion();
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        List<Column> $columns = this.getColumns();
        result = result * 59 + ($columns == null ? 43 : ((Object)$columns).hashCode());
        Partition $partition = this.getPartition();
        result = result * 59 + ($partition == null ? 43 : $partition.hashCode());
        String $engine = this.getEngine();
        result = result * 59 + ($engine == null ? 43 : $engine.hashCode());
        Map<String, String> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        String $createSql = this.getCreateSql();
        result = result * 59 + ($createSql == null ? 43 : $createSql.hashCode());
        IndexParameter $indexParameter = this.getIndexParameter();
        result = result * 59 + ($indexParameter == null ? 43 : ((Object)$indexParameter).hashCode());
        String $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        String $charset = this.getCharset();
        result = result * 59 + ($charset == null ? 43 : $charset.hashCode());
        String $collate = this.getCollate();
        result = result * 59 + ($collate == null ? 43 : $collate.hashCode());
        String $tableType = this.getTableType();
        result = result * 59 + ($tableType == null ? 43 : $tableType.hashCode());
        String $rowFormat = this.getRowFormat();
        result = result * 59 + ($rowFormat == null ? 43 : $rowFormat.hashCode());
        return result;
    }

    public TableDefinition(String name, List<Column> columns, int version, int ttl, Partition partition, String engine, Map<String, String> properties, int replica, long autoIncrement, String createSql, IndexParameter indexParameter, String comment, String charset, String collate, String tableType, String rowFormat, long createTime, long updateTime, int codecVersion) {
        this.name = name;
        this.columns = columns;
        this.version = version;
        this.ttl = ttl;
        this.partition = partition;
        this.engine = engine;
        this.properties = properties;
        this.replica = replica;
        this.autoIncrement = autoIncrement;
        this.createSql = createSql;
        this.indexParameter = indexParameter;
        this.comment = comment;
        this.charset = charset;
        this.collate = collate;
        this.tableType = tableType;
        this.rowFormat = rowFormat;
        this.createTime = createTime;
        this.updateTime = updateTime;
        this.codecVersion = codecVersion;
    }

    public static class TableDefinitionBuilder {
        private String name;
        private List<Column> columns;
        private int version;
        private int ttl;
        private Partition partition;
        private String engine;
        private Map<String, String> properties;
        private int replica;
        private boolean autoIncrement$set;
        private long autoIncrement$value;
        private String createSql;
        private IndexParameter indexParameter;
        private String comment;
        private String charset;
        private String collate;
        private String tableType;
        private String rowFormat;
        private long createTime;
        private long updateTime;
        private int codecVersion;

        TableDefinitionBuilder() {
        }

        public TableDefinitionBuilder name(String name) {
            this.name = name;
            return this;
        }

        public TableDefinitionBuilder columns(List<Column> columns) {
            this.columns = columns;
            return this;
        }

        public TableDefinitionBuilder version(int version) {
            this.version = version;
            return this;
        }

        public TableDefinitionBuilder ttl(int ttl) {
            this.ttl = ttl;
            return this;
        }

        public TableDefinitionBuilder partition(Partition partition) {
            this.partition = partition;
            return this;
        }

        public TableDefinitionBuilder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public TableDefinitionBuilder properties(Map<String, String> properties) {
            this.properties = properties;
            return this;
        }

        public TableDefinitionBuilder replica(int replica) {
            this.replica = replica;
            return this;
        }

        public TableDefinitionBuilder autoIncrement(long autoIncrement) {
            this.autoIncrement$value = autoIncrement;
            this.autoIncrement$set = true;
            return this;
        }

        public TableDefinitionBuilder createSql(String createSql) {
            this.createSql = createSql;
            return this;
        }

        public TableDefinitionBuilder indexParameter(IndexParameter indexParameter) {
            this.indexParameter = indexParameter;
            return this;
        }

        public TableDefinitionBuilder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public TableDefinitionBuilder charset(String charset) {
            this.charset = charset;
            return this;
        }

        public TableDefinitionBuilder collate(String collate) {
            this.collate = collate;
            return this;
        }

        public TableDefinitionBuilder tableType(String tableType) {
            this.tableType = tableType;
            return this;
        }

        public TableDefinitionBuilder rowFormat(String rowFormat) {
            this.rowFormat = rowFormat;
            return this;
        }

        public TableDefinitionBuilder createTime(long createTime) {
            this.createTime = createTime;
            return this;
        }

        public TableDefinitionBuilder updateTime(long updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public TableDefinitionBuilder codecVersion(int codecVersion) {
            this.codecVersion = codecVersion;
            return this;
        }

        public TableDefinition build() {
            long autoIncrement$value = this.autoIncrement$value;
            if (!this.autoIncrement$set) {
                autoIncrement$value = TableDefinition.$default$autoIncrement();
            }
            return new TableDefinition(this.name, this.columns, this.version, this.ttl, this.partition, this.engine, this.properties, this.replica, autoIncrement$value, this.createSql, this.indexParameter, this.comment, this.charset, this.collate, this.tableType, this.rowFormat, this.createTime, this.updateTime, this.codecVersion);
        }

        public String toString() {
            return "TableDefinition.TableDefinitionBuilder(name=" + this.name + ", columns=" + String.valueOf(this.columns) + ", version=" + this.version + ", ttl=" + this.ttl + ", partition=" + String.valueOf(this.partition) + ", engine=" + this.engine + ", properties=" + String.valueOf(this.properties) + ", replica=" + this.replica + ", autoIncrement$value=" + this.autoIncrement$value + ", createSql=" + this.createSql + ", indexParameter=" + String.valueOf(this.indexParameter) + ", comment=" + this.comment + ", charset=" + this.charset + ", collate=" + this.collate + ", tableType=" + this.tableType + ", rowFormat=" + this.rowFormat + ", createTime=" + this.createTime + ", updateTime=" + this.updateTime + ", codecVersion=" + this.codecVersion + ")";
        }
    }
}

