/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.common.table;

import io.dingodb.sdk.common.DingoCommonId;
import io.dingodb.sdk.common.index.IndexParameter;
import io.dingodb.sdk.common.partition.Partition;
import io.dingodb.sdk.common.table.Column;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public interface Table {
    default public DingoCommonId id() {
        return null;
    }

    public String getName();

    public List<Column> getColumns();

    public int getVersion();

    public int getTtl();

    public Partition getPartition();

    public String getEngine();

    public Map<String, String> getProperties();

    public int getReplica();

    public long getAutoIncrement();

    public String getCreateSql();

    public IndexParameter getIndexParameter();

    public String getComment();

    public String getCharset();

    public String getCollate();

    default public int getCodecVersion() {
        return 2;
    }

    default public String getTableType() {
        return "BASE TABLE";
    }

    default public String getRowFormat() {
        return "Dynamic";
    }

    default public long getCreateTime() {
        return System.currentTimeMillis();
    }

    default public long getUpdateTime() {
        return 0L;
    }

    default public int getPrimaryKeyCount() {
        int count = 0;
        for (Column column : this.getColumns()) {
            if (!column.isPrimary()) continue;
            ++count;
        }
        return count;
    }

    default public Column getColumn(int index) {
        return this.getColumns().get(index);
    }

    default public Column getColumn(String name) {
        for (Column column : this.getColumns()) {
            if (!column.getName().equalsIgnoreCase(name)) continue;
            return column;
        }
        return null;
    }

    default public int getColumnIndex(String name) {
        int i = 0;
        for (Column column : this.getColumns()) {
            if (column.getName().equalsIgnoreCase(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    default public List<Integer> getKeyColumnIndices() {
        return this.getColumnIndices(true);
    }

    default public List<Column> getKeyColumns() {
        LinkedList<Column> keyCols = new LinkedList<Column>();
        for (Column column : this.getColumns()) {
            if (!column.isPrimary()) continue;
            keyCols.add(column);
        }
        return keyCols;
    }

    default public List<Integer> getColumnIndices(boolean keyOrValue) {
        LinkedList<Integer> indices = new LinkedList<Integer>();
        int index = 0;
        for (Column column : this.getColumns()) {
            if (column.isPrimary() == keyOrValue) {
                indices.add(index);
            }
            ++index;
        }
        if (keyOrValue) {
            Integer[] pkIndices = new Integer[indices.size()];
            Iterator iterator = indices.iterator();
            while (iterator.hasNext()) {
                Integer integer;
                pkIndices[this.getColumns().get((int)integer.intValue()).getPrimary()] = integer = (Integer)iterator.next();
            }
            return Arrays.asList(pkIndices);
        }
        return indices;
    }
}

