/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.common.table;

import io.dingodb.sdk.common.DingoCommonId;
import io.dingodb.sdk.common.Location;
import io.dingodb.sdk.common.Range;
import io.dingodb.sdk.common.region.RegionEpoch;
import io.dingodb.sdk.common.region.RegionStatus;
import java.util.List;

public class RangeDistribution {
    private DingoCommonId id;
    private Range range;
    private Location leader;
    private List<Location> voters;
    private RegionEpoch regionEpoch;
    private RegionStatus status;

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        RangeDistribution that = (RangeDistribution)other;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = 31 * result + (this.range != null ? this.range.hashCode() : 0);
        result = 31 * result + (this.leader != null ? this.leader.hashCode() : 0);
        result = 31 * result + (this.voters != null ? this.voters.hashCode() : 0);
        return result;
    }

    public static RangeDistributionBuilder builder() {
        return new RangeDistributionBuilder();
    }

    public DingoCommonId getId() {
        return this.id;
    }

    public Range getRange() {
        return this.range;
    }

    public Location getLeader() {
        return this.leader;
    }

    public List<Location> getVoters() {
        return this.voters;
    }

    public RegionEpoch getRegionEpoch() {
        return this.regionEpoch;
    }

    public RegionStatus getStatus() {
        return this.status;
    }

    public RangeDistribution(DingoCommonId id, Range range, Location leader, List<Location> voters, RegionEpoch regionEpoch, RegionStatus status) {
        this.id = id;
        this.range = range;
        this.leader = leader;
        this.voters = voters;
        this.regionEpoch = regionEpoch;
        this.status = status;
    }

    public static class RangeDistributionBuilder {
        private DingoCommonId id;
        private Range range;
        private Location leader;
        private List<Location> voters;
        private RegionEpoch regionEpoch;
        private RegionStatus status;

        RangeDistributionBuilder() {
        }

        public RangeDistributionBuilder id(DingoCommonId id) {
            this.id = id;
            return this;
        }

        public RangeDistributionBuilder range(Range range) {
            this.range = range;
            return this;
        }

        public RangeDistributionBuilder leader(Location leader) {
            this.leader = leader;
            return this;
        }

        public RangeDistributionBuilder voters(List<Location> voters) {
            this.voters = voters;
            return this;
        }

        public RangeDistributionBuilder regionEpoch(RegionEpoch regionEpoch) {
            this.regionEpoch = regionEpoch;
            return this;
        }

        public RangeDistributionBuilder status(RegionStatus status) {
            this.status = status;
            return this;
        }

        public RangeDistribution build() {
            return new RangeDistribution(this.id, this.range, this.leader, this.voters, this.regionEpoch, this.status);
        }

        public String toString() {
            return "RangeDistribution.RangeDistributionBuilder(id=" + String.valueOf(this.id) + ", range=" + String.valueOf(this.range) + ", leader=" + String.valueOf(this.leader) + ", voters=" + String.valueOf(this.voters) + ", regionEpoch=" + String.valueOf(this.regionEpoch) + ", status=" + String.valueOf(this.status) + ")";
        }
    }
}

