/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.common.serial.schema;

import io.dingodb.sdk.common.serial.Buf;
import io.dingodb.sdk.common.serial.schema.DingoSchema;
import io.dingodb.sdk.common.serial.schema.Type;
import java.nio.charset.StandardCharsets;

public class VectorSchema
implements DingoSchema<String> {
    private int index;
    private boolean isKey = false;
    private boolean allowNull = true;

    public VectorSchema() {
    }

    public VectorSchema(int index) {
        this.index = index;
    }

    @Override
    public Type getType() {
        return Type.VECTOR;
    }

    @Override
    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public void setIsKey(boolean isKey) {
        if (isKey) {
            throw new RuntimeException("Vector cannot be key");
        }
    }

    @Override
    public boolean isKey() {
        return this.isKey;
    }

    @Override
    public int getLength() {
        return 0;
    }

    @Override
    public int getWithNullTagLength() {
        return 1;
    }

    @Override
    public int getValueLengthV2() {
        return 0;
    }

    @Override
    public void setAllowNull(boolean allowNull) {
        this.allowNull = allowNull;
    }

    @Override
    public boolean isAllowNull() {
        return this.allowNull;
    }

    @Override
    public void encodeKey(Buf buf, String data) {
        throw new RuntimeException("Vector cannot be key");
    }

    @Override
    public void encodeKeyV2(Buf buf, String data) {
        throw new RuntimeException("Vector cannot be key");
    }

    @Override
    public void encodeKeyForUpdate(Buf buf, String data) {
        throw new RuntimeException("Vector cannot be key");
    }

    @Override
    public void encodeKeyForUpdateV2(Buf buf, String data) {
        throw new RuntimeException("Vector cannot be key");
    }

    @Override
    public String decodeKey(Buf buf) {
        throw new RuntimeException("Vector cannot be key");
    }

    @Override
    public String decodeKeyV2(Buf buf) {
        throw new RuntimeException("Vector cannot be key");
    }

    @Override
    public String decodeKeyPrefix(Buf buf) {
        throw new RuntimeException("Vector cannot be key");
    }

    @Override
    public void skipKey(Buf buf) {
        throw new RuntimeException("Vector cannot be key");
    }

    @Override
    public void skipKeyV2(Buf buf) {
        throw new RuntimeException("Vector cannot be key");
    }

    @Override
    public void encodeKeyPrefix(Buf buf, String data) {
        throw new RuntimeException("Vector cannot be key");
    }

    @Override
    public void encodeValue(Buf buf, String data) {
        if (this.allowNull) {
            if (data == null) {
                buf.ensureRemainder(1);
                buf.write((byte)0);
            } else {
                byte[] bytes = data.getBytes(StandardCharsets.UTF_8);
                buf.ensureRemainder(5 + bytes.length);
                buf.write((byte)1);
                buf.writeInt(bytes.length);
                buf.write(bytes);
            }
        } else {
            byte[] bytes = data.getBytes(StandardCharsets.UTF_8);
            buf.ensureRemainder(4 + bytes.length);
            buf.writeInt(bytes.length);
            buf.write(bytes);
        }
    }

    @Override
    public int encodeValueV2(Buf buf, String data) {
        int len = 0;
        if (this.allowNull) {
            if (data == null) {
                return 0;
            }
            byte[] bytes = data.getBytes(StandardCharsets.UTF_8);
            buf.ensureRemainder(4 + bytes.length);
            buf.write((byte)1);
            buf.writeInt(bytes.length);
            buf.write(bytes);
            len += 4 + bytes.length;
        } else {
            byte[] bytes = data.getBytes(StandardCharsets.UTF_8);
            buf.ensureRemainder(4 + bytes.length);
            buf.writeInt(bytes.length);
            buf.write(bytes);
            len += 4 + bytes.length;
        }
        return len;
    }

    @Override
    public String decodeValue(Buf buf) {
        if (this.allowNull) {
            if (buf.read() == 0) {
                return null;
            }
            return new String(buf.read(buf.readInt()), StandardCharsets.UTF_8);
        }
        return new String(buf.read(buf.readInt()), StandardCharsets.UTF_8);
    }

    @Override
    public String decodeValueV2(Buf buf) {
        return new String(buf.read(buf.readInt()), StandardCharsets.UTF_8);
    }

    @Override
    public void skipValue(Buf buf) {
        if (this.allowNull) {
            if (buf.read() == 1) {
                buf.skip(buf.readInt());
            }
        } else {
            buf.skip(buf.readInt());
        }
    }

    @Override
    public void skipValueV2(Buf buf) {
        buf.skip(buf.readInt());
    }
}

