/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.common.serial.schema;

import io.dingodb.sdk.common.serial.Buf;
import io.dingodb.sdk.common.serial.schema.DingoSchema;
import io.dingodb.sdk.common.serial.schema.Type;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public class StringListSchema
implements DingoSchema<List<String>> {
    private int index;
    private boolean isKey;
    private boolean allowNull = true;

    public StringListSchema() {
    }

    public StringListSchema(int index) {
        this.index = index;
    }

    @Override
    public Type getType() {
        return Type.STRINGLIST;
    }

    @Override
    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public void setIsKey(boolean isKey) {
        this.isKey = isKey;
    }

    @Override
    public boolean isKey() {
        return this.isKey;
    }

    @Override
    public int getLength() {
        return 0;
    }

    @Override
    public int getWithNullTagLength() {
        return 1;
    }

    @Override
    public int getValueLengthV2() {
        return 0;
    }

    @Override
    public void setAllowNull(boolean allowNull) {
        this.allowNull = allowNull;
    }

    @Override
    public boolean isAllowNull() {
        return this.allowNull;
    }

    @Override
    public void encodeKey(Buf buf, List<String> data) {
        throw new RuntimeException("Array cannot be key");
    }

    @Override
    public void encodeKeyV2(Buf buf, List<String> data) {
        throw new RuntimeException("Array cannot be key");
    }

    private int internalEncodeKey(Buf buf, byte[] data) {
        int i;
        int remaindZero;
        int groupNum = data.length / 8;
        int size = (groupNum + 1) * 9;
        int remainderSize = data.length % 8;
        if (remainderSize == 0) {
            remainderSize = 8;
            remaindZero = 8;
        } else {
            remaindZero = 8 - remainderSize;
        }
        buf.ensureRemainder(size);
        for (i = 0; i < groupNum; ++i) {
            buf.write(data, 8 * i, 8);
            buf.write((byte)-1);
        }
        if (remainderSize < 8) {
            buf.write(data, 8 * groupNum, remainderSize);
        }
        for (i = 0; i < remaindZero; ++i) {
            buf.write((byte)0);
        }
        buf.write((byte)(255 - remaindZero));
        return size;
    }

    @Override
    public void encodeKeyForUpdate(Buf buf, List<String> data) {
        throw new RuntimeException("Array cannot be key");
    }

    @Override
    public void encodeKeyForUpdateV2(Buf buf, List<String> data) {
        throw new RuntimeException("Array cannot be key");
    }

    @Override
    public List<String> decodeKey(Buf buf) {
        throw new RuntimeException("Array cannot be key");
    }

    @Override
    public List<String> decodeKeyV2(Buf buf) {
        throw new RuntimeException("Array cannot be key");
    }

    @Override
    public List<String> decodeKeyPrefix(Buf buf) {
        throw new RuntimeException("Array cannot be key");
    }

    private byte[] internalReadBytes(Buf buf) {
        int length = buf.reverseReadInt();
        int groupNum = length / 9;
        buf.skip(length - 1);
        int reminderZero = 255 - buf.read() & 0xFF;
        buf.skip(0 - length);
        int oriLength = groupNum * 8 - reminderZero;
        byte[] data = new byte[oriLength];
        if (oriLength != 0) {
            --groupNum;
            for (int i = 0; i < groupNum; ++i) {
                buf.read(data, 8 * i, 8);
                buf.skip(1);
            }
            if (reminderZero != 8) {
                buf.read(data, 8 * groupNum, 8 - reminderZero);
            }
        }
        buf.skip(reminderZero + 1);
        return data;
    }

    @Override
    public void skipKey(Buf buf) {
        throw new RuntimeException("Array cannot be key");
    }

    @Override
    public void skipKeyV2(Buf buf) {
        throw new RuntimeException("Array cannot be key");
    }

    @Override
    public void encodeKeyPrefix(Buf buf, List<String> data) {
        throw new RuntimeException("Array cannot be key");
    }

    @Override
    public void encodeValue(Buf buf, List<String> data) {
        if (this.allowNull) {
            if (data == null) {
                buf.ensureRemainder(1);
                buf.write((byte)0);
            } else {
                buf.ensureRemainder(5);
                buf.write((byte)1);
                buf.writeInt(data.size());
                for (String value : data) {
                    if (value == null) {
                        throw new IllegalArgumentException("Array type sub-elements do not support null values");
                    }
                    byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
                    buf.ensureRemainder(4 + bytes.length);
                    buf.writeInt(bytes.length);
                    buf.write(bytes);
                }
            }
        } else {
            buf.ensureRemainder(4);
            buf.writeInt(data.size());
            for (String value : data) {
                if (value == null) {
                    throw new IllegalArgumentException("Array type sub-elements do not support null values");
                }
                byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
                buf.ensureRemainder(4 + bytes.length);
                buf.writeInt(bytes.length);
                buf.write(bytes);
            }
        }
    }

    @Override
    public int encodeValueV2(Buf buf, List<String> data) {
        int len = 0;
        if (this.allowNull) {
            if (data == null) {
                return 0;
            }
            len = 4;
            buf.ensureRemainder(len);
            buf.writeInt(data.size());
            for (String value : data) {
                if (value == null) {
                    throw new IllegalArgumentException("Array type sub-elements do not support null values");
                }
                byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
                buf.ensureRemainder(4 + bytes.length);
                buf.writeInt(bytes.length);
                buf.write(bytes);
                len += 4 + bytes.length;
            }
        } else {
            len = 4;
            buf.ensureRemainder(len);
            buf.writeInt(data.size());
            for (String value : data) {
                if (value == null) {
                    throw new IllegalArgumentException("Array type sub-elements do not support null values");
                }
                byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
                buf.ensureRemainder(4 + bytes.length);
                buf.writeInt(bytes.length);
                buf.write(bytes);
                len += 4 + bytes.length;
            }
        }
        return len;
    }

    @Override
    public List<String> decodeValue(Buf buf) {
        if (this.allowNull && buf.read() == 0) {
            return null;
        }
        ArrayList<String> data = new ArrayList<String>();
        int length = buf.readInt();
        for (int i = 0; i < length; ++i) {
            data.add(new String(buf.read(buf.readInt()), StandardCharsets.UTF_8));
        }
        return data;
    }

    @Override
    public List<String> decodeValueV2(Buf buf) {
        ArrayList<String> data = new ArrayList<String>();
        int length = buf.readInt();
        for (int i = 0; i < length; ++i) {
            data.add(new String(buf.read(buf.readInt()), StandardCharsets.UTF_8));
        }
        return data;
    }

    @Override
    public void skipValue(Buf buf) {
        if (this.allowNull && buf.read() == 0) {
            return;
        }
        int length = buf.readInt();
        for (int i = 0; i < length; ++i) {
            int strSize = buf.readInt();
            buf.skip(strSize);
        }
    }

    @Override
    public void skipValueV2(Buf buf) {
        int length = buf.readInt();
        for (int i = 0; i < length; ++i) {
            int strSize = buf.readInt();
            buf.skip(strSize);
        }
    }
}

