/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.common.serial.schema;

import io.dingodb.sdk.common.serial.Buf;
import io.dingodb.sdk.common.serial.schema.DingoSchema;
import io.dingodb.sdk.common.serial.schema.Type;

public class LongSchema
implements DingoSchema<Long> {
    private int index;
    private boolean isKey;
    private boolean allowNull = true;

    public LongSchema() {
    }

    public LongSchema(int index) {
        this.index = index;
    }

    @Override
    public Type getType() {
        return Type.LONG;
    }

    @Override
    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public void setIsKey(boolean isKey) {
        this.isKey = isKey;
    }

    @Override
    public boolean isKey() {
        return this.isKey;
    }

    @Override
    public int getLength() {
        if (this.allowNull) {
            return this.getWithNullTagLength();
        }
        return this.getDataLength();
    }

    @Override
    public int getValueLengthV2() {
        return this.getDataLength();
    }

    @Override
    public int getWithNullTagLength() {
        return 9;
    }

    private int getDataLength() {
        return 8;
    }

    @Override
    public void setAllowNull(boolean allowNull) {
        this.allowNull = allowNull;
    }

    @Override
    public boolean isAllowNull() {
        return this.allowNull;
    }

    @Override
    public void encodeKey(Buf buf, Long data) {
        if (this.allowNull) {
            buf.ensureRemainder(this.getWithNullTagLength());
            if (data == null) {
                buf.write((byte)0);
                this.internalEncodeNull(buf);
            } else {
                buf.write((byte)1);
                this.internalEncodeKey(buf, data);
            }
        } else {
            buf.ensureRemainder(this.getDataLength());
            this.internalEncodeKey(buf, data);
        }
    }

    @Override
    public void encodeKeyV2(Buf buf, Long data) {
        this.encodeKey(buf, data);
    }

    @Override
    public void encodeKeyForUpdate(Buf buf, Long data) {
        if (this.allowNull) {
            if (data == null) {
                buf.write((byte)0);
                this.internalEncodeNull(buf);
            } else {
                buf.write((byte)1);
                this.internalEncodeKey(buf, data);
            }
        } else {
            this.internalEncodeKey(buf, data);
        }
    }

    @Override
    public void encodeKeyForUpdateV2(Buf buf, Long data) {
        this.encodeKeyForUpdate(buf, data);
    }

    private void internalEncodeNull(Buf buf) {
        buf.write((byte)0);
        buf.write((byte)0);
        buf.write((byte)0);
        buf.write((byte)0);
        buf.write((byte)0);
        buf.write((byte)0);
        buf.write((byte)0);
        buf.write((byte)0);
    }

    private void internalEncodeKey(Buf buf, Long data) {
        buf.write((byte)(data >>> 56 ^ 0x80L));
        buf.write((byte)(data >>> 48));
        buf.write((byte)(data >>> 40));
        buf.write((byte)(data >>> 32));
        buf.write((byte)(data >>> 24));
        buf.write((byte)(data >>> 16));
        buf.write((byte)(data >>> 8));
        buf.write((byte)data.longValue());
    }

    @Override
    public Long decodeKey(Buf buf) {
        if (this.allowNull && buf.read() == 0) {
            buf.skip(this.getDataLength());
            return null;
        }
        long l = 0L;
        l |= (long)(buf.read() & 0xFF ^ 0x80);
        for (int i = 0; i < 7; ++i) {
            l <<= 8;
            l |= (long)(buf.read() & 0xFF);
        }
        return l;
    }

    @Override
    public Long decodeKeyV2(Buf buf) {
        return this.decodeKey(buf);
    }

    @Override
    public Long decodeKeyPrefix(Buf buf) {
        return this.decodeKey(buf);
    }

    @Override
    public void skipKey(Buf buf) {
        buf.skip(this.getLength());
    }

    @Override
    public void skipKeyV2(Buf buf) {
        this.skipKey(buf);
    }

    @Override
    public void encodeKeyPrefix(Buf buf, Long data) {
        this.encodeKey(buf, data);
    }

    @Override
    public void encodeValue(Buf buf, Long data) {
        if (this.allowNull) {
            buf.ensureRemainder(this.getWithNullTagLength());
            if (data == null) {
                buf.write((byte)0);
                this.internalEncodeNull(buf);
            } else {
                buf.write((byte)1);
                this.internalEncodeValue(buf, data);
            }
        } else {
            buf.ensureRemainder(this.getDataLength());
            this.internalEncodeValue(buf, data);
        }
    }

    @Override
    public int encodeValueV2(Buf buf, Long data) {
        int len = this.getValueLengthV2();
        buf.ensureRemainder(len);
        if (this.allowNull) {
            if (data == null) {
                return 0;
            }
            this.internalEncodeValue(buf, data);
        } else {
            this.internalEncodeValue(buf, data);
        }
        return len;
    }

    private void internalEncodeValue(Buf buf, Long data) {
        buf.write((byte)(data >>> 56));
        buf.write((byte)(data >>> 48));
        buf.write((byte)(data >>> 40));
        buf.write((byte)(data >>> 32));
        buf.write((byte)(data >>> 24));
        buf.write((byte)(data >>> 16));
        buf.write((byte)(data >>> 8));
        buf.write((byte)data.longValue());
    }

    @Override
    public Long decodeValue(Buf buf) {
        if (this.allowNull && buf.read() == 0) {
            buf.skip(this.getDataLength());
            return null;
        }
        long l = buf.read() & 0xFF;
        for (int i = 0; i < 7; ++i) {
            l <<= 8;
            l |= (long)(buf.read() & 0xFF);
        }
        return l;
    }

    @Override
    public Long decodeValueV2(Buf buf) {
        long l = buf.read() & 0xFF;
        for (int i = 0; i < 7; ++i) {
            l <<= 8;
            l |= (long)(buf.read() & 0xFF);
        }
        return l;
    }

    @Override
    public void skipValue(Buf buf) {
        buf.skip(this.getLength());
    }

    @Override
    public void skipValueV2(Buf buf) {
        buf.skip(this.getValueLengthV2());
    }
}

