/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.common.serial.schema;

import io.dingodb.sdk.common.serial.Buf;
import io.dingodb.sdk.common.serial.schema.DingoSchema;
import io.dingodb.sdk.common.serial.schema.Type;

public class FloatSchema
implements DingoSchema<Float> {
    private int index;
    private boolean isKey;
    private boolean allowNull = true;

    public FloatSchema() {
    }

    public FloatSchema(int index) {
        this.index = index;
    }

    @Override
    public Type getType() {
        return Type.FLOAT;
    }

    @Override
    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public void setIsKey(boolean isKey) {
        this.isKey = isKey;
    }

    @Override
    public boolean isKey() {
        return this.isKey;
    }

    @Override
    public int getLength() {
        if (this.allowNull) {
            return this.getWithNullTagLength();
        }
        return this.getDataLength();
    }

    @Override
    public int getValueLengthV2() {
        return this.getDataLength();
    }

    @Override
    public int getWithNullTagLength() {
        return 5;
    }

    private int getDataLength() {
        return 4;
    }

    @Override
    public void setAllowNull(boolean allowNull) {
        this.allowNull = allowNull;
    }

    @Override
    public boolean isAllowNull() {
        return this.allowNull;
    }

    @Override
    public void encodeKey(Buf buf, Float data) {
        if (this.allowNull) {
            buf.ensureRemainder(this.getWithNullTagLength());
            if (data == null) {
                buf.write((byte)0);
                this.internalEncodeNull(buf);
            } else {
                buf.write((byte)1);
                this.internalEncodeKey(buf, data);
            }
        } else {
            buf.ensureRemainder(this.getDataLength());
            this.internalEncodeKey(buf, data);
        }
    }

    @Override
    public void encodeKeyV2(Buf buf, Float data) {
        this.encodeKey(buf, data);
    }

    @Override
    public void encodeKeyForUpdate(Buf buf, Float data) {
        if (this.allowNull) {
            if (data == null) {
                buf.write((byte)0);
                this.internalEncodeNull(buf);
            } else {
                buf.write((byte)1);
                this.internalEncodeKey(buf, data);
            }
        } else {
            this.internalEncodeKey(buf, data);
        }
    }

    @Override
    public void encodeKeyForUpdateV2(Buf buf, Float data) {
        if (this.allowNull) {
            if (data == null) {
                buf.write((byte)0);
                this.internalEncodeNull(buf);
            } else {
                buf.write((byte)1);
                this.internalEncodeKey(buf, data);
            }
        } else {
            if (data == null) {
                throw new RuntimeException("Data is not allow as null.");
            }
            buf.write((byte)1);
            this.internalEncodeKey(buf, data);
        }
    }

    private void internalEncodeNull(Buf buf) {
        buf.write((byte)0);
        buf.write((byte)0);
        buf.write((byte)0);
        buf.write((byte)0);
    }

    private void internalEncodeKey(Buf buf, Float data) {
        int in = Float.floatToIntBits(data.floatValue());
        if (data.floatValue() >= 0.0f) {
            buf.write((byte)(in >>> 24 ^ 0x80));
            buf.write((byte)(in >>> 16));
            buf.write((byte)(in >>> 8));
            buf.write((byte)in);
        } else {
            buf.write((byte)(~in >>> 24));
            buf.write((byte)(~in >>> 16));
            buf.write((byte)(~in >>> 8));
            buf.write((byte)(~in));
        }
    }

    @Override
    public Float decodeKey(Buf buf) {
        if (this.allowNull && buf.read() == 0) {
            buf.skip(this.getDataLength());
            return null;
        }
        int in = buf.read() & 0xFF;
        if (in >= 128) {
            in ^= 0x80;
            for (int i = 0; i < 3; ++i) {
                in <<= 8;
                in |= buf.read() & 0xFF;
            }
        } else {
            in ^= 0xFFFFFFFF;
            for (int i = 0; i < 3; ++i) {
                in <<= 8;
                in |= ~buf.read() & 0xFF;
            }
        }
        return Float.valueOf(Float.intBitsToFloat(in));
    }

    @Override
    public Float decodeKeyV2(Buf buf) {
        return this.decodeKey(buf);
    }

    @Override
    public Float decodeKeyPrefix(Buf buf) {
        return this.decodeKey(buf);
    }

    @Override
    public void skipKey(Buf buf) {
        buf.skip(this.getLength());
    }

    @Override
    public void skipKeyV2(Buf buf) {
        this.skipKey(buf);
    }

    @Override
    public void encodeKeyPrefix(Buf buf, Float data) {
        this.encodeKey(buf, data);
    }

    @Override
    public void encodeValue(Buf buf, Float data) {
        if (this.allowNull) {
            buf.ensureRemainder(this.getWithNullTagLength());
            if (data == null) {
                buf.write((byte)0);
                this.internalEncodeNull(buf);
            } else {
                buf.write((byte)1);
                this.internalEncodeValue(buf, data);
            }
        } else {
            buf.ensureRemainder(this.getDataLength());
            this.internalEncodeValue(buf, data);
        }
    }

    @Override
    public int encodeValueV2(Buf buf, Float data) {
        int len = this.getValueLengthV2();
        buf.ensureRemainder(len);
        if (this.allowNull) {
            if (data == null) {
                return 0;
            }
            this.internalEncodeValue(buf, data);
        } else {
            this.internalEncodeValue(buf, data);
        }
        return len;
    }

    private void internalEncodeValue(Buf buf, Float data) {
        int in = Float.floatToIntBits(data.floatValue());
        buf.write((byte)(in >>> 24));
        buf.write((byte)(in >>> 16));
        buf.write((byte)(in >>> 8));
        buf.write((byte)in);
    }

    @Override
    public Float decodeValue(Buf buf) {
        if (this.allowNull && buf.read() == 0) {
            buf.skip(this.getDataLength());
            return null;
        }
        int in = buf.read() & 0xFF;
        for (int i = 0; i < 3; ++i) {
            in <<= 8;
            in |= buf.read() & 0xFF;
        }
        return Float.valueOf(Float.intBitsToFloat(in));
    }

    @Override
    public Float decodeValueV2(Buf buf) {
        int in = buf.read() & 0xFF;
        for (int i = 0; i < 3; ++i) {
            in <<= 8;
            in |= buf.read() & 0xFF;
        }
        return Float.valueOf(Float.intBitsToFloat(in));
    }

    @Override
    public void skipValue(Buf buf) {
        buf.skip(this.getLength());
    }

    @Override
    public void skipValueV2(Buf buf) {
        buf.skip(this.getValueLengthV2());
    }
}

