/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.common.serial.schema;

import io.dingodb.sdk.common.serial.Buf;
import io.dingodb.sdk.common.serial.schema.DingoSchema;
import io.dingodb.sdk.common.serial.schema.Type;

public class DoubleSchema
implements DingoSchema<Double> {
    private int index;
    private boolean isKey;
    private boolean allowNull = true;

    public DoubleSchema() {
    }

    public DoubleSchema(int index) {
        this.index = index;
    }

    @Override
    public Type getType() {
        return Type.DOUBLE;
    }

    @Override
    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public void setIsKey(boolean isKey) {
        this.isKey = isKey;
    }

    @Override
    public boolean isKey() {
        return this.isKey;
    }

    @Override
    public int getLength() {
        if (this.allowNull) {
            return this.getWithNullTagLength();
        }
        return this.getDataLength();
    }

    @Override
    public int getValueLengthV2() {
        return this.getDataLength();
    }

    @Override
    public int getWithNullTagLength() {
        return 9;
    }

    private int getDataLength() {
        return 8;
    }

    @Override
    public void setAllowNull(boolean allowNull) {
        this.allowNull = allowNull;
    }

    @Override
    public boolean isAllowNull() {
        return this.allowNull;
    }

    @Override
    public void encodeKey(Buf buf, Double data) {
        if (this.allowNull) {
            buf.ensureRemainder(this.getWithNullTagLength());
            if (data == null) {
                buf.write((byte)0);
                this.internalEncodeNull(buf);
            } else {
                buf.write((byte)1);
                this.internalEncodeKey(buf, data);
            }
        } else {
            buf.ensureRemainder(this.getDataLength());
            this.internalEncodeKey(buf, data);
        }
    }

    @Override
    public void encodeKeyV2(Buf buf, Double data) {
        this.encodeKey(buf, data);
    }

    @Override
    public void encodeKeyForUpdate(Buf buf, Double data) {
        if (this.allowNull) {
            if (data == null) {
                buf.write((byte)0);
                this.internalEncodeNull(buf);
            } else {
                buf.write((byte)1);
                this.internalEncodeKey(buf, data);
            }
        } else {
            this.internalEncodeKey(buf, data);
        }
    }

    @Override
    public void encodeKeyForUpdateV2(Buf buf, Double data) {
        if (this.allowNull) {
            if (data == null) {
                buf.write((byte)0);
                this.internalEncodeNull(buf);
            } else {
                buf.write((byte)1);
                this.internalEncodeKey(buf, data);
            }
        } else {
            if (data == null) {
                throw new RuntimeException("Data is not allow as null.");
            }
            buf.write((byte)1);
            this.internalEncodeKey(buf, data);
        }
    }

    private void internalEncodeNull(Buf buf) {
        buf.write((byte)0);
        buf.write((byte)0);
        buf.write((byte)0);
        buf.write((byte)0);
        buf.write((byte)0);
        buf.write((byte)0);
        buf.write((byte)0);
        buf.write((byte)0);
    }

    private void internalEncodeKey(Buf buf, Double data) {
        long ln = Double.doubleToLongBits(data);
        if (data >= 0.0) {
            buf.write((byte)(ln >>> 56 ^ 0x80L));
            buf.write((byte)(ln >>> 48));
            buf.write((byte)(ln >>> 40));
            buf.write((byte)(ln >>> 32));
            buf.write((byte)(ln >>> 24));
            buf.write((byte)(ln >>> 16));
            buf.write((byte)(ln >>> 8));
            buf.write((byte)ln);
        } else {
            buf.write((byte)((ln ^ 0xFFFFFFFFFFFFFFFFL) >>> 56));
            buf.write((byte)((ln ^ 0xFFFFFFFFFFFFFFFFL) >>> 48));
            buf.write((byte)((ln ^ 0xFFFFFFFFFFFFFFFFL) >>> 40));
            buf.write((byte)((ln ^ 0xFFFFFFFFFFFFFFFFL) >>> 32));
            buf.write((byte)((ln ^ 0xFFFFFFFFFFFFFFFFL) >>> 24));
            buf.write((byte)((ln ^ 0xFFFFFFFFFFFFFFFFL) >>> 16));
            buf.write((byte)((ln ^ 0xFFFFFFFFFFFFFFFFL) >>> 8));
            buf.write((byte)(ln ^ 0xFFFFFFFFFFFFFFFFL));
        }
    }

    @Override
    public Double decodeKey(Buf buf) {
        if (this.allowNull && buf.read() == 0) {
            buf.skip(this.getDataLength());
            return null;
        }
        long l = buf.read() & 0xFF;
        if (l >= 128L) {
            l ^= 0x80L;
            for (int i = 0; i < 7; ++i) {
                l <<= 8;
                l |= (long)(buf.read() & 0xFF);
            }
        } else {
            l ^= 0xFFFFFFFFFFFFFFFFL;
            for (int i = 0; i < 7; ++i) {
                l <<= 8;
                l |= (long)(~buf.read() & 0xFF);
            }
        }
        return Double.longBitsToDouble(l);
    }

    @Override
    public Double decodeKeyV2(Buf buf) {
        return this.decodeKey(buf);
    }

    @Override
    public Double decodeKeyPrefix(Buf buf) {
        return this.decodeKey(buf);
    }

    @Override
    public void skipKey(Buf buf) {
        buf.skip(this.getLength());
    }

    @Override
    public void skipKeyV2(Buf buf) {
        this.skipKey(buf);
    }

    @Override
    public void encodeKeyPrefix(Buf buf, Double data) {
        this.encodeKey(buf, data);
    }

    @Override
    public void encodeValue(Buf buf, Double data) {
        if (this.allowNull) {
            buf.ensureRemainder(this.getWithNullTagLength());
            if (data == null) {
                buf.write((byte)0);
                this.internalEncodeNull(buf);
            } else {
                buf.write((byte)1);
                this.internalEncodeValue(buf, data);
            }
        } else {
            buf.ensureRemainder(this.getDataLength());
            this.internalEncodeValue(buf, data);
        }
    }

    @Override
    public int encodeValueV2(Buf buf, Double data) {
        int len = this.getValueLengthV2();
        buf.ensureRemainder(len);
        if (this.allowNull) {
            if (data == null) {
                return 0;
            }
            this.internalEncodeValue(buf, data);
        } else {
            this.internalEncodeValue(buf, data);
        }
        return len;
    }

    private void internalEncodeValue(Buf buf, Double data) {
        long ln = Double.doubleToLongBits(data);
        buf.write((byte)(ln >>> 56));
        buf.write((byte)(ln >>> 48));
        buf.write((byte)(ln >>> 40));
        buf.write((byte)(ln >>> 32));
        buf.write((byte)(ln >>> 24));
        buf.write((byte)(ln >>> 16));
        buf.write((byte)(ln >>> 8));
        buf.write((byte)ln);
    }

    @Override
    public Double decodeValue(Buf buf) {
        if (this.allowNull && buf.read() == 0) {
            buf.skip(this.getDataLength());
            return null;
        }
        long l = buf.read() & 0xFF;
        for (int i = 0; i < 7; ++i) {
            l <<= 8;
            l |= (long)(buf.read() & 0xFF);
        }
        return Double.longBitsToDouble(l);
    }

    @Override
    public Double decodeValueV2(Buf buf) {
        long l = buf.read() & 0xFF;
        for (int i = 0; i < 7; ++i) {
            l <<= 8;
            l |= (long)(buf.read() & 0xFF);
        }
        return Double.longBitsToDouble(l);
    }

    @Override
    public void skipValue(Buf buf) {
        buf.skip(this.getLength());
    }

    @Override
    public void skipValueV2(Buf buf) {
        buf.skip(this.getValueLengthV2());
    }
}

