/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.common.serial.schema;

import io.dingodb.sdk.common.serial.Buf;
import io.dingodb.sdk.common.serial.schema.DingoSchema;
import io.dingodb.sdk.common.serial.schema.Type;
import java.util.ArrayList;
import java.util.List;

public class DoubleListSchema
implements DingoSchema<List<Double>> {
    private int index;
    private boolean isKey;
    private boolean allowNull = true;

    public DoubleListSchema() {
    }

    public DoubleListSchema(int index) {
        this.index = index;
    }

    @Override
    public Type getType() {
        return Type.DOUBLELIST;
    }

    @Override
    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public void setIsKey(boolean isKey) {
        this.isKey = isKey;
    }

    @Override
    public boolean isKey() {
        return this.isKey;
    }

    @Override
    public int getLength() {
        if (this.allowNull) {
            return this.getWithNullTagLength();
        }
        return this.getDataLength();
    }

    @Override
    public int getValueLengthV2() {
        return 0;
    }

    @Override
    public int getWithNullTagLength() {
        return 9;
    }

    private int getDataLength() {
        return 8;
    }

    @Override
    public void setAllowNull(boolean allowNull) {
        this.allowNull = allowNull;
    }

    @Override
    public boolean isAllowNull() {
        return this.allowNull;
    }

    @Override
    public void encodeKey(Buf buf, List<Double> data) {
        throw new RuntimeException("Array cannot be key");
    }

    @Override
    public void encodeKeyV2(Buf buf, List<Double> data) {
        throw new RuntimeException("Array cannot be key");
    }

    @Override
    public void encodeKeyForUpdate(Buf buf, List<Double> data) {
        throw new RuntimeException("Array cannot be key");
    }

    @Override
    public void encodeKeyForUpdateV2(Buf buf, List<Double> data) {
        throw new RuntimeException("Array cannot be key");
    }

    @Override
    public List<Double> decodeKey(Buf buf) {
        throw new RuntimeException("Array cannot be key");
    }

    @Override
    public List<Double> decodeKeyV2(Buf buf) {
        throw new RuntimeException("Array cannot be key");
    }

    @Override
    public List<Double> decodeKeyPrefix(Buf buf) {
        throw new RuntimeException("Array cannot be key");
    }

    @Override
    public void skipKey(Buf buf) {
        throw new RuntimeException("Array cannot be key");
    }

    @Override
    public void skipKeyV2(Buf buf) {
        throw new RuntimeException("Array cannot be key");
    }

    @Override
    public void encodeKeyPrefix(Buf buf, List<Double> data) {
        throw new RuntimeException("Array cannot be key");
    }

    @Override
    public void encodeValue(Buf buf, List<Double> data) {
        if (this.allowNull) {
            if (data == null) {
                buf.ensureRemainder(1);
                buf.write((byte)0);
            } else {
                buf.ensureRemainder(9 + data.size() * 8);
                buf.write((byte)1);
                buf.writeInt(data.size());
                for (Double value : data) {
                    if (value == null) {
                        throw new IllegalArgumentException("Array type sub-elements do not support null values");
                    }
                    this.internalEncodeValue(buf, value);
                }
            }
        } else {
            buf.ensureRemainder(8 + data.size() * 8);
            buf.writeInt(data.size());
            for (Double value : data) {
                if (value == null) {
                    throw new IllegalArgumentException("Array type sub-elements do not support null values");
                }
                this.internalEncodeValue(buf, value);
            }
        }
    }

    @Override
    public int encodeValueV2(Buf buf, List<Double> data) {
        int len = 0;
        if (this.allowNull) {
            if (data == null) {
                return 0;
            }
            len = 4 + data.size() * 8;
            buf.ensureRemainder(len);
            buf.writeInt(data.size());
            for (Double value : data) {
                if (value == null) {
                    throw new IllegalArgumentException("Array type sub-elements do not support null values");
                }
                this.internalEncodeValue(buf, value);
            }
        } else {
            len = 4 + data.size() * 8;
            buf.ensureRemainder(len);
            buf.writeInt(data.size());
            for (Double value : data) {
                if (value == null) {
                    throw new IllegalArgumentException("Array type sub-elements do not support null values");
                }
                this.internalEncodeValue(buf, value);
            }
        }
        return len;
    }

    private void internalEncodeValue(Buf buf, Double data) {
        long ln = Double.doubleToLongBits(data);
        buf.write((byte)(ln >>> 56));
        buf.write((byte)(ln >>> 48));
        buf.write((byte)(ln >>> 40));
        buf.write((byte)(ln >>> 32));
        buf.write((byte)(ln >>> 24));
        buf.write((byte)(ln >>> 16));
        buf.write((byte)(ln >>> 8));
        buf.write((byte)ln);
    }

    private Double internalDecodeData(Buf buf) {
        long l = buf.read() & 0xFF;
        for (int i = 0; i < 7; ++i) {
            l <<= 8;
            l |= (long)(buf.read() & 0xFF);
        }
        return Double.longBitsToDouble(l);
    }

    @Override
    public List<Double> decodeValue(Buf buf) {
        if (this.allowNull && buf.read() == 0) {
            return null;
        }
        int size = buf.readInt();
        ArrayList<Double> data = new ArrayList<Double>(size);
        for (int i = 0; i < size; ++i) {
            data.add(this.internalDecodeData(buf));
        }
        return data;
    }

    @Override
    public List<Double> decodeValueV2(Buf buf) {
        int size = buf.readInt();
        ArrayList<Double> data = new ArrayList<Double>(size);
        for (int i = 0; i < size; ++i) {
            data.add(this.internalDecodeData(buf));
        }
        return data;
    }

    @Override
    public void skipValue(Buf buf) {
        if (this.allowNull && buf.read() == 0) {
            return;
        }
        int length = buf.readInt();
        buf.skip(length * 8);
    }

    @Override
    public void skipValueV2(Buf buf) {
        int length = buf.readInt();
        buf.skip(length * 8);
    }
}

