/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.common.serial.schema;

import io.dingodb.sdk.common.serial.Buf;
import io.dingodb.sdk.common.serial.schema.DingoSchema;
import io.dingodb.sdk.common.serial.schema.Type;

public class BytesSchema
implements DingoSchema<byte[]> {
    private int index;
    private boolean isKey = false;
    private boolean allowNull = true;

    public BytesSchema() {
    }

    public BytesSchema(int index) {
        this.index = index;
    }

    @Override
    public Type getType() {
        return Type.BYTES;
    }

    @Override
    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public void setIsKey(boolean isKey) {
        this.isKey = isKey;
    }

    @Override
    public boolean isKey() {
        return this.isKey;
    }

    @Override
    public int getLength() {
        return 0;
    }

    @Override
    public int getValueLengthV2() {
        return 0;
    }

    @Override
    public int getWithNullTagLength() {
        return 1;
    }

    @Override
    public void setAllowNull(boolean allowNull) {
        this.allowNull = allowNull;
    }

    @Override
    public boolean isAllowNull() {
        return this.allowNull;
    }

    @Override
    public void encodeKey(Buf buf, byte[] data) {
        if (this.allowNull) {
            if (data == null) {
                buf.ensureRemainder(5);
                buf.write((byte)0);
                buf.reverseWriteInt0();
            } else {
                buf.ensureRemainder(1);
                buf.write((byte)1);
                int size = this.internalEncodeKey(buf, data);
                buf.ensureRemainder(4);
                buf.reverseWriteInt(size);
            }
        } else {
            int size = this.internalEncodeKey(buf, data);
            buf.ensureRemainder(4);
            buf.reverseWriteInt(size);
        }
    }

    @Override
    public void encodeKeyV2(Buf buf, byte[] data) {
        if (this.allowNull) {
            if (data == null) {
                buf.ensureRemainder(5);
                buf.write((byte)0);
                buf.reverseWriteInt0();
            } else {
                buf.ensureRemainder(1);
                buf.write((byte)1);
                int size = this.internalEncodeKey(buf, data);
                buf.ensureRemainder(4);
                buf.reverseWriteInt(size);
            }
        } else {
            if (data == null) {
                throw new RuntimeException("Data is not allow as null.");
            }
            buf.ensureRemainder(1);
            buf.write((byte)1);
            int size = this.internalEncodeKey(buf, data);
            buf.ensureRemainder(4);
            buf.reverseWriteInt(size);
        }
    }

    private int internalEncodeKey(Buf buf, byte[] data) {
        int i;
        int remaindZero;
        int groupNum = data.length / 8;
        int size = (groupNum + 1) * 9;
        int remainderSize = data.length % 8;
        if (remainderSize == 0) {
            remainderSize = 8;
            remaindZero = 8;
        } else {
            remaindZero = 8 - remainderSize;
        }
        buf.ensureRemainder(size);
        for (i = 0; i < groupNum; ++i) {
            buf.write(data, 8 * i, 8);
            buf.write((byte)-1);
        }
        if (remainderSize < 8) {
            buf.write(data, 8 * groupNum, remainderSize);
        }
        for (i = 0; i < remaindZero; ++i) {
            buf.write((byte)0);
        }
        buf.write((byte)(255 - remaindZero));
        return size;
    }

    @Override
    public void encodeKeyForUpdate(Buf buf, byte[] data) {
        if (this.allowNull) {
            if (data == null) {
                buf.write((byte)0);
                buf.reverseWriteInt0();
            } else {
                buf.write((byte)1);
                buf.reverseWriteInt(this.internalEncodeKeyForUpdate(buf, data));
            }
        } else {
            buf.reverseWriteInt(this.internalEncodeKeyForUpdate(buf, data));
        }
    }

    @Override
    public void encodeKeyForUpdateV2(Buf buf, byte[] data) {
        if (this.allowNull) {
            if (data == null) {
                buf.write((byte)0);
                buf.reverseWriteInt0();
            } else {
                buf.write((byte)1);
                buf.reverseWriteInt(this.internalEncodeKeyForUpdate(buf, data));
            }
        } else {
            if (data == null) {
                throw new RuntimeException("Data is not allow as null.");
            }
            buf.write((byte)1);
            buf.reverseWriteInt(this.internalEncodeKeyForUpdate(buf, data));
        }
    }

    private int internalEncodeKeyForUpdate(Buf buf, byte[] data) {
        int i;
        int remaindZero;
        int groupNum = data.length / 8;
        int size = (groupNum + 1) * 9;
        int remainderSize = data.length % 8;
        if (remainderSize == 0) {
            remainderSize = 8;
            remaindZero = 8;
        } else {
            remaindZero = 8 - remainderSize;
        }
        int oldSize = buf.reverseReadInt();
        buf.reverseSkip(-4);
        buf.resize(oldSize, size);
        for (i = 0; i < groupNum; ++i) {
            buf.write(data, 8 * i, 8);
            buf.write((byte)-1);
        }
        if (remainderSize < 8) {
            buf.write(data, 8 * groupNum, remainderSize);
        }
        for (i = 0; i < remaindZero; ++i) {
            buf.write((byte)0);
        }
        buf.write((byte)(255 - remaindZero));
        return size;
    }

    @Override
    public byte[] decodeKey(Buf buf) {
        if (this.allowNull && buf.read() == 0) {
            buf.reverseSkipInt();
            return null;
        }
        return this.internalReadBytes(buf);
    }

    @Override
    public byte[] decodeKeyV2(Buf buf) {
        if (buf.read() == 0) {
            buf.reverseSkipInt();
            return null;
        }
        return this.internalReadBytes(buf);
    }

    @Override
    public byte[] decodeKeyPrefix(Buf buf) {
        if (this.allowNull && buf.read() == 0) {
            return null;
        }
        return this.internalReadKeyPrefixBytes(buf);
    }

    private byte[] internalReadKeyPrefixBytes(Buf buf) {
        int length = 0;
        do {
            length += 9;
            buf.skip(8);
        } while (buf.read() == -1);
        int groupNum = length / 9;
        buf.skip(-1);
        int reminderZero = 255 - buf.read() & 0xFF;
        buf.skip(0 - length);
        int oriLength = groupNum * 8 - reminderZero;
        byte[] data = new byte[oriLength];
        if (oriLength != 0) {
            --groupNum;
            for (int i = 0; i < groupNum; ++i) {
                buf.read(data, 8 * i, 8);
                buf.skip(1);
            }
            if (reminderZero != 8) {
                buf.read(data, 8 * groupNum, 8 - reminderZero);
            }
        }
        buf.skip(reminderZero + 1);
        return data;
    }

    private byte[] internalReadBytes(Buf buf) {
        int length = buf.reverseReadInt();
        int groupNum = length / 9;
        buf.skip(length - 1);
        int reminderZero = 255 - buf.read() & 0xFF;
        buf.skip(0 - length);
        int oriLength = groupNum * 8 - reminderZero;
        byte[] data = new byte[oriLength];
        if (oriLength != 0) {
            --groupNum;
            for (int i = 0; i < groupNum; ++i) {
                buf.read(data, 8 * i, 8);
                buf.skip(1);
            }
            if (reminderZero != 8) {
                buf.read(data, 8 * groupNum, 8 - reminderZero);
            }
        }
        buf.skip(reminderZero + 1);
        return data;
    }

    @Override
    public void skipKey(Buf buf) {
        buf.skip(buf.reverseReadInt());
    }

    @Override
    public void skipKeyV2(Buf buf) {
        buf.skip(buf.reverseReadInt());
    }

    @Override
    public void encodeKeyPrefix(Buf buf, byte[] data) {
        if (this.allowNull) {
            buf.ensureRemainder(1);
            if (data == null) {
                buf.write((byte)0);
            } else {
                buf.write((byte)1);
                this.internalEncodeKey(buf, data);
            }
        } else {
            this.internalEncodeKey(buf, data);
        }
    }

    @Override
    public void encodeValue(Buf buf, byte[] data) {
        if (this.allowNull) {
            if (data == null) {
                buf.ensureRemainder(1);
                buf.write((byte)0);
            } else {
                buf.ensureRemainder(5 + data.length);
                buf.write((byte)1);
                buf.writeInt(data.length);
                buf.write(data);
            }
        } else {
            buf.ensureRemainder(4 + data.length);
            buf.writeInt(data.length);
            buf.write(data);
        }
    }

    @Override
    public int encodeValueV2(Buf buf, byte[] data) {
        int len = 0;
        if (this.allowNull) {
            if (data == null) {
                return 0;
            }
            len = 4 + data.length;
            buf.ensureRemainder(len);
            buf.writeInt(data.length);
            buf.write(data);
        } else {
            len = 4 + data.length;
            buf.ensureRemainder(len);
            buf.writeInt(data.length);
            buf.write(data);
        }
        return len;
    }

    @Override
    public byte[] decodeValue(Buf buf) {
        if (this.allowNull) {
            if (buf.read() == 0) {
                return null;
            }
            return buf.read(buf.readInt());
        }
        return buf.read(buf.readInt());
    }

    @Override
    public byte[] decodeValueV2(Buf buf) {
        return buf.read(buf.readInt());
    }

    @Override
    public void skipValue(Buf buf) {
        if (this.allowNull) {
            if (buf.read() == 1) {
                buf.skip(buf.readInt());
            }
        } else {
            buf.skip(buf.readInt());
        }
    }

    @Override
    public void skipValueV2(Buf buf) {
        buf.skip(buf.readInt());
    }
}

