/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.common.serial.schema;

import io.dingodb.sdk.common.serial.Buf;
import io.dingodb.sdk.common.serial.schema.DingoSchema;
import io.dingodb.sdk.common.serial.schema.Type;

public class BooleanSchema
implements DingoSchema<Boolean> {
    private int index;
    private boolean isKey;
    private boolean allowNull = true;

    public BooleanSchema() {
    }

    public BooleanSchema(int index) {
        this.index = index;
    }

    @Override
    public Type getType() {
        return Type.BOOLEAN;
    }

    @Override
    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public void setIsKey(boolean isKey) {
        this.isKey = isKey;
    }

    @Override
    public boolean isKey() {
        return this.isKey;
    }

    @Override
    public int getLength() {
        if (this.allowNull) {
            return this.getWithNullTagLength();
        }
        return this.getDataLength();
    }

    @Override
    public int getValueLengthV2() {
        return this.getDataLength();
    }

    @Override
    public int getWithNullTagLength() {
        return 2;
    }

    private int getDataLength() {
        return 1;
    }

    @Override
    public void setAllowNull(boolean allowNull) {
        this.allowNull = allowNull;
    }

    @Override
    public boolean isAllowNull() {
        return this.allowNull;
    }

    @Override
    public void encodeKey(Buf buf, Boolean data) {
        if (this.allowNull) {
            buf.ensureRemainder(this.getWithNullTagLength());
            if (data == null) {
                buf.write((byte)0);
                this.internalEncodeNull(buf);
            } else {
                buf.write((byte)1);
                this.internalEncodeData(buf, data);
            }
        } else {
            buf.ensureRemainder(this.getDataLength());
            this.internalEncodeData(buf, data);
        }
    }

    @Override
    public void encodeKeyV2(Buf buf, Boolean data) {
        this.encodeKey(buf, data);
    }

    @Override
    public void encodeKeyForUpdate(Buf buf, Boolean data) {
        if (this.allowNull) {
            if (data == null) {
                buf.write((byte)0);
                this.internalEncodeNull(buf);
            } else {
                buf.write((byte)1);
                this.internalEncodeData(buf, data);
            }
        } else {
            this.internalEncodeData(buf, data);
        }
    }

    @Override
    public void encodeKeyForUpdateV2(Buf buf, Boolean data) {
        if (this.allowNull) {
            if (data == null) {
                buf.write((byte)0);
                this.internalEncodeNull(buf);
            } else {
                buf.write((byte)1);
                this.internalEncodeData(buf, data);
            }
        } else {
            if (data == null) {
                throw new RuntimeException("Data is not allow as null.");
            }
            buf.write((byte)1);
            this.internalEncodeData(buf, data);
        }
    }

    private void internalEncodeNull(Buf buf) {
        buf.write((byte)0);
    }

    private void internalEncodeData(Buf buf, Boolean boolVal) {
        if (boolVal.booleanValue()) {
            buf.write((byte)1);
        } else {
            buf.write((byte)0);
        }
    }

    @Override
    public Boolean decodeKey(Buf buf) {
        if (this.allowNull && buf.read() == 0) {
            buf.skip(this.getDataLength());
            return null;
        }
        return this.internalDecodeData(buf);
    }

    @Override
    public Boolean decodeKeyV2(Buf buf) {
        return this.decodeKey(buf);
    }

    @Override
    public Boolean decodeKeyPrefix(Buf buf) {
        return this.decodeKey(buf);
    }

    private Boolean internalDecodeData(Buf buf) {
        return buf.read() != 0;
    }

    @Override
    public void skipKey(Buf buf) {
        buf.skip(this.getLength());
    }

    @Override
    public void skipKeyV2(Buf buf) {
        this.skipKey(buf);
    }

    @Override
    public void encodeKeyPrefix(Buf buf, Boolean data) {
        this.encodeKey(buf, data);
    }

    @Override
    public void encodeValue(Buf buf, Boolean data) {
        if (this.allowNull) {
            buf.ensureRemainder(this.getWithNullTagLength());
            if (data == null) {
                buf.write((byte)0);
                this.internalEncodeNull(buf);
            } else {
                buf.write((byte)1);
                this.internalEncodeData(buf, data);
            }
        } else {
            buf.ensureRemainder(this.getDataLength());
            this.internalEncodeData(buf, data);
        }
    }

    @Override
    public int encodeValueV2(Buf buf, Boolean data) {
        int len = this.getValueLengthV2();
        buf.ensureRemainder(len);
        if (this.allowNull) {
            if (data == null) {
                return 0;
            }
            this.internalEncodeData(buf, data);
        } else {
            this.internalEncodeData(buf, data);
        }
        return len;
    }

    @Override
    public Boolean decodeValue(Buf buf) {
        if (this.allowNull && buf.read() == 0) {
            buf.skip(this.getDataLength());
            return null;
        }
        return this.internalDecodeData(buf);
    }

    @Override
    public Boolean decodeValueV2(Buf buf) {
        return this.internalDecodeData(buf);
    }

    @Override
    public void skipValue(Buf buf) {
        buf.skip(this.getLength());
    }

    @Override
    public void skipValueV2(Buf buf) {
        buf.skip(this.getValueLengthV2());
    }
}

